<?php
session_start();
require_once 'config/database.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $database = new Database();
    $conn = $database->getConnection();
    
    $id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
    $nome = $_POST['nome'];
    $banco = $_POST['banco'];
    $numero_cheque = $_POST['numero_cheque'];
    $data_repasse = $_POST['data_repasse'];
    $valor_repasse = str_replace(['.', ','], ['', '.'], $_POST['valor_repasse']);
    
    try {
        if ($id > 0) {
            // Atualização
            $sql = "UPDATE repasse_cheques SET 
                    nome = ?, 
                    banco = ?, 
                    numero_cheque = ?, 
                    data_repasse = ?, 
                    valor_repasse = ?,
                    status = COALESCE((SELECT status FROM (SELECT status FROM repasse_cheques WHERE id = ?) AS temp), 'pendente')
                    WHERE id = ?";
            
            $stmt = $conn->prepare($sql);
            $stmt->execute([$nome, $banco, $numero_cheque, $data_repasse, $valor_repasse, $id, $id]);
        } else {
            // Inserção
            $sql = "INSERT INTO repasse_cheques (nome, banco, numero_cheque, data_repasse, valor_repasse, status) 
                    VALUES (?, ?, ?, ?, ?, 'pendente')";
            
            $stmt = $conn->prepare($sql);
            $stmt->execute([$nome, $banco, $numero_cheque, $data_repasse, $valor_repasse]);
        }
        
        $_SESSION['mensagem'] = "Repasse " . ($id > 0 ? "atualizado" : "cadastrado") . " com sucesso!";
    } catch (PDOException $e) {
        $_SESSION['mensagem'] = "Erro ao " . ($id > 0 ? "atualizar" : "cadastrar") . " o repasse: " . $e->getMessage();
    }
}

header("Location: repasse_cheques_form.php");
exit();
?> 