<?php
session_start();
require_once 'config/database.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

// Verifica se é uma solicitação de impressão
$is_print = isset($_GET['print']) && $_GET['print'] == 'true';

if (!$is_print) {
    require_once 'includes/header.php';
    require_once 'includes/sidebar.php';
} else {
    // Inclui apenas o CSS necessário para impressão
    echo '<link rel="stylesheet" href="assets/css/adminlte.min.css">';
    echo '<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">';
}

// Inicializa a conexão
$database = new Database();
$conn = $database->getConnection();

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$repasse = null;

if ($id > 0) {
    $sql = "SELECT * FROM repasse_cheques WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->execute([$id]);
    $repasse = $stmt->fetch();

    // Verifica se o cheque está quitado e tenta editar
    if ($repasse && $repasse['status'] == 'pago') {
        $_SESSION['mensagem'] = "Não é possível editar um cheque já quitado.";
        header("Location: repasse_cheques_form.php");
        exit();
    }
}

// Busca todos os repasses para a tabela
$sql = "SELECT * FROM repasse_cheques ORDER BY data_repasse DESC";
$stmt = $conn->query($sql);
?>

<style>
.btn-primary {
    background-color: #007bff;
    border-color: #007bff;
    color: white;
    padding: 8px 15px;
    border-radius: 4px;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 5px;
}

.btn-secondary {
    background-color: #6c757d;
    border-color: #6c757d;
    color: white;
    padding: 8px 15px;
    border-radius: 4px;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 5px;
}

.btn-danger {
    background-color: #dc3545;
    border-color: #dc3545;
    color: white;
    padding: 8px 15px;
    border-radius: 4px;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 5px;
}

.btn-primary:hover {
    background-color: #0069d9;
    border-color: #0062cc;
    color: white;
}

.btn-secondary:hover {
    background-color: #5a6268;
    border-color: #545b62;
    color: white;
}

.btn-danger:hover {
    background-color: #c82333;
    border-color: #bd2130;
    color: white;
}

.form-actions {
    margin-top: 20px;
    display: flex;
    gap: 10px;
}

.acoes {
    display: flex;
    gap: 5px;
}

.acoes a {
    font-size: 0.875rem;
}

.btn-success {
    background-color: #28a745;
    border-color: #28a745;
    color: white;
    padding: 8px 15px;
    border-radius: 4px;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 5px;
    border: none;
    cursor: pointer;
    outline: none;
}

.btn-success:hover {
    background-color: #218838;
    border-color: #1e7e34;
    color: white;
}

.btn-success:focus {
    outline: none;
    box-shadow: none;
}

.status-pago {
    color: #28a745;
    font-weight: bold;
    display: inline-flex;
    align-items: center;
    gap: 5px;
    justify-content: center;
}

.status-pendente {
    color: #dc3545;
    font-weight: bold;
}

@media print {
    body {
        background: white !important;
        margin: 0 !important;
        padding: 20px !important;
    }

    .main-container {
        margin: 0 !important;
        padding: 0 !important;
        width: 100% !important;
    }

    .main-sidebar,
    .nav-sidebar,
    .sidebar,
    .form-actions,
    .acoes,
    .user-info,
    nav,
    aside,
    footer,
    .wrapper::before {
        display: none !important;
    }

    .content-wrapper {
        margin-left: 0 !important;
        background: white !important;
    }

    .wrapper {
        background: white !important;
    }
}
</style>

<div class="main-container">
    <div class="header">
        <h1>Repasse de Cheques</h1>
        <div class="user-info">
            <i class="fas fa-user"></i> Bem-vindo, <?php echo isset($_SESSION['user_name']) ? $_SESSION['user_name'] : 'Usuário'; ?>
        </div>
    </div>

    <div class="main-content">
        <!-- Formulário de Repasse -->
        <div class="card">
            <form action="repasse_cheques_save.php" method="post">
                <input type="hidden" name="id" value="<?php echo $id; ?>">
                <div class="form-grid">
                    <div class="form-group">
                        <label>Nome</label>
                        <input type="text" name="nome" value="<?php echo isset($repasse) ? $repasse['nome'] : ''; ?>" required>
                    </div>

                    <div class="form-group">
                        <label>Banco</label>
                        <input type="text" name="banco" value="<?php echo isset($repasse) ? $repasse['banco'] : ''; ?>" required>
                    </div>

                    <div class="form-group">
                        <label>Número do Cheque</label>
                        <input type="text" name="numero_cheque" value="<?php echo isset($repasse) ? $repasse['numero_cheque'] : ''; ?>" required>
                    </div>

                    <div class="form-group">
                        <label>Data do Repasse</label>
                        <input type="date" name="data_repasse" value="<?php echo isset($repasse) ? $repasse['data_repasse'] : date('Y-m-d'); ?>" required>
                    </div>

                    <div class="form-group">
                        <label>Valor do Repasse</label>
                        <input type="text" name="valor_repasse" class="money" value="<?php echo isset($repasse) ? number_format($repasse['valor_repasse'], 2, ',', '.') : ''; ?>" required>
                    </div>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn-success">
                        <i class="fas fa-save"></i> Salvar
                    </button>
                    <a href="repasse_cheques.php" class="btn-secondary">
                        <i class="fas fa-times"></i> Cancelar
                    </a>
                </div>
            </form>
        </div>

        <!-- Lista de Repasses -->
        <div class="card">
            <h2>Repasses Recentes</h2>
            <div class="table-responsive">
                <table id="example1">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Banco</th>
                            <th>Nº Cheque</th>
                            <th>Data</th>
                            <th>Valor</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $stmt->fetch()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row['nome']); ?></td>
                                <td><?php echo htmlspecialchars($row['banco']); ?></td>
                                <td><?php echo htmlspecialchars($row['numero_cheque']); ?></td>
                                <td><?php echo date('d/m/Y', strtotime($row['data_repasse'])); ?></td>
                                <td class="text-end">R$ <?php echo number_format($row['valor_repasse'], 2, ',', '.'); ?></td>
                                <td class="acoes">
                                    <?php if ($row['status'] != 'pago'): ?>
                                        <a href="repasse_cheques_quitar.php?id=<?php echo $row['id']; ?>" 
                                           class="btn-success" 
                                           onclick="return confirm('Confirmar a quitação deste cheque?')">
                                            <i class="fas fa-check"></i> <span>Quitar</span>
                                        </a>
                                        <a href="repasse_cheques_form.php?id=<?php echo $row['id']; ?>" class="btn-primary">
                                            <i class="fas fa-edit"></i> <span>Editar</span>
                                        </a>
                                    <?php else: ?>
                                        <span class="status-pago">
                                            <i class="fas fa-check-circle"></i> Quitado
                                        </span>
                                    <?php endif; ?>
                                    <a href="repasse_cheques_delete.php?id=<?php echo $row['id']; ?>" 
                                       class="btn-danger" 
                                       onclick="return confirm('Tem certeza que deseja excluir este registro?')">
                                        <i class="fas fa-trash"></i> <span>Excluir</span>
                                    </a>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    $('.money').mask('#.##0,00', {reverse: true});
});
</script>

<?php require_once 'includes/footer.php'; ?> 