<?php
session_start();
require_once 'config/database.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Usuário não autenticado']);
    exit;
}

try {
    if (!isset($_POST['cheque_id'])) {
        throw new Exception('ID do cheque não fornecido');
    }

    $database = new Database();
    $db = $database->getConnection();

    // Verifica se o cheque existe e pertence ao usuário
    $stmt = $db->prepare("SELECT id FROM cheques WHERE id = :cheque_id AND user_id = :user_id");
    $stmt->bindParam(':cheque_id', $_POST['cheque_id']);
    $stmt->bindParam(':user_id', $_SESSION['user_id']);
    $stmt->execute();

    if (!$stmt->fetch()) {
        throw new Exception('Cheque não encontrado ou não pertence ao usuário');
    }

    // Atualiza o status do cheque
    $stmt = $db->prepare("UPDATE cheques SET status_pagamento = 'pago' WHERE id = :cheque_id AND user_id = :user_id");
    $stmt->bindParam(':cheque_id', $_POST['cheque_id']);
    $stmt->bindParam(':user_id', $_SESSION['user_id']);

    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Cheque quitado com sucesso']);
    } else {
        throw new Exception('Erro ao quitar o cheque');
    }

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?> 