<?php
session_start();
require_once 'config/database.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success' => false, 'message' => 'Usuário não autenticado']);
    exit;
}

try {
    $database = new Database();
    $db = $database->getConnection();
    
    // Aceita tanto POST normal quanto JSON
    $id = isset($_POST['id']) ? $_POST['id'] : null;
    if (!$id) {
        $input = json_decode(file_get_contents('php://input'), true);
        $id = isset($input['id']) ? $input['id'] : null;
    }
    
    if (!$id) {
        throw new Exception("ID do cheque não fornecido");
    }

    // Verifica se o cheque existe e pertence ao usuário
    $checkStmt = $db->prepare("SELECT id FROM cheques WHERE id = :id AND user_id = :user_id AND status_pagamento = 'pendente'");
    $checkStmt->bindValue(':id', $id);
    $checkStmt->bindValue(':user_id', $_SESSION['user_id']);
    $checkStmt->execute();
    
    if (!$checkStmt->fetch()) {
        throw new Exception("Cheque não encontrado ou já está pago");
    }
    
    $stmt = $db->prepare("UPDATE cheques SET status_pagamento = 'pago', data_pagamento = NOW() 
                         WHERE id = :id AND user_id = :user_id");
    
    $stmt->bindValue(':id', $id);
    $stmt->bindValue(':user_id', $_SESSION['user_id']);
    
    if($stmt->execute()) {
        echo json_encode(['success' => true, 'message' => 'Cheque marcado como pago com sucesso']);
    } else {
        throw new Exception("Erro ao marcar cheque como pago");
    }
} catch(Exception $e) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
