DROP DATABASE IF EXISTS trocacheque;
CREATE DATABASE trocacheque;
USE trocacheque;

CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    email VARCHAR(100) NOT NULL UNIQUE,
    password VARCHAR(255) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Criar um usuário padrão (senha: 123456)
INSERT INTO users (name, email, password) VALUES ('Admin', 'admin@admin.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi');

CREATE TABLE cheques (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    cliente VARCHAR(100) NOT NULL,
    numero_cheque VARCHAR(20) NOT NULL,
    banco VARCHAR(50) NOT NULL,
    valor DECIMAL(10,2) NOT NULL,
    data_troca DATE NOT NULL,
    data_vencimento DATE NOT NULL,
    juros DECIMAL(10,2) NOT NULL,
    valor_total DECIMAL(10,2) NOT NULL,
    status_pagamento ENUM('pendente', 'pago') DEFAULT 'pendente',
    data_pagamento DATETIME DEFAULT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    UNIQUE KEY unique_cheque (user_id, numero_cheque, banco)
);

CREATE TABLE IF NOT EXISTS repasse_cheques (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nome VARCHAR(255) NOT NULL,
    banco VARCHAR(100) NOT NULL,
    numero_cheque VARCHAR(50) NOT NULL,
    data_repasse DATE NOT NULL,
    valor_repasse DECIMAL(10,2) NOT NULL,
    status ENUM('pendente', 'pago') DEFAULT 'pendente',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);
