<?php
require_once 'config/database.php';

try {
    $database = new Database();
    $pdo = $database->getConnection();

    // Primeiro, vamos listar todas as chaves estrangeiras que referenciam a tabela cheques
    $sql = "SELECT CONSTRAINT_NAME 
            FROM information_schema.KEY_COLUMN_USAGE 
            WHERE TABLE_SCHEMA = DATABASE() 
            AND TABLE_NAME = 'cheques' 
            AND REFERENCED_TABLE_NAME IS NOT NULL";
            
    $stmt = $pdo->query($sql);
    $constraints = $stmt->fetchAll(PDO::FETCH_COLUMN);

    // Remove cada chave estrangeira encontrada
    foreach ($constraints as $constraint) {
        try {
            $sql = "ALTER TABLE cheques DROP FOREIGN KEY " . $constraint;
            $pdo->exec($sql);
            echo "Chave estrangeira {$constraint} removida com sucesso!<br>";
        } catch (PDOException $e) {
            echo "Erro ao remover chave estrangeira {$constraint}: " . $e->getMessage() . "<br>";
        }
    }

    // Agora tenta remover o índice
    try {
        $sql = "ALTER TABLE cheques DROP INDEX unique_cheque";
        $pdo->exec($sql);
        echo "Restrição unique_cheque removida com sucesso!<br>";
    } catch (PDOException $e) {
        if ($e->getCode() != '42000') { // 42000 é o código para "índice não existe"
            throw $e;
        }
        echo "Restrição unique_cheque já não existe.<br>";
    }

    // Array com as colunas a serem adicionadas
    $colunas = [
        "taxa_juros DECIMAL(10,2) AFTER valor",
        "dias INT AFTER data_vencimento"
    ];

    // Adiciona cada coluna
    foreach ($colunas as $coluna) {
        try {
            $sql = "ALTER TABLE cheques ADD COLUMN " . $coluna;
            $pdo->exec($sql);
            echo "Coluna {$coluna} adicionada com sucesso!<br>";
        } catch (PDOException $e) {
            // Se a coluna já existir, apenas ignora e continua
            if ($e->getCode() != '42S21') { // 42S21 é o código para "coluna já existe"
                throw $e;
            }
            echo "Coluna {$coluna} já existe.<br>";
        }
    }

    echo "<br>Atualização da tabela concluída!";

} catch (PDOException $e) {
    echo "Erro: " . $e->getMessage();
}
?> 