<?php
session_start();
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type');

// Verificar se o usuário está logado
if (!isset($_SESSION['usuario_id'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Usuário não autenticado'
    ]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'PUT') {
    try {
        require_once 'db/conexao.php';
        
        $input = json_decode(file_get_contents('php://input'), true);
        
        $id = $input['id'] ?? 0;
        $titulo = trim($input['titulo'] ?? '');
        $data = $input['data'] ?? '';
        $descricao = trim($input['descricao'] ?? '');
        
        if (empty($id) || empty($titulo) || empty($data)) {
            echo json_encode([
                'success' => false,
                'message' => 'ID, título e data são obrigatórios'
            ]);
            exit;
        }
        
        // Verificar se a tarefa pertence ao usuário logado
        $stmt = $pdo->prepare("SELECT id FROM tarefas WHERE id = ? AND usuario_id = ?");
        $stmt->execute([$id, $_SESSION['usuario_id']]);
        
        if (!$stmt->fetch()) {
            echo json_encode([
                'success' => false,
                'message' => 'Tarefa não encontrada ou você não tem permissão para editá-la'
            ]);
            exit;
        }
        
        // Atualizar apenas tarefas do usuário logado
        $stmt = $pdo->prepare("UPDATE tarefas SET titulo = ?, data = ?, descricao = ? WHERE id = ? AND usuario_id = ?");
        $result = $stmt->execute([$titulo, $data, $descricao, $id, $_SESSION['usuario_id']]);
        
        if ($stmt->rowCount() > 0) {
            echo json_encode([
                'success' => true,
                'message' => 'Tarefa atualizada com sucesso'
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Erro ao atualizar tarefa'
            ]);
        }
    } catch(PDOException $e) {
        echo json_encode([
            'success' => false,
            'message' => 'Erro ao atualizar tarefa: ' . $e->getMessage()
        ]);
    } catch(Exception $e) {
        echo json_encode([
            'success' => false,
            'message' => 'Erro geral: ' . $e->getMessage()
        ]);
    }
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Método não permitido'
    ]);
}
?>