CREATE DATABASE IF NOT EXISTS todolist_db;
USE todolist_db;

-- Tabela de usuários
CREATE TABLE usuarios (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nome VARCHAR(100) NOT NULL,
    email VARCHAR(150) UNIQUE NOT NULL,
    senha VARCHAR(32) NOT NULL,
    criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Modificar tabela de tarefas para incluir referência ao usuário
CREATE TABLE tarefas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    titulo VARCHAR(255) NOT NULL,
    data DATE NOT NULL,
    descricao TEXT,
    usuario_id INT NOT NULL,
    criado_em TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (usuario_id) REFERENCES usuarios(id) ON DELETE CASCADE
);

-- Inserir usuário de exemplo (senha: admin em MD5)
INSERT INTO usuarios (nome, email, senha) VALUES
('Admin', 'valtenci@gmail.com', '21232f297a57a5a743894a0e4a801fc3');

-- Inserir algumas tarefas de exemplo para o usuário admin (id = 1)
INSERT INTO tarefas (titulo, data, descricao, usuario_id) VALUES
('Estudar PHP', '2024-01-15', 'Revisar conceitos de orientação a objetos', 1),
('Fazer compras', '2024-01-16', 'Comprar ingredientes para o jantar', 1),
('Exercitar-se', '2024-01-17', 'Corrida no parque pela manhã', 1);