<?php
$host = 'localhost';
$dbname = 'todolist_db';
$username = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch(PDOException $e) {
    // Se for um erro de banco não encontrado, tente criar
    if (strpos($e->getMessage(), 'Unknown database') !== false) {
        try {
            $pdo_temp = new PDO("mysql:host=$host;charset=utf8", $username, $password);
            $pdo_temp->exec("CREATE DATABASE IF NOT EXISTS $dbname");
            $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
        } catch(PDOException $e2) {
            die(json_encode([
                'success' => false,
                'message' => 'Erro na conexão: ' . $e2->getMessage()
            ]));
        }
    } else {
        die(json_encode([
            'success' => false,
            'message' => 'Erro na conexão: ' . $e->getMessage()
        ]));
    }
}
?>