<?php $__env->startSection('css'); ?>
<style type="text/css">
    .div-overflow {
        width: 180px;
        overflow-x: auto;
        white-space: nowrap;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('produtos_create')): ?>
                    <a href="<?php echo e(route('produtos.create')); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Novo Produto
                    </a>
                    <?php endif; ?>

                    <a href="<?php echo e(route('produtos.import')); ?>" class="btn btn-info pull-right">
                        <i class="ri-file-upload-line"></i>
                        Upload
                    </a>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('produtos_edit')): ?>
                    <a href="<?php echo e(route('produtos.reajuste')); ?>" class="btn btn-dark pull-right">
                        <i class="ri-file-edit-fill"></i>
                        Reajuste em grupo
                    </a>
                    <?php endif; ?>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-2">
                            <?php echo Form::text('nome', 'Pesquisar por nome'); ?>

                        </div>
                        
                        <div class="col-md-2">
                            <?php echo Form::tel('codigo_barras', 'Pesquisar código de barras'); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::select('tipo', 'Tipo', ['' => 'Todos', 'composto' => 'Composto', 'variavel' => 'Variável', 'combo' => 'Combo'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::select('categoria_id', 'Categoria', ['' => 'Todos'] + $categorias->pluck('nome', 'id')->all())
                            ->attrs(['class' => 'form-select']); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::date('start_date', 'Dt. inicial cadastro'); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::date('end_date', 'Dt. final cadastro'); ?>

                        </div>

                        <?php if(__countLocalAtivo() > 1): ?>
                        <div class="col-md-2">
                            <?php echo Form::select('local_id', 'Local', ['' => 'Selecione'] + __getLocaisAtivoUsuario()->pluck('descricao', 'id')->all())
                            ->attrs(['class' => 'select2']); ?>

                        </div>
                        <?php endif; ?>
                        <div class="col-md-3 text-left">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('produtos.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-md-12 mt-3 table-responsive">
                    <h6>Total de produtos cadastrados: <strong><?php echo e($data->total()); ?></strong></h6>
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('produtos_delete')): ?>
                                    <th>
                                        <div class="form-check form-checkbox-danger mb-2">
                                            <input class="form-check-input" type="checkbox" id="select-all-checkbox">
                                        </div>
                                    </th>
                                    <?php endif; ?>
                                    <th>Ações</th>
                                    <th></th>
                                    <th>Nome</th>
                                    <th>Valor de venda</th>
                                    <th>Valor de compra</th>
                                    <?php if(__countLocalAtivo() > 1): ?>
                                    <th>Disponibilidade</th>
                                    <?php endif; ?>
                                    <th>Categoria</th>
                                    <th>Código de barras</th>
                                    <th>NCM</th>
                                    <th>Unidade</th>
                                    <th>Data de cadastro</th>
                                    <th>CFOP</th>
                                    <th>Gerenciar estoque</th>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('estoque_view')): ?>
                                    <th>Estoque</th>
                                    <?php endif; ?>
                                    <th>Status</th>
                                    <th>Variação</th>
                                    <th>Combo</th>
                                    <?php if(__isActivePlan(Auth::user()->empresa, 'Cardapio')): ?>
                                    <th>Cardápio</th>
                                    <?php endif; ?>
                                    <?php if(__isActivePlan(Auth::user()->empresa, 'Delivery')): ?>
                                    <th>Delivery</th>
                                    <?php endif; ?>
                                    <?php if(__isActivePlan(Auth::user()->empresa, 'Ecommerce')): ?>
                                    <th>Ecommerce</th>
                                    <?php endif; ?>
                                    <?php if(__isActivePlan(Auth::user()->empresa, 'Reservas')): ?>
                                    <th>Reserva</th>
                                    <?php endif; ?>
                                    
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('produtos_delete')): ?>
                                    <td>
                                        <div class="form-check form-checkbox-danger mb-2">
                                            <input class="form-check-input check-delete" type="checkbox" name="item_delete[]" value="<?php echo e($item->id); ?>">
                                        </div>
                                    </td>
                                    <?php endif; ?>
                                    <td>
                                        <form style="width: 250px" action="<?php echo e(route('produtos.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('produtos_edit')): ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('produtos.edit', [$item->id])); ?>">
                                                <i class="ri-edit-line"></i>
                                            </a>
                                            <?php endif; ?>
                                            <?php echo csrf_field(); ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('produtos_delete')): ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                            <?php endif; ?>

                                            <?php if($item->composto == true): ?>
                                            <a class="btn btn-info btn-sm" href="<?php echo e(route('produto-composto.show', [$item->id])); ?>" title="Ver composição"><i class="ri-search-eye-fill"></i></a>
                                            <?php endif; ?>

                                            <?php if($item->alerta_validade != ''): ?>
                                            <a title="Ver lote e vencimento" type="button" class="btn btn-light btn-sm" onclick="infoVencimento('<?php echo e($item->id); ?>')" data-bs-toggle="modal" data-bs-target="#info_vencimento"><i class="ri-eye-line"></i></a>
                                            <?php endif; ?>

                                            <a title="Ver movimentações" href="<?php echo e(route('produtos.show', [$item->id])); ?>" class="btn btn-dark btn-sm"><i class="ri-draft-line"></i></a>

                                            <a class="btn btn-primary btn-sm" href="<?php echo e(route('produtos.duplicar', [$item->id])); ?>" title="Duplicar produto">
                                                <i class="ri-file-copy-line"></i>
                                            </a>
                                            <a class="btn btn-light btn-sm" href="<?php echo e(route('produtos.etiqueta', [$item->id])); ?>" title="Gerar etiqueta">
                                                <i class="ri-barcode-box-line"></i>
                                            </a>
                                        </form>
                                    </td>
                                    <td><img class="img-60" src="<?php echo e($item->img); ?>"></td>
                                    <td><label style="width: 300px"><?php echo e($item->nome); ?></label></td>
                                    <?php if($item->variacao_modelo_id): ?>
                                    <td>
                                        <div class="div-overflow">
                                            <?php echo e($item->valoresVariacao()); ?>

                                        </div>
                                    </td>
                                    <?php else: ?>
                                    <td><label style="width: 100px"><?php echo e(__moeda($item->valor_unitario)); ?></label></td>
                                    <?php endif; ?>
                                    <td><label style="width: 120px"><?php echo e(__moeda($item->valor_compra)); ?></label></td>
                                    <?php if(__countLocalAtivo() > 1): ?>
                                    <td>
                                        <label style="width: 250px">
                                            <?php $__currentLoopData = $item->locais; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $l): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($l->localizacao): ?>
                                            <strong><?php echo e($l->localizacao->descricao); ?></strong>
                                            <?php if(!$loop->last): ?> | <?php endif; ?>
                                            <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </label>
                                    </td>
                                    <?php endif; ?>
                                    <td width="150"><?php echo e($item->categoria ? $item->categoria->nome : '--'); ?></td>
                                    <td width="200"><?php echo e($item->codigo_barras ?? '--'); ?></td>
                                    <td><?php echo e($item->ncm); ?></td>
                                    <td><?php echo e($item->unidade); ?></td>
                                    <td><?php echo e(__data_pt($item->created_at)); ?></td>
                                    <td><?php echo e($item->cfop_estadual); ?>/<?php echo e($item->cfop_outro_estado); ?></td>
                                    <td>
                                        <?php if($item->gerenciar_estoque): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('estoque_view')): ?>
                                    <td>
                                        <?php if(__countLocalAtivo() == 1): ?>
                                        <?php echo e($item->estoqueAtual()); ?>

                                        <?php else: ?>
                                        <label style="width: 200px">

                                            <?php $__currentLoopData = $item->estoqueLocais; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($e->local): ?>
                                            <?php echo e($e->local->descricao); ?>:
                                            <strong class="text-success">
                                                <?php if($item->unidade == 'UN' || $item->unidade == 'UNID'): ?>
                                                <?php echo e(number_format($e->quantidade, 0)); ?>

                                                <?php else: ?>
                                                <?php echo e(number_format($e->quantidade, 3)); ?>

                                                <?php endif; ?>
                                            </strong>
                                            <?php endif; ?>
                                            <?php if(!$loop->last): ?> | <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </label>

                                        <?php endif; ?>
                                    </td>
                                    <?php endif; ?>

                                    <td>
                                        <?php if($item->status): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($item->variacao_modelo_id): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($item->combo): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <?php if(__isActivePlan(Auth::user()->empresa, 'Cardapio')): ?>
                                    <td>
                                        <?php if($item->cardapio): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <?php endif; ?>
                                    <?php if(__isActivePlan(Auth::user()->empresa, 'Delivery')): ?>
                                    <td>
                                        <?php if($item->delivery): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <?php endif; ?>
                                    <?php if(__isActivePlan(Auth::user()->empresa, 'Ecommerce')): ?>
                                    <td>
                                        <?php if($item->ecommerce): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <?php endif; ?>
                                    <?php if(__isActivePlan(Auth::user()->empresa, 'Reservas')): ?>
                                    <td>
                                        <?php if($item->reserva): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <?php endif; ?>
                                    
                                    
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="21" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <br>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('produtos_delete')): ?>
                <form action="<?php echo e(route('produtos.destroy-select')); ?>" method="post" id="form-delete-select">
                    <?php echo method_field('delete'); ?>
                    <?php echo csrf_field(); ?>
                    <div></div>
                    <button type="button" class="btn btn-danger btn-sm btn-delete-all" disabled>
                        <i class="ri-close-circle-line"></i> Remover selecionados
                    </button>
                </form>
                <?php endif; ?>
                <br>
                <?php echo $data->appends(request()->all())->links(); ?>

            </div>
        </div>
    </div>
</div>

<?php echo $__env->make('modals._info_vencimento', ['not_submit' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script type="text/javascript" src="/js/delete_selecionados.js"></script>

<script type="text/javascript">
    function infoVencimento(id) {
        $.get(path_url + 'api/produtos/info-vencimento/' + id)
        .done((res) => {
            $('.table-infoValidade tbody').html(res)
        })
        .fail((e) => {
            console.log(e)
        })
    }

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Produtos'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\erp\resources\views/produtos/index.blade.php ENDPATH**/ ?>