<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Nfce;
use App\Models\Empresa;
use App\Models\Caixa;
use App\Models\Contigencia;
use App\Services\NFCeService;

class NFCePainelController extends Controller
{
    public function __construct(){
        if (!is_dir(public_path('xml_nfce'))) {
            mkdir(public_path('xml_nfce'), 0777, true);
        }
        if (!is_dir(public_path('xml_nfce_cancelada'))) {
            mkdir(public_path('xml_nfce_cancelada'), 0777, true);
        }
    }

    public function emitir(Request $request){

        $nfce = Nfce::findOrFail($request->id);

        $empresa = Empresa::findOrFail($nfce->empresa_id);
        $empresa = __objetoParaEmissao($empresa, $nfce->local_id);
        
        if($empresa->arquivo == null){
            return response()->json("Certificado não encontrado para este emitente", 401);
        }

        $nfe_service = new NFCeService([
            "atualizacao" => date('Y-m-d h:i:s'),
            "tpAmb" => (int)$nfce->ambiente,
            "razaosocial" => $empresa->nome,
            "siglaUF" => $empresa->cidade->uf,
            "cnpj" => preg_replace('/[^0-9]/', '', $empresa->cpf_cnpj),
            "schemes" => "PL_009_V4",
            "versao" => "4.00",
            "CSC" => $empresa->csc,
            "CSCid" => $empresa->csc_id
        ], $empresa);

        $doc = $nfe_service->gerarXml($nfce);

        if(!isset($doc['erros_xml'])){
            $xml = $doc['xml'];
            $chave = $doc['chave'];

            try{
                $signed = $nfe_service->sign($xml);
                // contigencia condicional
                if($this->getContigencia($empresa->id)){
                    if(!is_dir(public_path('xml_nfce_contigencia'))){
                        mkdir(public_path('xml_nfce_contigencia'), 0777, true);
                    }

                    $nfce->contigencia = 1;
                    $nfce->reenvio_contigencia = 0;
                    $nfce->chave = $chave;

                    $nfce->estado = 'aprovado';
                    $nfce->numero = $doc['numero'];
                    $nfce->data_emissao = date('Y-m-d H:i:s');
                    $nfce->save();
                    
                    if($empresa->ambiente == 2){
                        $empresa->numero_ultima_nfce_homologacao = $doc['numero'];
                    }else{
                        $empresa->numero_ultima_nfce_producao = $doc['numero'];
                    }
                    $empresa->save();

                    file_put_contents(public_path('xml_nfce_contigencia/').$chave.'.xml', $signed);
                    $data = [
                        'recibo' => '',
                        'chave' => $chave,
                        'contigencia' => 1
                    ];
                    $descricaoLog = 'Emitida em contigência número ' . $doc['numero'];
                    __createLog($nfce->empresa_id, 'NFCe', 'transmitir', $descricaoLog);
                    return response()->json($data, 200);

                }else{
                    $resultado = $nfe_service->transmitir($signed, $doc['chave']);

                    if ($resultado['erro'] == 0) {
                        $nfce->chave = $doc['chave'];
                        $nfce->estado = 'aprovado';

                        if($empresa->ambiente == 2){
                            $empresa->numero_ultima_nfce_homologacao = $doc['numero'];
                        }else{
                            $empresa->numero_ultima_nfce_producao = $doc['numero'];
                        }
                        $nfce->numero = $doc['numero'];
                        $nfce->recibo = $resultado['success'];
                        $nfce->data_emissao = date('Y-m-d H:i:s');

                        $nfce->save();
                        $empresa->save();
                        $data = [
                            'recibo' => $resultado['success'],
                            'chave' => $nfce->chave
                        ];

                        $descricaoLog = "Emitida número $nfce->numero - $nfce->chave APROVADA";
                        __createLog($nfce->empresa_id, 'NFCe', 'transmitir', $descricaoLog);

                        return response()->json($data, 200);
                    }else{
                        $recibo = isset($resultado['recibo']) ? $resultado['recibo'] : null;

                        $error = $resultado['error'];

                        if($nfce->chave == ''){
                            $nfce->chave = $doc['chave'];
                        }

                        if($nfce->signed_xml == null){
                            $nfce->signed_xml = $signed;
                        }
                        if($nfce->recibo == null){
                            $nfce->recibo = $recibo;
                        }
                        $nfce->estado = 'rejeitado';
                        $nfce->save();

                        if(isset($error['protNFe'])){
                            $motivo = $error['protNFe']['infProt']['xMotivo'];
                            $cStat = $error['protNFe']['infProt']['cStat'];

                            $nfce->motivo_rejeicao = substr("[$cStat] $motivo", 0, 200);
                            $nfce->save();

                            $descricaoLog = "REJEITADA $nfce->chave - $motivo";
                            __createLog($nfce->empresa_id, 'NFCe', 'erro', $descricaoLog);

                            return response()->json("[$cStat] $motivo", 403);
                        }else{
                            return response()->json($error, 403);
                        }
                    }
                }
            }catch(\Exception $e){
                __createLog($nfce->empresa_id, 'NFCe', 'erro', $e->getMessage());
                return response()->json($e->getMessage(), 404);
            }

        }else{
            return response()->json($doc['erros_xml'], 401);
        }
    }

    private function getContigencia($empresa_id){
        $active = Contigencia::
        where('empresa_id', $empresa_id)
        ->where('status', 1)
        ->where('documento', 'NFCe')
        ->first();
        return $active != null ? 1 : 0;
    }

    public function cancelar(Request $request)
    {
        $nfce = Nfce::findOrFail($request->id);
        $empresa = Empresa::findOrFail($nfce->empresa_id);
        $empresa = __objetoParaEmissao($empresa, $nfce->local_id);

        if ($nfce != null) {
            $cnpj = preg_replace('/[^0-9]/', '', $empresa->cpf_cnpj);
            $nfe_service = new NFCeService([
                "atualizacao" => date('Y-m-d h:i:s'),
                "tpAmb" => (int)$nfce->ambiente,
                "razaosocial" => $empresa->nome,
                "siglaUF" => $empresa->cidade->uf,
                "cnpj" => preg_replace('/[^0-9]/', '', $empresa->cpf_cnpj),
                "schemes" => "PL_009_V4",
                "versao" => "4.00",
            ], $empresa);
            $doc = $nfe_service->cancelar($nfce, $request->motivo);

            if (!isset($doc['erro'])) {
                $nfce->estado = 'cancelado';
                $nfce->save();
                // return response()->json($doc, 200);
                $motivo = $doc['retEvento']['infEvento']['xMotivo'];
                $cStat = $doc['retEvento']['infEvento']['cStat'];

                if($cStat == 135){
                    $descricaoLog = "CANCELADA $nfce->chave";
                    __createLog($nfce->empresa_id, 'NFCe', 'cancelar', $descricaoLog);
                    return response()->json("[$cStat] $motivo", 200);
                }else{
                    $descricaoLog = "ERRO CANCELAR: $nfce->chave";
                    __createLog($nfce->empresa_id, 'NFCe', 'erro', $descricaoLog);
                    return response()->json("[$cStat] $motivo", 401);
                }
            } else {
                $arr = $doc['data'];
                $cStat = $arr['retEvento']['infEvento']['cStat'];
                $motivo = $arr['retEvento']['infEvento']['xMotivo'];
                
                __createLog($nfce->empresa_id, 'NFCe', 'erro', "[$cStat] $motivo");
                return response()->json("[$cStat] $motivo", $doc['status']);
            }
        } else {
            return response()->json('Consulta não encontrada', 404);
        }
    }

    public function consultar(Request $request)
    {
        $nfce = Nfce::findOrFail($request->id);
        $empresa = Empresa::findOrFail($nfce->empresa_id);
        $empresa = __objetoParaEmissao($empresa, $nfce->local_id);
        
        if ($nfce != null) {
            $cnpj = preg_replace('/[^0-9]/', '', $empresa->cpf_cnpj);
            $nfe_service = new NFCeService([
                "atualizacao" => date('Y-m-d h:i:s'),
                "tpAmb" => (int)$nfce->ambiente,
                "razaosocial" => $empresa->nome,
                "siglaUF" => $empresa->cidade->uf,
                "cnpj" => preg_replace('/[^0-9]/', '', $empresa->cpf_cnpj),
                "schemes" => "PL_009_V4",
                "versao" => "4.00",
            ], $empresa);
            $consulta = $nfe_service->consultar($nfce);
            if (!isset($consulta['erro'])) {
                try{

                    $motivo = $consulta['protNFe']['infProt']['xMotivo'];
                    $cStat = $consulta['protNFe']['infProt']['cStat'];
                    if($cStat == 100){
                        return response()->json("[$cStat] $motivo", 200);
                    }else{
                        return response()->json("[$cStat] $motivo", 401);
                    }
                }catch(\Exception $e){
                    return response()->json($consulta['cStat'] . " " . $consulta['xMotivo'], 404);
                }
            }else{
                return response()->json($consulta['data'], $consulta['status']);
            }
        } else {
            return response()->json('Consulta não encontrada', 404);
        }
    }

    public function consultaStatusSefaz(Request $request){
        $caixa = Caixa::where('usuario_id', $request->usuario_id)->where('status', 1)->first();
        $empresa = Empresa::findOrFail($request->empresa_id);
        $empresa = __objetoParaEmissao($empresa, $caixa ? $caixa->local_id : null);

        $nfce_service = new NFCeService([
            "atualizacao" => date('Y-m-d h:i:s'),
            "tpAmb" => (int)$empresa->ambiente,
            "razaosocial" => $empresa->nome,
            "siglaUF" => $empresa->cidade->uf,
            "cnpj" => preg_replace('/[^0-9]/', '', $empresa->cpf_cnpj),
            "schemes" => "PL_009_V4",
            "versao" => "4.00",
        ], $empresa);
        $consulta = $nfce_service->consultaStatus((int)$empresa->ambiente, $empresa->cidade->uf);
        return response()->json($consulta, 200);
    }

    public function transmitirContigencia(Request $request){

        $nfce = Nfce::findOrFail($request->id);

        $empresa = Empresa::findOrFail($nfce->empresa_id);
        $empresa = __objetoParaEmissao($empresa, $nfce->local_id);
        
        if($empresa->arquivo == null){
            return response()->json("Certificado não encontrado para este emitente", 401);
        }

        if(!file_exists(public_path('xml_nfce_contigencia/'.$nfce->chave.'.xml'))){
            return response()->json("arquivo não existe", 401);
        }
        $nfe_service = new NFCeService([
            "atualizacao" => date('Y-m-d h:i:s'),
            "tpAmb" => (int)$nfce->ambiente,
            "razaosocial" => $empresa->nome,
            "siglaUF" => $empresa->cidade->uf,
            "cnpj" => preg_replace('/[^0-9]/', '', $empresa->cpf_cnpj),
            "schemes" => "PL_009_V4",
            "versao" => "4.00",
            "CSC" => $empresa->csc,
            "CSCid" => $empresa->csc_id
        ], $empresa);

        $xml = file_get_contents(public_path('xml_nfce_contigencia/'.$nfce->chave.'.xml'));
        $resultado = $nfe_service->transmitir($xml, $nfce->chave);

        if ($resultado['erro'] == 0) {

            $nfce->estado = 'aprovado';
            $nfce->reenvio_contigencia = 1;
            $nfce->save();

            $data = [
                'recibo' => $resultado['success'],
                'chave' => $nfce->chave
            ];
            return response()->json($data, 200);

        }else{
            $error = $resultado['error'];
            $nfce->estado = 'rejeitado';
            $nfce->save();

            if(isset($error['protNFe'])){
                $motivo = $error['protNFe']['infProt']['xMotivo'];
                $cStat = $error['protNFe']['infProt']['cStat'];

                $nfce->motivo_rejeicao = substr("[$cStat] $motivo", 0, 200);
                $nfce->save();

                return response()->json("[$cStat] $motivo", 403);
            }else{
                return response()->json($error, 403);
            }
        }

    }

}
