<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-2">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inventario_create')): ?>
                    <a href="<?php echo e(route('inventarios.create')); ?>" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Novo Inventário
                    </a>
                    <?php endif; ?>
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    <?php echo Form::open()->fill(request()->all())
                    ->get(); ?>

                    <div class="row mt-3">
                        <div class="col-md-2">
                            <?php echo Form::select('usuario_id', 'Usuário', ['' => 'Todos'] + $usuarios->pluck('name', 'id')->all())
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <div class="col-md-2">
                            <?php echo Form::select('status', 'Status', ['' => 'Todos', '1' => 'Ativos', '0' => 'Finalizados'])
                            ->attrs(['class' => 'form-select']); ?>

                        </div>
                        <div class="col-md-3 text-left">
                            <br>
                            <button class="btn btn-primary" type="submit"> <i class="ri-search-line"></i>Pesquisar</button>
                            <a id="clear-filter" class="btn btn-danger" href="<?php echo e(route('inventarios.index')); ?>"><i class="ri-eraser-fill"></i>Limpar</a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
                <div class="col-12 mt-3">
                    <div class="table-responsive-sm">
                        <table class="table table-striped table-centered mb-0">
                            <thead class="table-dark">
                                <tr>

                                    <th>#</th>
                                    <th>Início</th>
                                    <th>Fim</th>
                                    <th>Data de cadastro</th>
                                    <th>Status</th>
                                    <th>Tipo</th>
                                    <th>Usuário</th>
                                    <th>Itens apontados</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($item->numero_sequencial); ?></td>
                                    <td><?php echo e(__data_pt($item->inicio, 0)); ?></td>
                                    <td><?php echo e(__data_pt($item->fim, 0)); ?></td>
                                    <td><?php echo e(__data_pt($item->created_at)); ?></td>
                                    <td>
                                        <?php if($item->status): ?>
                                        <i class="ri-checkbox-circle-fill text-success"></i>
                                        <?php else: ?>
                                        <i class="ri-close-circle-fill text-danger"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($item->tipo); ?></td>
                                    <td><?php echo e($item->usuario ? $item->usuario->name : ''); ?></td>
                                    <td>
                                        <?php echo e(sizeof($item->itens)); ?>

                                    </td>
                                    <td>
                                        <form action="<?php echo e(route('inventarios.destroy', $item->id)); ?>" method="post" id="form-<?php echo e($item->id); ?>">
                                            <?php echo method_field('delete'); ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('servico_edit')): ?>
                                            <a class="btn btn-warning btn-sm" href="<?php echo e(route('inventarios.edit', [$item->id])); ?>">
                                                <i class="ri-pencil-fill"></i>
                                            </a>
                                            <?php endif; ?>

                                            <?php echo csrf_field(); ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('servico_delete')): ?>
                                            <button type="button" class="btn btn-delete btn-sm btn-danger">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                            <?php endif; ?>

                                            <a title="Apontar" class="btn btn-dark btn-sm" href="<?php echo e(route('inventarios.apontar', [$item->id])); ?>">
                                                <i class="ri-barcode-box-line"></i>
                                            </a>
                                        </form>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="9" class="text-center">Nada encontrado</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        <br>
                        
                    </div>
                </div>
                <?php echo $data->appends(request()->all())->links(); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', ['title' => 'Inventários'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/erp.royalsistema.com.br/resources/views/inventarios/index.blade.php ENDPATH**/ ?>