<?php

namespace App\Filament\User\Resources\ModeloResource\Pages;

use App\Filament\User\Resources\ModeloResource;
use Filament\Resources\Pages\EditRecord;
use Filament\Notifications\Notification;
use Filament\Actions\Action;
use Filament\Actions\ViewAction;

class EditModelo extends EditRecord
{
    protected static string $resource = ModeloResource::class;

    // botao salvar
    protected function getSaveFormAction(): Action
    {
        return parent::getSaveFormAction()
            ->label('Salvar Modelo')
            ->icon('heroicon-o-check')
            ->color('success');
    }

    protected function getCancelFormAction(): Action
    {
        return parent::getCancelFormAction()
            ->label('Cancelar')
            ->icon('heroicon-o-x-mark')
            ->color('warning');
    }

    protected function getUpdatedNotificationTitle(): ?string
    {
        return 'Modelo atualizado!';
    }

    protected function getUpdatedNotificationColor(): ?string
    {
        return 'success';
    }

    protected function getUpdatedNotificationIcon(): ?string
    {
        return 'heroicon-o-check-circle';
    }
    
    protected function getSavedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->color('success')
            ->icon('heroicon-o-check-circle')
            ->title('Modelo atualizado!')
            ->body('As informações do modelo foram atualizadas com sucesso')
            ->duration(5000);
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
}
