<?php

namespace App\Filament\User\Resources\MarcaResource\Pages;

use App\Filament\User\Resources\MarcaResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Filament\Notifications\Notification;
use Filament\Actions\Action;

class EditMarca extends EditRecord
{
    protected static string $resource = MarcaResource::class;

    // botao salvar
    protected function getSaveFormAction(): Action
    {
        return parent::getSaveFormAction()
            ->label('Salvar Marca')
            ->icon('heroicon-o-check')
            ->color('success');
    }

    protected function getCancelFormAction(): Action
    {
        return parent::getCancelFormAction()
            ->label('Cancelar')
            ->icon('heroicon-o-x-mark')
            ->color('warning');
    }

    protected function getUpdatedNotificationTitle(): ?string
    {
        return 'Marca atualizada!';
    }

    protected function getUpdatedNotificationBody(): ?string
    {
        return 'A marca foi atualizada com sucesso!';
    }

    protected function getUpdatedNotificationColor(): ?string
    {
        return 'success';
    }

    protected function getUpdatedNotificationIcon(): ?string
    {
        return 'heroicon-o-check-circle';
    }

    protected function getUpdatedNotificationActions(): ?array
    {
        return [
            Actions\ViewAction::make()
                ->label('Visualizar Marca'),
        ];
    }

    protected function getSavedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->color('success')
            ->icon('heroicon-o-check-circle')
            ->title('Marca atualizada!')
            ->body('As informações da marca foram atualizadas com sucesso')
            ->duration(5000);
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
}
