<?php

namespace App\Filament\User\Resources;

use App\Filament\User\Resources\MarcaResource\Pages;
use App\Filament\User\Resources\MarcaResource\RelationManagers;
use App\Models\Marca;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Select;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Actions\EditAction;
use Filament\Tables\Actions\BulkActionGroup;
use Filament\Tables\Actions\DeleteBulkAction;
use Filament\Tables\Actions\DeleteAction;   
use Filament\Notifications\Notification;
use Filament\Actions\Action;

 
class MarcaResource extends Resource
{
    protected static ?string $model = Marca::class;
    // aqui controle de visibilidade do menu 
    protected static ?string $navigationIcon = 'heroicon-o-cube';
    protected static ?string $navigationGroup = 'Cadastros';
    protected static ?int $navigationSort = 3;
    protected static ?string $pluralLabel = 'Marcas';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                TextInput::make('nome')
                    ->required(),
                // PEGA APENAS O TENANT DO USUARIO LOGADO
                Select::make('tenant_id')
                    ->label('Empresa do Cliente')
                    ->relationship('tenant', 'name', fn ($query) => $query->where('id', auth()->user()->tenant_id))
                    ->required()
                    ->preload()
                    ->searchable()
                    ->default(auth()->user()->tenant_id)
                    ->disabled()
                    ->dehydrated(), // NAO PODE SER ALTERADO
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
        // pega apenas os clientes do tenant do usuario logado
        ->modifyQueryUsing(fn (Builder $query) => $query->where('tenant_id', auth()->user()->tenant_id))
            ->columns([
                TextColumn::make('nome')
                    ->searchable(),
                TextColumn::make('tenant.name')
                    ->label('Empresa')
                    ->searchable()
                    ->sortable(),
                TextColumn::make('created_at')
                    ->label('Data de Criação')
                    ->dateTime('d/m/Y')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: false),
            ])
            ->filters([
                //
            ])
            ->actions([
                EditAction::make()
                ->tooltip('Editar')
                    ->iconButton()
                    ->color('warning')
                    ->icon('heroicon-o-pencil-square'),
                DeleteAction::make()
                ->tooltip('Excluir')
                    ->iconButton()
                    ->color('danger')
                    ->icon('heroicon-o-trash')
                    ->modalHeading('Excluir Marca')
                    ->modalDescription('Tem certeza que deseja excluir esta marca? Esta ação não poderá ser desfeita.')
                    ->modalSubmitActionLabel('Sim, excluir')
                    ->modalCancelActionLabel('Não, cancelar')
                    ->successNotification(null)
                    ->after(function() {
                        Notification::make()
                            ->success()
                            ->color('success')
                            ->icon('heroicon-o-check-circle')
                            ->title('Marca excluída!')
                            ->body('A marca foi removida com sucesso')
                            ->send();
                    }),
            ])
            ->bulkActions([
                BulkActionGroup::make([
                    DeleteBulkAction::make()
                        ->label('Excluir Selecionados')
                        ->modalHeading('Excluir Marcas Selecionadas')
                        ->modalDescription('Tem certeza que deseja excluir as marcas selecionadas? Esta ação não poderá ser desfeita.')
                        ->modalSubmitActionLabel('Sim, excluir')
                        ->modalCancelActionLabel('Não, cancelar')
                        ->successNotification(null)
                        ->after(function() {
                            Notification::make()
                                ->success()
                                ->color('success')
                                ->icon('heroicon-o-check-circle')
                                ->title('Marcas excluídas!')
                                ->body('As marcas foram removidas com sucesso')
                                ->send();
                        })
                ])
                ->label('Ações em massa'),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListMarcas::route('/'),
            'create' => Pages\CreateMarca::route('/create'),
            'edit' => Pages\EditMarca::route('/{record}/edit'),
        ];
    }
}
