<?php

namespace App\Filament\User\Resources\FormasPagamentoResource\Pages;

use App\Filament\User\Resources\FormasPagamentoResource;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Filament\Notifications\Notification;
use Filament\Actions\Action;

class EditFormasPagamento extends EditRecord
{
    protected static string $resource = FormasPagamentoResource::class;

    protected function getSaveFormAction(): Action
    {
        return parent::getSaveFormAction()
            ->label('Salvar Forma de Pagamento')
            ->icon('heroicon-o-check')
            ->color('success');
    }

    protected function getCancelFormAction(): Action
    {
        return parent::getCancelFormAction()
            ->label('Cancelar')
            ->icon('heroicon-o-x-mark')
            ->color('warning');
    }

    protected function getUpdatedNotificationTitle(): ?string
    {
        return 'Forma de Pagamento atualizada!';
    }

    protected function getUpdatedNotificationColor(): ?string
    {
        return 'success';
    }

    protected function getUpdatedNotificationIcon(): ?string
    {
        return 'heroicon-o-check-circle';
    }
    
    protected function getSavedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->color('success')
            ->icon('heroicon-o-check-circle')
            ->title('Forma de Pagamento atualizada!')
            ->body('As informações da forma de pagamento foram atualizadas com sucesso')
            ->duration(5000);
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
}
