<!-- Modal Sangria -->
<div class="modal fade modal-action-pos" id="sangria" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-warning">
                <h5 class="modal-title text-white" id="staticBackdropLabel">
                    <i class="ri-arrow-down-circle-line"></i> Sangria de Caixa
                </h5>
                <button type="button" class="btn-close text-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="<?php echo e(route('sangria.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <input type="hidden" name="caixa_id" value="<?php echo e(isset($abertura) ? $abertura->id : ''); ?>">
                        
                        <div class="col-md-12 mb-3">
                            <label for="valor_sangria" class="form-label">Valor da Sangria</label>
                            <div class="input-group">
                                <span class="input-group-text">R$</span>
                                <input type="text" class="form-control moeda" id="valor_sangria" name="valor" required placeholder="0,00" autofocus>
                            </div>
                        </div>
                        
                        <div class="col-md-12 mb-3">
                            <label for="obs_sangria" class="form-label">Observação</label>
                            <textarea class="form-control" id="obs_sangria" name="observacao" rows="3" placeholder="Motivo da sangria (opcional)"></textarea>
                        </div>
                        
                        <div class="col-12">
                            <div class="alert alert-info py-2">
                                <small>
                                    <i class="ri-information-line"></i> A sangria registra a retirada de dinheiro do caixa. 
                                    Um comprovante será gerado após a confirmação.
                                </small>
                            </div>
                        </div>

                        <div class="mt-3 ms-auto">
                            <button type="submit" class="btn btn-warning px-3 float-end">
                                <i class="ri-save-line"></i> Confirmar Sangria
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div> <?php /**PATH C:\xampp\htdocs\erp_dev\resources\views/modals/_sangria.blade.php ENDPATH**/ ?>