<!-- Modal Suprimento -->
<div class="modal fade modal-action-pos" id="suprimento" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-success">
                <h5 class="modal-title text-white" id="staticBackdropLabel">
                    <i class="ri-arrow-up-circle-line"></i> Suprimento de Caixa
                </h5>
                <button type="button" class="btn-close text-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="{{ route('suprimento.store') }}" method="POST">
                    @csrf
                    <div class="row">
                        <input type="hidden" name="caixa_id" value="{{ isset($abertura) ? $abertura->id : '' }}">
                        
                        <div class="col-md-12 mb-3">
                            <label for="valor_suprimento" class="form-label">Valor do Suprimento</label>
                            <div class="input-group">
                                <span class="input-group-text">R$</span>
                                <input type="text" class="form-control moeda" id="valor_suprimento" name="valor" required placeholder="0,00" autofocus>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <label for="tipo_pagamento" class="form-label">Tipo de Pagamento</label>
                            <select name="tipo_pagamento" id="tipo_pagamento" class="form-select" required>
                                <option value="">Selecione</option>
                                <option value="01">Dinheiro</option>
                                <option value="02">Cheque</option>
                                <option value="03">Cartão de Crédito</option>
                                <option value="04">Cartão de Débito</option>
                                <option value="05">Crédito Loja</option>
                                <option value="10">Vale Alimentação</option>
                                <option value="11">Vale Refeição</option>
                                <option value="12">Vale Presente</option>
                                <option value="13">Vale Combustível</option>
                                <option value="15">Boleto Bancário</option>
                                <option value="16">Depósito Bancário</option>
                                <option value="17">PIX</option>
                                <option value="99">Outros</option>
                            </select>
                        </div>
                        
                        <div class="col-md-12 mb-3">
                            <label for="obs_suprimento" class="form-label">Observação</label>
                            <textarea class="form-control" id="obs_suprimento" name="observacao" rows="3" placeholder="Motivo do suprimento (opcional)"></textarea>
                        </div>
                        
                        <div class="col-12">
                            <div class="alert alert-info py-2">
                                <small>
                                    <i class="ri-information-line"></i> O suprimento registra a entrada de dinheiro no caixa.
                                    Um comprovante será gerado após a confirmação.
                                </small>
                            </div>
                        </div>

                        <div class="mt-3 ms-auto">
                            <button type="submit" class="btn btn-success px-3 float-end">
                                <i class="ri-save-line"></i> Confirmar Suprimento
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div> 