<div class="modal fade" id="modal_formas_pagamento" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="formasPagamentoLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="formasPagamentoLabel">
                    <i class="ri-bank-card-line me-2"></i>Selecione a Forma de Pagamento
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="text-center mb-4">
                    <h6 class="text-muted">Valor da Venda: <strong class="text-primary fs-4">R$ <span id="valor_venda_modal">0,00</span></strong></h6>
                </div>
                
                <!-- Campo de Desconto -->
                <div class="row mb-4">
                    <div class="col-md-6 offset-md-3">
                        <div class="card border-primary">
                            <div class="card-body text-center">
                                <label for="desconto_modal" class="form-label fw-bold text-primary">
                                    <i class="ri-percent-line me-2"></i>Desconto (R$)
                                </label>
                                <input type="text" 
                                       class="form-control form-control-lg text-center moeda" 
                                       id="desconto_modal" 
                                       placeholder="0,00"
                                       value="0,00">
                                <div class="mt-2">
                                    <small class="text-muted">Valor com desconto: <strong id="valor_com_desconto">R$ 0,00</strong></small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row g-3">
                    <!-- Dinheiro -->
                    <div class="col-md-4">
                        <button type="button" class="btn btn-outline-success w-100 h-100 p-3 forma-pagamento-btn" data-forma="01" data-nome="Dinheiro">
                            <div class="d-flex flex-column align-items-center">
                                <i class="ri-money-dollar-circle-line fs-1 mb-2"></i>
                                <span class="fw-bold">Dinheiro</span>
                            </div>
                        </button>
                    </div>
                    
                    <!-- PIX -->
                    <div class="col-md-4">
                        <button type="button" class="btn btn-outline-primary w-100 h-100 p-3 forma-pagamento-btn" data-forma="09" data-nome="PIX">
                            <div class="d-flex flex-column align-items-center">
                                <i class="ri-qr-code-line fs-1 mb-2"></i>
                                <span class="fw-bold">PIX</span>
                            </div>
                        </button>
                    </div>
                    
                    <!-- Cartão Crédito -->
                    <div class="col-md-4">
                        <button type="button" class="btn btn-outline-danger w-100 h-100 p-3 forma-pagamento-btn" data-forma="03" data-nome="Cartão Crédito">
                            <div class="d-flex flex-column align-items-center">
                                <i class="ri-bank-card-line fs-1 mb-2"></i>
                                <span class="fw-bold">Cartão Crédito</span>
                            </div>
                        </button>
                    </div>
                    
                    <!-- Cartão Débito -->
                    <div class="col-md-4">
                        <button type="button" class="btn btn-outline-primary w-100 h-100 p-3 forma-pagamento-btn" data-forma="04" data-nome="Cartão Débito">
                            <div class="d-flex flex-column align-items-center">
                                <i class="ri-bank-card-line fs-1 mb-2"></i>
                                <span class="fw-bold">Cartão Débito</span>
                            </div>
                        </button>
                    </div>
                    
                    <!-- Crédito Loja -->
                    <div class="col-md-4">
                        <button type="button" class="btn btn-outline-info w-100 h-100 p-3 forma-pagamento-btn" data-forma="05" data-nome="Crédito Loja">
                            <div class="d-flex flex-column align-items-center">
                                <i class="ri-store-2-line fs-1 mb-2"></i>
                                <span class="fw-bold">Crédito Loja</span>
                            </div>
                        </button>
                    </div>
                    
                    <!-- Vale Crédito -->
                    <div class="col-md-4">
                        <button type="button" class="btn btn-outline-info w-100 h-100 p-3 forma-pagamento-btn" data-forma="10" data-nome="Vale Crédito">
                            <div class="d-flex flex-column align-items-center">
                                <i class="ri-bank-card-line fs-1 mb-2"></i>
                                <span class="fw-bold">Vale Crédito</span>
                            </div>
                        </button>
                    </div>
                </div>
                
                <!-- Progress Indicator -->
                <!-- <div class="position-absolute top-0 end-0 p-3" style="width: 200px;">
                    <div class="d-flex flex-column align-items-center">
                        <div class="progress-indicator">
                            <div class="step completed">
                                <div class="step-circle">1</div>
                                <div class="step-label">Nova Venda</div>
                            </div>
                            <div class="step active">
                                <div class="step-circle">2</div>
                                <div class="step-label">Forma de Pagamento</div>
                            </div>
                            <div class="step">
                                <div class="step-circle">3</div>
                                <div class="step-label">Finalizar Venda</div>
                            </div>
                        </div>
                    </div>
                </div> -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal">
                    <i class="ri-arrow-left-line me-2"></i>Voltar
                </button>
            </div>
        </div>
    </div>
</div>

<style>
.progress-indicator {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 10px;
}

.step {
    display: flex;
    align-items: center;
    gap: 10px;
}

.step-circle {
    width: 30px;
    height: 30px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 12px;
    border: 2px solid #dee2e6;
    background: white;
    color: #6c757d;
}

.step.active .step-circle {
    background: #4e73df;
    border-color: #4e73df;
    color: white;
}

.step.completed .step-circle {
    background: #28a745;
    border-color: #28a745;
    color: white;
}

.step-label {
    font-size: 12px;
    color: #6c757d;
    white-space: nowrap;
}

.step.active .step-label {
    color: #4e73df;
    font-weight: bold;
}

.step.completed .step-label {
    color: #28a745;
}

.forma-pagamento-btn {
    transition: all 0.3s ease;
    border-width: 2px;
    min-height: 120px;
}

.forma-pagamento-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.forma-pagamento-btn.selected {
    border-width: 3px;
    transform: scale(1.05);
}

/* Estilos para o campo de desconto */
#desconto_modal {
    font-size: 1.5rem;
    font-weight: bold;
    border: 2px solid #4e73df;
    border-radius: 0.5rem;
}

#desconto_modal:focus {
    border-color: #224abe;
    box-shadow: 0 0 0 0.2rem rgba(78,115,223,.25);
}

.card.border-primary {
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
}

/* Atalhos de teclado */
.forma-pagamento-btn[data-forma="01"]:focus,
.forma-pagamento-btn[data-forma="03"]:focus,
.forma-pagamento-btn[data-forma="04"]:focus,
.forma-pagamento-btn[data-forma="05"]:focus,
.forma-pagamento-btn[data-forma="09"]:focus,
.forma-pagamento-btn[data-forma="10"]:focus {
    box-shadow: 0 0 0 0.2rem rgba(78,115,223,.25);
}
</style> 