<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Comprovante de Devolução</title>
    <style type="text/css">
        body {
            font-family: Arial, sans-serif;
            width: 260px;
            margin-left: -40px;
            margin-top: -40px;
            font-size: 9px;
        }
        .header {
            text-align: center;
            margin-bottom: 10px;
        }
        .company-name {
            font-weight: bold;
            font-size: 10px;
            margin-bottom: 3px;
        }
        .document-title {
            text-transform: uppercase;
            font-weight: bold;
            font-size: 11px;
            margin-bottom: 7px;
            border-top: 1px solid #000;
            border-bottom: 1px solid #000;
            padding: 3px 0;
        }
        .section-title {
            font-weight: bold;
            margin: 7px 0 3px 0;
            text-transform: uppercase;
            font-size: 9px;
            border-top: 1px solid #000;
            padding-top: 3px;
        }
        .info-item {
            margin-bottom: 2px;
        }
        .info-label {
            font-weight: bold;
            margin-right: 3px;
        }
        .item-table {
            width: 100%;
            margin: 7px 0;
        }
        .item-table th {
            text-align: left;
            font-size: 8px;
            padding-bottom: 3px;
            border-bottom: 1px solid #ccc;
        }
        .item-table td {
            padding: 2px 0;
            font-size: 8px;
            border-bottom: 1px dotted #eee;
        }
        .totals {
            margin-top: 7px;
            border-top: 1px solid #000;
            padding-top: 3px;
        }
        .total-label {
            font-weight: bold;
        }
        .total-value {
            font-weight: bold;
        }
        .footer {
            margin-top: 10px;
            font-size: 8px;
            text-align: center;
            border-top: 1px solid #ccc;
            padding-top: 3px;
        }
        .text-center {
            text-align: center;
        }
        .signature {
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="company-name">{{ $empresa->nome_fantasia }}</div>
        <div>{{ __setMask($empresa->cpf_cnpj) }}</div>
        <div class="document-title">{{ $tipo == 'troca' ? 'Comprovante de Troca' : 'Comprovante de Devolução' }}</div>
    </div>

    <div>
        <div class="section-title">Informações Gerais</div>
        <div class="info-item">
            <span class="info-label">Data:</span>
            <span>{{ __data_pt($devolucao->data_devolucao, 1) }}</span>
        </div>
        <div class="info-item">
            <span class="info-label">Número:</span>
            <span>#{{ $devolucao->id }}</span>
        </div>
        <div class="info-item">
            <span class="info-label">Cliente:</span>
            <span>{{ $devolucao->cliente ? $devolucao->cliente->razao_social : 'Cliente não informado' }}</span>
        </div>
        <div class="info-item">
            <span class="info-label">Venda Original:</span>
            <span>{{ $devolucao->tipo_venda == 'nfce' ? 'NFCe' : 'NFe' }} #{{ $devolucao->venda_id }}</span>
        </div>
        <div class="info-item">
            <span class="info-label">Forma de Devolução:</span>
            <span>
                @if($devolucao->tipo_pagamento == '00')
                    Vale Crédito
                @elseif($devolucao->tipo_pagamento == '01')
                    Dinheiro
                @elseif($devolucao->tipo_pagamento == '03')
                    Cartão de Crédito
                @elseif($devolucao->tipo_pagamento == '04')
                    Cartão de Débito
                @elseif($devolucao->tipo_pagamento == '06')
                    Crediário (Abatimento nas parcelas)
                @else
                    {{ \App\Models\Nfe::getTipoPagamentoByTipo($devolucao->tipo_pagamento) }}
                @endif
            </span>
        </div>
        
        @if($devolucao->tipo_pagamento == '06')
        <div class="info-item">
            <span class="info-label">Observação:</span>
            <span>O valor será abatido das parcelas pendentes do crediário</span>
        </div>
        @endif
    </div>

    <div>
        <div class="section-title">Itens Devolvidos</div>
        <table class="item-table">
            <thead>
                <tr>
                    <th style="width: 40%;">Produto</th>
                    <th style="width: 15%;">Qtd</th>
                    <th style="width: 20%;">V.Unit</th>
                    <th style="width: 25%;">Subtotal</th>
                </tr>
            </thead>
            <tbody>
                @foreach($devolucao->itens as $item)
                    <tr>
                        <td>{{ $item->produto ? $item->produto->nome : 'Produto não encontrado' }}</td>
                        <td>{{ $item->quantidade }}</td>
                        <td>R$ {{ __moeda($item->valor_unitario) }}</td>
                        <td>R$ {{ __moeda($item->valor_unitario * $item->quantidade) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <div class="totals">
        <div style="display: flex; justify-content: space-between; margin-bottom: 3px;">
            <span class="total-label">Valor Total:</span>
            <span class="total-value">R$ {{ __moeda($devolucao->valor_total) }}</span>
        </div>
    </div>

    @if($tipo == 'troca' && isset($devolucao->valor_diferenca) && $devolucao->valor_diferenca != 0)
    <div style="margin-top: 7px;">
        <div class="section-title">Informações da Diferença</div>
        <div class="info-item">
            @if($devolucao->valor_diferenca > 0)
            <span class="info-label">Diferença Devolvida ao Cliente:</span>
            <span>R$ {{ __moeda($devolucao->valor_diferenca) }}</span>
            @else
            <span class="info-label">Diferença Paga pelo Cliente:</span>
            <span>R$ {{ __moeda(abs($devolucao->valor_diferenca)) }}</span>
            @endif
        </div>
        <div class="info-item">
            <span class="info-label">Forma de Pagamento:</span>
            <span>
                @if($devolucao->tipo_pagamento == '00')
                    Vale Crédito
                @elseif($devolucao->tipo_pagamento == '01')
                    Dinheiro
                @elseif($devolucao->tipo_pagamento == '03')
                    Cartão de Crédito
                @elseif($devolucao->tipo_pagamento == '04')
                    Cartão de Débito
                @elseif($devolucao->tipo_pagamento == '06')
                    Crediário (Abatimento nas parcelas)
                @else
                    {{ \App\Models\Nfe::getTipoPagamentoByTipo($devolucao->tipo_pagamento) }}
                @endif
            </span>
        </div>
    </div>
    @endif

    @if($devolucao->observacao)
    <div style="margin-top: 7px;">
        <div class="section-title">Observações</div>
        <div>{{ $devolucao->observacao }}</div>
    </div>
    @endif

    <div style="display: flex; justify-content: space-between; margin-top: 15px;">
        <div class="text-center" style="width: 48%;">
            <div>____________________</div>
            <div style="font-size: 7px;">Assinatura do Cliente</div>
        </div>
        <div class="text-center" style="width: 48%;">
            <div>____________________</div>
            <div style="font-size: 7px;">Assinatura do Atendente</div>
        </div>
    </div>

    <div class="footer">
        {{ date('d/m/Y H:i:s') }} - {{ $empresa->nome_fantasia }}
        <div>Este documento não possui valor fiscal</div>
    </div>
</body>
</html> 