@extends('layouts.app', ['title' => 'Contas a Pagar'])
@section('css')
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
<style>
    .btn-sm {
        width: 32px;
        height: 32px;
        padding: 6px;
        margin-right: 4px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }
    
    @media (max-width: 768px) {
        .table th, .table td {
            white-space: nowrap;
        }
        .btn-sm {
            font-size: 0.75rem;
        }
    }

    .table th, .table td {
        vertical-align: middle;
    }
    
    /* Estilos para os cards de resumo */
    .resumo-card {
        border-radius: 10px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        transition: transform 0.2s, box-shadow 0.2s;
        height: 100%;
    }
    
    .resumo-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 6px 12px rgba(0, 0, 0, 0.15);
    }
    
    .resumo-card .card-body {
        padding: 1.25rem;
    }
    
    .resumo-card .icon-circle {
        height: 50px;
        width: 50px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 22px;
        margin-bottom: 15px;
        color: white;
    }
    
    .resumo-card h5 {
        font-size: 1rem;
        margin-bottom: 10px;
    }
    
    .resumo-card .valor {
        font-size: 1.5rem;
        font-weight: 700;
    }
    
    .bg-pagar {
        background: linear-gradient(45deg, #6c5ce7, #574b90);
    }
    
    .bg-pago {
        background: linear-gradient(45deg, #1cc88a, #169a6f);
    }
    
    .bg-pendente {
        background: linear-gradient(45deg, #36b9cc, #2c94a3);
    }
    
    .bg-vencido {
        background: linear-gradient(45deg, #e74a3b, #be3e32);
    }
</style>
@endsection
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-2">
                    @can('conta_pagar_create')
                    <a href="{{ route('conta-pagar.create') }}" class="btn btn-success">
                        <i class="ri-add-circle-fill"></i>
                        Nova conta a pagar
                    </a>
                    @endcan
                </div>
                <div class="col-md-10 text-end">
                    @can('conta_receber_view')
                    <a href="{{ route('conta-receber.relatorio-projecao') }}" class="btn btn-primary">
                        <i class="fas fa-chart-line"></i>
                        Fluxo de Caixa Projetado
                    </a>
                    @endcan
                </div>
                <hr class="mt-3">
                <div class="col-lg-12">
                    {!!Form::open()->fill(request()->all())
                    ->get()
                    !!}
                    <div class="row g-2">
                        <div class="col-12 col-sm-6 col-md-4 col-lg-4">
                            {!!Form::select('fornecedor_id', 'Pesquisar por nome')->attrs(['class' => 'select2'])
                            ->options($fornecedor != null ? [$fornecedor->id => $fornecedor->info] : [])
                            !!}
                        </div>
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2">
                            {!!Form::date('start_date', 'Data inicial')
                            !!}
                        </div>
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2">
                            {!!Form::date('end_date', 'Data Final')
                            !!}
                        </div>

                        @if(__countLocalAtivo() > 1)
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2">
                            {!!Form::select('local_id', 'Local', ['' => 'Selecione'] + __getLocaisAtivoUsuario()->pluck('descricao', 'id')->all())
                            ->attrs(['class' => 'select2'])
                            !!}
                        </div>
                        @endif
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2">
                            {!!Form::select('status', 'Status', ['' => 'Todas', 1 => 'Pagas', 0 => 'Pendentes'])
                            ->attrs(['class' => 'form-select'])
                            !!}
                        </div>
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2">
                            {!!Form::select('ordem', 'Ordenar por', ['' => 'Data de cadastro', 1 => 'Data de vencimento'])
                            ->attrs(['class' => 'form-select'])
                            !!}
                        </div>
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2 d-flex align-items-end">
                            <button class="btn btn-primary w-100" type="submit"> 
                                <i class="ri-search-line"></i> Pesquisar
                            </button>
                        </div>
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2 d-flex align-items-end">
                            <a id="clear-filter" class="btn btn-danger w-100" href="{{ route('conta-pagar.index') }}">
                                <i class="ri-eraser-fill"></i> Limpar
                            </a>
                        </div>
                    </div>
                    {!!Form::close()!!}
                </div>
                
                <!-- Cards de Resumo Financeiro -->
                <div class="row mt-4 mb-4">
                    <!-- Card Total a Pagar -->
                    <div class="col-md-6 col-lg-3 mb-3">
                        <div class="card resumo-card bg-pagar">
                            <div class="card-body text-white">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div>
                                        <h5 class="text-white">Total de Lançamentos</h5>
                                        <div class="valor">{{ __moeda(\App\Models\ContaPagar::where('empresa_id', request()->empresa_id)
                                            ->when(!empty(request('fornecedor_id')), function ($query) {
                                                return $query->where('fornecedor_id', request('fornecedor_id'));
                                            })
                                            ->when(!empty(request('start_date')), function ($query) {
                                                return $query->whereDate('data_vencimento', '>=', request('start_date'));
                                            })
                                            ->when(!empty(request('end_date')), function ($query) {
                                                return $query->whereDate('data_vencimento', '<=', request('end_date'));
                                            })
                                            ->when(!empty(request('local_id')), function ($query) {
                                                return $query->where('local_id', request('local_id'));
                                            })
                                            ->when(empty(request('local_id')), function ($query) {
                                                $locais = __getLocaisAtivoUsuario()->pluck('id');
                                                return $query->whereIn('local_id', $locais);
                                            })
                                            ->when(request('status') != '', function ($query) {
                                                return $query->where('status', request('status'));
                                            })
                                            ->sum('valor_integral')) }}
                                        </div>
                                    </div>
                                    <div class="icon-circle bg-white">
                                        <i class="fas fa-file-invoice-dollar text-primary"></i>
                                    </div>
                                </div>
                                <p class="mb-0">Soma de todos os lançamentos</p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Card Valor Pago -->
                    <div class="col-md-6 col-lg-3 mb-3">
                        <div class="card resumo-card bg-pago">
                            <div class="card-body text-white">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div>
                                        <h5 class="text-white">Valor Pago</h5>
                                        <div class="valor">{{ __moeda(\App\Models\ContaPagar::where('empresa_id', request()->empresa_id)
                                            ->when(!empty(request('fornecedor_id')), function ($query) {
                                                return $query->where('fornecedor_id', request('fornecedor_id'));
                                            })
                                            ->when(!empty(request('start_date')), function ($query) {
                                                return $query->whereDate('data_vencimento', '>=', request('start_date'));
                                            })
                                            ->when(!empty(request('end_date')), function ($query) {
                                                return $query->whereDate('data_vencimento', '<=', request('end_date'));
                                            })
                                            ->when(!empty(request('local_id')), function ($query) {
                                                return $query->where('local_id', request('local_id'));
                                            })
                                            ->when(empty(request('local_id')), function ($query) {
                                                $locais = __getLocaisAtivoUsuario()->pluck('id');
                                                return $query->whereIn('local_id', $locais);
                                            })
                                            ->when(request('status') != '', function ($query) {
                                                return $query->where('status', request('status'));
                                            })
                                            ->sum('valor_pago')) }}
                                        </div>
                                    </div>
                                    <div class="icon-circle bg-white">
                                        <i class="fas fa-check-circle text-success"></i>
                                    </div>
                                </div>
                                <p class="mb-0">Total já pago</p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Card Valor Pendente -->
                    <div class="col-md-6 col-lg-3 mb-3">
                        <div class="card resumo-card bg-pendente">
                            <div class="card-body text-white">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div>
                                        <h5 class="text-white">Valor Pendente</h5>
                                        <div class="valor">{{ __moeda(
                                            \App\Models\ContaPagar::where('empresa_id', request()->empresa_id)
                                            ->where('status', 0) // Apenas pendentes
                                            ->when(!empty(request('fornecedor_id')), function ($query) {
                                                return $query->where('fornecedor_id', request('fornecedor_id'));
                                            })
                                            ->when(!empty(request('start_date')), function ($query) {
                                                return $query->whereDate('data_vencimento', '>=', request('start_date'));
                                            })
                                            ->when(!empty(request('end_date')), function ($query) {
                                                return $query->whereDate('data_vencimento', '<=', request('end_date'));
                                            })
                                            ->when(!empty(request('local_id')), function ($query) {
                                                return $query->where('local_id', request('local_id'));
                                            })
                                            ->when(empty(request('local_id')), function ($query) {
                                                $locais = __getLocaisAtivoUsuario()->pluck('id');
                                                return $query->whereIn('local_id', $locais);
                                            })
                                            ->when(request('status') != '', function ($query) {
                                                return $query->where('status', request('status'));
                                            })
                                            ->get()
                                            ->sum(function($conta) {
                                                return $conta->valorPendente();
                                            })
                                        ) }}
                                        </div>
                                    </div>
                                    <div class="icon-circle bg-white">
                                        <i class="fas fa-clock text-info"></i>
                                    </div>
                                </div>
                                <p class="mb-0">Total ainda a pagar</p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Card Valores Vencidos -->
                    <div class="col-md-6 col-lg-3 mb-3">
                        <div class="card resumo-card bg-vencido">
                            <div class="card-body text-white">
                                <div class="d-flex justify-content-between align-items-center mb-3">
                                    <div>
                                        <h5 class="text-white">Valores Vencidos</h5>
                                        <div class="valor">{{ __moeda(
                                            \App\Models\ContaPagar::where('empresa_id', request()->empresa_id)
                                            ->where('status', 0) // Apenas pendentes
                                            ->whereDate('data_vencimento', '<', now()) // Vencidas
                                            ->when(!empty(request('fornecedor_id')), function ($query) {
                                                return $query->where('fornecedor_id', request('fornecedor_id'));
                                            })
                                            ->when(!empty(request('start_date')), function ($query) {
                                                return $query->whereDate('data_vencimento', '>=', request('start_date'));
                                            })
                                            ->when(!empty(request('end_date')), function ($query) {
                                                return $query->whereDate('data_vencimento', '<=', request('end_date'));
                                            })
                                            ->when(!empty(request('local_id')), function ($query) {
                                                return $query->where('local_id', request('local_id'));
                                            })
                                            ->when(empty(request('local_id')), function ($query) {
                                                $locais = __getLocaisAtivoUsuario()->pluck('id');
                                                return $query->whereIn('local_id', $locais);
                                            })
                                            ->when(request('status') != '', function ($query) {
                                                return $query->where('status', request('status'));
                                            })
                                            ->sum('valor_integral')
                                        ) }}
                                        </div>
                                    </div>
                                    <div class="icon-circle bg-white">
                                        <i class="fas fa-exclamation-triangle text-danger"></i>
                                    </div>
                                </div>
                                <p class="mb-0">Total de contas vencidas</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-12 mt-4">
                    <div class="table-responsive">
                        <table class="table table-centered mb-0">
                            <thead class="table-dark">
                                <tr>
                                    @can('conta_pagar_delete')
                                    <th>
                                        <div class="form-check form-checkbox-danger mb-2">
                                            <input class="form-check-input" type="checkbox" id="select-all-checkbox">
                                        </div>
                                    </th>
                                    @endcan
                                    <th>Razão Social</th>
                                    <th>Descrição</th>
                                    @if(__countLocalAtivo() > 1)
                                    <th>Local</th>
                                    @endif
                                    <th>Valor Integral</th>
                                    <th>Valor Pago</th>
                                    <th>Data Cadastro</th>
                                    <th>Data Vencimento</th>
                                    <th>Data Pagamento</th>
                                    <th>Estado</th>
                                    <th width="10%">Ações</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($data as $item)
                                <tr class="{{ $item->status ? 'table-success' : (!$item->status && strtotime($item->data_vencimento) < strtotime(date('Y-m-d')) ? 'table-danger' : '') }}">
                                    @can('conta_pagar_delete')
                                    <td>
                                        <div class="form-check form-checkbox-danger mb-2">
                                            <input class="form-check-input check-delete" type="checkbox" name="item_delete[]" value="{{ $item->id }}">
                                        </div>
                                    </td>
                                    @endcan
                                    <td>{{ $item->fornecedor ? $item->fornecedor->razao_social : '--' }}</td>
                                    <td class="text-truncate" style="max-width: 180px">{{ $item->descricao }}</td>
                                    @if(__countLocalAtivo() > 1)
                                    <td class="text-danger">{{ $item->localizacao->descricao }}</td>
                                    @endif
                                    <td>{{ __moeda($item->valor_integral) }}</td>
                                    <td>{{ __moeda($item->valor_pago) }}</td>
                                    <td>{{ __data_pt($item->created_at, 0) }}</td>
                                    <td>
                                        {{ __data_pt($item->data_vencimento, 0) }}
                                        @if(!$item->status)
                                        <br>
                                        <span class="text-danger" style="font-size: 10px">{{ $item->diasAtraso() }}</span>
                                        @endif
                                    </td>
                                    <td>{{ $item->status ? __data_pt($item->data_pagamento, false) : '--' }}</td>
                                    <td>
                                        <span class="badge bg-{{ $item->status ? 'success' : 'warning' }}">
                                            {{ $item->status ? 'Pago' : 'Pendente' }}
                                        </span>
                                        @if($item->parent_id)
                                        <span class="badge bg-info" title="Parcela {{ $item->parcela_atual }}/{{ $item->total_parcelas }}">
                                            <i class="ri-calendar-line"></i> Reparcelada
                                        </span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-outline-secondary btn-sm dropdown-toggle w-100" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                Ações
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-end shadow-sm small">
                                                @if(!$item->status)
                                                    @can('conta_pagar_edit')
                                                    <li>
                                                        <a href="{{ route('conta-pagar.pay', $item) }}" class="dropdown-item text-success">
                                                            <i class="ri-money-dollar-box-line me-1"></i> Pagar
                                                        </a>
                                                    </li>
                                                    @endcan
                                                    
                                                    @can('conta_pagar_edit')
                                                    <li>
                                                        <a class="dropdown-item text-warning" href="{{ route('conta-pagar.edit', [$item->id]) }}">
                                                            <i class="ri-pencil-fill me-1"></i> Editar
                                                        </a>
                                                    </li>
                                                    @endcan
                                                    
                                                    @can('conta_pagar_delete')
                                                    <li>
                                                        <button type="button" class="dropdown-item text-danger btn-delete" 
                                                                onclick="confirmDeleteItem('{{ $item->id }}', '{{ __data_pt($item->data_vencimento, 0) }}, R$ {{ __moeda($item->valor_integral) }}')">
                                                            <i class="ri-delete-bin-line me-1"></i> Excluir
                                                        </button>
                                                    </li>
                                                    @endcan
                                                @endif
                                                
                                                <li>
                                                    <button type="button" class="dropdown-item text-secondary" data-bs-toggle="modal" data-bs-target="#historicoModal{{ $item->id }}">
                                                        <i class="fas fa-history me-1"></i> Histórico
                                                    </button>
                                                </li>
                                            </ul>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="11" class="text-center">Nada encontrado</td>
                                </tr>
                                @endforelse
                            </tbody>
                            <tfoot>
                                <tr>
                                    <td colspan="3">Soma da pagina</td>
                                    <td>{{ __moeda($data->sum('valor_integral')) }}</td>
                                    <td>{{ __moeda($data->sum('valor_pago')) }}</td>
                                </tr>
                            </tfoot>
                        </table>

                    </div>

                    <br>
                    <div class="row g-2">
                        <div class="col-12 col-sm-6 col-md-3 col-lg-2">
                            @can('conta_pagar_delete')
                            <form action="{{ route('conta-pagar.destroy-select') }}" method="post" id="form-delete-select">
                                @method('delete')
                                @csrf
                                <div></div>
                                <button type="button" class="btn btn-danger btn-sm w-100 btn-delete-all" disabled>
                                    <i class="ri-close-circle-line"></i> Remover selecionados
                                </button>
                            </form>
                            @endcan
                        </div>

                        <div class="col-12 col-sm-6 col-md-3 col-lg-2">
                            @can('conta_pagar_edit')
                            <form action="{{ route('conta-pagar.pagar-select') }}" method="post" id="form-recebe-paga-select">
                                @csrf
                                <div></div>
                                <button type="button" class="btn btn-success btn-sm w-100 btn-recebe-paga-all" disabled>
                                    <i class="ri-check-line"></i> Pagar selecionados
                                </button>
                            </form>
                            @endcan
                        </div>
                    </div>
                </div>
                <br>
                {!! $data->appends(request()->all())->links() !!}
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="pagamentoLoteModal" tabindex="-1" aria-labelledby="pagamentoLoteModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="pagamentoLoteModalLabel">Pagamento em Lote</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
      </div>
      <form id="formPagamentoLote" action="{{ route('conta-pagar.pagarSelecionados') }}" method="POST">
        @csrf
        <div class="modal-body">
          <div class="alert alert-info">
            <span id="contasSelecionar">0</span> contas selecionadas. 
            Total: <strong id="totalSelecionado">R$ 0,00</strong>
          </div>
          
          <div class="form-group mb-3">
            <label for="tipoPagamentoLote">Tipo de Pagamento</label>
            <select class="form-control" id="tipoPagamentoLote" name="tipo_pagamento" required>
              <option value="">Selecione</option>
              <option value="dinheiro">Dinheiro</option>
              <option value="pix">PIX</option>
              <option value="cartao">Cartão</option>
              <option value="boleto">Boleto</option>
              <option value="transferencia">Transferência</option>
              <option value="cheque">Cheque</option>
            </select>
          </div>
          
          <div class="form-group mb-3">
            <label for="dataPagamentoLote">Data do Pagamento</label>
            <input type="date" class="form-control" id="dataPagamentoLote" name="data_pagamento" value="{{ date('Y-m-d') }}" required>
          </div>
          
          <div class="form-group mb-3">
            <label>Aplicar Desconto/Juros?</label>
            <div class="form-check">
              <input class="form-check-input" type="radio" name="aplicarAjuste" id="semAjuste" value="nenhum" checked>
              <label class="form-check-label" for="semAjuste">
                Pagar valor integral
              </label>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="radio" name="aplicarAjuste" id="comDesconto" value="desconto">
              <label class="form-check-label" for="comDesconto">
                Aplicar desconto (%)
              </label>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="radio" name="aplicarAjuste" id="comJuros" value="juros">
              <label class="form-check-label" for="comJuros">
                Aplicar juros (%)
              </label>
            </div>
          </div>
          
          <div id="ajusteValorGroup" class="form-group mb-3 d-none">
            <label for="valorAjuste">Percentual (%)</label>
            <input type="number" step="0.01" min="0" class="form-control" id="valorAjuste" name="percentual_ajuste" placeholder="0.00">
            <small class="form-text text-muted">Valor ajustado: <span id="valorAjustadoPreview">R$ 0,00</span></small>
          </div>
          
          <div id="contasSelecionadasContainer" class="mt-3">
            <h6>Contas Selecionadas:</h6>
            <div class="table-responsive">
              <table class="table table-sm table-bordered">
                <thead>
                  <tr>
                    <th>Fornecedor</th>
                    <th>Vencimento</th>
                    <th>Valor Original</th>
                    <th>Valor a Pagar</th>
                  </tr>
                </thead>
                <tbody id="contasSelecionadasBody">
                  <!-- Será preenchido via JavaScript -->
                </tbody>
              </table>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
          <button type="submit" class="btn btn-primary">Confirmar Pagamento</button>
        </div>
        
        <!-- Campos ocultos para armazenar os IDs e valores -->
        <input type="hidden" id="idsSelecionados" name="ids_selecionados">
        <input type="hidden" id="valoresPagamento" name="valores_pagamento">
      </form>
    </div>
  </div>
</div>
@endsection
@section('js')
<script type="text/javascript" src="/js/delete_selecionados.js"></script>
<script type="text/javascript" src="/js/recebe_paga_selecionados.js"></script>

<script>
  $(document).ready(function() {
    // Variáveis para armazenar informações das contas selecionadas
    let contasSelecionadas = [];
    let totalSelecionado = 0;
    
    // Atualizar botão de pagar selecionados para abrir modal
    $('#btnPagarSelecionados').off('click').on('click', function(e) {
      e.preventDefault();
      
      // Limpar dados anteriores
      contasSelecionadas = [];
      totalSelecionado = 0;
      
      // Verificar contas selecionadas
      $('input[name="item_recebe_paga[]"]:checked').each(function() {
        const id = $(this).val();
        const fornecedor = $(this).data('fornecedor') || 'Não identificado';
        const vencimento = $(this).data('vencimento') || '';
        const valor = parseFloat($(this).data('valor') || 0);
        
        contasSelecionadas.push({
          id: id,
          fornecedor: fornecedor,
          vencimento: vencimento,
          valor: valor,
          valorPagar: valor // inicialmente igual ao valor original
        });
        
        totalSelecionado += valor;
      });
      
      if (contasSelecionadas.length === 0) {
        alert('Selecione pelo menos uma conta para pagar.');
        return;
      }
      
      // Preencher informações no modal
      $('#contasSelecionar').text(contasSelecionadas.length);
      $('#totalSelecionado').text(formatarMoeda(totalSelecionado));
      
      // Preencher tabela de contas
      preencherTabelaContas();
      
      // Abrir modal
      $('#pagamentoLoteModal').modal('show');
    });
    
    // Controlar visibilidade do campo de ajuste
    $('input[name="aplicarAjuste"]').change(function() {
      if ($(this).val() === 'nenhum') {
        $('#ajusteValorGroup').addClass('d-none');
        resetarValoresPagamento();
      } else {
        $('#ajusteValorGroup').removeClass('d-none');
        calcularAjuste();
      }
    });
    
    // Calcular ajuste quando o percentual mudar
    $('#valorAjuste').on('input', function() {
      calcularAjuste();
    });
    
    // Função para preencher a tabela de contas selecionadas
    function preencherTabelaContas() {
      const tbody = $('#contasSelecionadasBody');
      tbody.empty();
      
      contasSelecionadas.forEach(conta => {
        tbody.append(`
          <tr data-id="${conta.id}">
            <td>${conta.fornecedor}</td>
            <td>${conta.vencimento}</td>
            <td class="text-end">${formatarMoeda(conta.valor)}</td>
            <td class="text-end valor-pagar">${formatarMoeda(conta.valorPagar)}</td>
          </tr>
        `);
      });
    }
    
    // Função para calcular ajuste (desconto ou juros)
    function calcularAjuste() {
      const tipoAjuste = $('input[name="aplicarAjuste"]:checked').val();
      const percentual = parseFloat($('#valorAjuste').val() || 0);
      
      if (tipoAjuste === 'nenhum' || percentual === 0) {
        resetarValoresPagamento();
        return;
      }
      
      let novoTotal = 0;
      
      contasSelecionadas.forEach(conta => {
        if (tipoAjuste === 'desconto') {
          conta.valorPagar = conta.valor * (1 - (percentual / 100));
        } else if (tipoAjuste === 'juros') {
          conta.valorPagar = conta.valor * (1 + (percentual / 100));
        }
        
        novoTotal += conta.valorPagar;
      });
      
      // Atualizar preview e tabela
      $('#valorAjustadoPreview').text(formatarMoeda(novoTotal));
      preencherTabelaContas();
    }
    
    // Resetar valores para o original
    function resetarValoresPagamento() {
      contasSelecionadas.forEach(conta => {
        conta.valorPagar = conta.valor;
      });
      
      $('#valorAjustadoPreview').text(formatarMoeda(totalSelecionado));
      preencherTabelaContas();
    }
    
    // Preparar dados antes de enviar o formulário
    $('#formPagamentoLote').on('submit', function(e) {
      const ids = $('#idsSelecionados').val();
      console.log('Enviando IDs para processamento:', ids);
      
      // Se não houver IDs, previne o envio
      if (!ids || ids.trim() === '') {
          e.preventDefault();
          alert('Nenhuma conta selecionada para pagamento!');
          return false;
      }
    });
    
    // Função auxiliar para formatar valores em moeda
    function formatarMoeda(valor) {
      return 'R$ ' + valor.toFixed(2).replace('.', ',').replace(/(\d)(?=(\d{3})+\,)/g, '$1.');
    }
  });
</script>

@endsection