@extends('layouts.app', ['title' => 'Relatório de Acessos'])
@section('css')
<style type="text/css">
    .card-header {
        border-bottom: 1px solid #999;
        margin-left: 5px;
        margin-right: 5px;
    }
    
    .metric-card {
        text-align: center;
        border-radius: 8px;
        transition: all 0.3s;
    }
    
    .metric-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
    }
    
    .metric-icon {
        font-size: 2.5rem;
        margin-bottom: 10px;
    }
    
    .metric-value {
        font-size: 2rem;
        font-weight: bold;
    }
    
    .metric-title {
        font-size: 1rem;
        color: #6c757d;
    }
    
    .sub-table {
        font-size: 0.9rem;
    }
    
    .accordion-button:not(.collapsed) {
        background-color: #f8f9fa;
        color: #0d6efd;
    }
    
    .nav-tabs .nav-link.active {
        font-weight: bold;
    }
    
    .stat-card {
        background-color: #f8f9fa;
        border-radius: 8px;
        padding: 15px;
        margin-bottom: 15px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.05);
    }
    
    .stat-heading {
        font-size: 1.1rem;
        font-weight: bold;
        margin-bottom: 10px;
        color: #495057;
    }
    
    .stat-value {
        font-size: 1.5rem;
        font-weight: bold;
        color: #0d6efd;
    }
    
    .stat-label {
        font-size: 0.9rem;
        color: #6c757d;
    }
</style>
@endsection

@section('content')
<div class="mt-3">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5>Relatório de Acessos ao Sistema</h5>
                    <div>
                        <a href="{{ route('acessos-clientes.index') }}" class="btn btn-sm btn-outline-secondary">
                            <i class="ri-arrow-left-line"></i> Voltar
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Filtros aplicados -->
                    <div class="alert alert-light mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <strong>Período:</strong> {{ $startDate ?? 'Sem data inicial' }} a {{ $endDate ?? 'Sem data final' }}
                            </div>
                            <div class="col-md-3">
                                <strong>Empresa:</strong> {{ $empresaId ? $empresas->where('id', $empresaId)->first()->nome : 'Todas' }}
                            </div>
                            <div class="col-md-3">
                                <strong>Usuário:</strong> {{ $usuarioId ? $usuarios->where('id', $usuarioId)->first()->name : 'Todos' }}
                            </div>
                            <div class="col-md-3">
                                <strong>SuperAdmin:</strong> 
                                @if(isset($ignorarSuperAdmin) && $ignorarSuperAdmin)
                                    <span class="badge bg-info">Ignorado</span>
                                @else
                                    <span class="badge bg-warning">Incluído</span>
                                @endif
                            </div>
                        </div>
                    </div>
                    
                    <!-- Métricas principais -->
                    <div class="row mb-4">
                        <div class="col-md-4">
                            <div class="card metric-card bg-light">
                                <div class="card-body">
                                    <div class="metric-icon text-primary">
                                        <i class="ri-login-circle-line"></i>
                                    </div>
                                    <div class="metric-value">{{ $metricas['frequencia_login'] }}</div>
                                    <div class="metric-title">Frequência de Login</div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="card metric-card bg-light">
                                <div class="card-body">
                                    <div class="metric-icon text-success">
                                        <i class="ri-time-line"></i>
                                    </div>
                                    <div class="metric-value">{{ $metricas['tempo_medio_sessao'] }} min</div>
                                    <div class="metric-title">Tempo Médio por Sessão</div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="card metric-card bg-light">
                                <div class="card-body">
                                    <div class="metric-icon text-info">
                                        <i class="ri-apps-2-line"></i>
                                    </div>
                                    <div class="metric-value">{{ $metricas['media_funcionalidades'] }}</div>
                                    <div class="metric-title">Média de Funcionalidades Usadas</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Seção com Tabs para os diferentes relatórios -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <ul class="nav nav-tabs" id="myTab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="empresas-tab" data-bs-toggle="tab" data-bs-target="#empresas-tab-pane" type="button" role="tab" aria-controls="empresas-tab-pane" aria-selected="true">
                                        <i class="ri-building-line"></i> Acessos por Empresa
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="usuarios-tab" data-bs-toggle="tab" data-bs-target="#usuarios-tab-pane" type="button" role="tab" aria-controls="usuarios-tab-pane" aria-selected="false">
                                        <i class="ri-user-line"></i> Acessos por Usuário
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="telas-tab" data-bs-toggle="tab" data-bs-target="#telas-tab-pane" type="button" role="tab" aria-controls="telas-tab-pane" aria-selected="false">
                                        <i class="ri-layout-line"></i> Telas Mais Acessadas
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="graficos-tab" data-bs-toggle="tab" data-bs-target="#graficos-tab-pane" type="button" role="tab" aria-controls="graficos-tab-pane" aria-selected="false">
                                        <i class="ri-bar-chart-line"></i> Gráficos
                                    </button>
                                </li>
                            </ul>
                            
                            <div class="tab-content border border-top-0 rounded-bottom p-3" id="myTabContent">
                                <!-- Tab de Acessos por Empresa -->
                                <div class="tab-pane fade show active" id="empresas-tab-pane" role="tabpanel" aria-labelledby="empresas-tab" tabindex="0">
                                    <h5 class="mb-3">Estatísticas de Acessos por Empresa</h5>
                                    
                                    @if($acessosPorEmpresa->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-striped table-hover">
                                                <thead class="table-dark">
                                                    <tr>
                                                        <th>Empresa</th>
                                                        <th class="text-center">Total de Acessos</th>
                                                        <th class="text-center">Usuários Ativos</th>
                                                        <th class="text-center">Menus Acessados</th>
                                                        <th class="text-center">Dias com Acesso</th>
                                                        <th class="text-center">Média Acessos/Dia</th>
                                                        <th class="text-center">Média Acessos/Usuário</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($acessosPorEmpresa as $empresa)
                                                    <tr>
                                                        <td>{{ $empresa->nome_empresa }}</td>
                                                        <td class="text-center">{{ $empresa->total_acessos }}</td>
                                                        <td class="text-center">{{ $empresa->total_usuarios }}</td>
                                                        <td class="text-center">{{ $empresa->menus_distintos }}</td>
                                                        <td class="text-center">{{ $empresa->dias_com_acesso }}</td>
                                                        <td class="text-center">{{ $empresa->media_acessos_por_dia }}</td>
                                                        <td class="text-center">{{ $empresa->media_acessos_por_usuario }}</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            <i class="ri-information-line"></i> Nenhum dado de acesso por empresa encontrado para o período selecionado.
                                        </div>
                                    @endif
                                </div>
                                
                                <!-- Tab de Acessos por Usuário -->
                                <div class="tab-pane fade" id="usuarios-tab-pane" role="tabpanel" aria-labelledby="usuarios-tab" tabindex="0">
                                    <h5 class="mb-3">Estatísticas de Acessos por Usuário</h5>
                                    
                                    @if($acessosPorUsuario->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-striped table-hover">
                                                <thead class="table-dark">
                                                    <tr>
                                                        <th>Usuário</th>
                                                        <th>Empresa</th>
                                                        <th class="text-center">Total de Acessos</th>
                                                        <th class="text-center">Menus Acessados</th>
                                                        <th class="text-center">Dias com Acesso</th>
                                                        <th class="text-center">Média Acessos/Dia</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($acessosPorUsuario as $usuario)
                                                    <tr>
                                                        <td>{{ $usuario->nome_usuario }}</td>
                                                        <td>{{ $usuario->nome_empresa }}</td>
                                                        <td class="text-center">{{ $usuario->total_acessos }}</td>
                                                        <td class="text-center">{{ $usuario->menus_distintos }}</td>
                                                        <td class="text-center">{{ $usuario->dias_com_acesso }}</td>
                                                        <td class="text-center">{{ $usuario->media_acessos_por_dia }}</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            <i class="ri-information-line"></i> Nenhum dado de acesso por usuário encontrado para o período selecionado.
                                        </div>
                                    @endif
                                </div>
                                
                                <!-- Tab de Telas Mais Acessadas -->
                                <div class="tab-pane fade" id="telas-tab-pane" role="tabpanel" aria-labelledby="telas-tab" tabindex="0">
                                    <h5 class="mb-3">Telas Mais Acessadas</h5>
                                    
                                    @if($telasMaisAcessadas->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-striped table-hover">
                                                <thead class="table-dark">
                                                    <tr>
                                                        @if(!$usuarioId && !$empresaId)
                                                            <th>Empresa</th>
                                                        @elseif($empresaId && !$usuarioId)
                                                            <th>Usuário</th>
                                                        @endif
                                                        <th>Menu</th>
                                                        <th>Submenu</th>
                                                        <th class="text-center">Total de Acessos</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($telasMaisAcessadas as $tela)
                                                    <tr>
                                                        @if(!$usuarioId && !$empresaId)
                                                            <td>{{ $tela->nome_empresa }}</td>
                                                        @elseif($empresaId && !$usuarioId)
                                                            <td>{{ $tela->nome_usuario }}</td>
                                                        @endif
                                                        <td>{{ ucfirst($tela->menu) }}</td>
                                                        <td>{{ $tela->submenu ? ucfirst($tela->submenu) : '-' }}</td>
                                                        <td class="text-center">{{ $tela->total_acessos }}</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            <i class="ri-information-line"></i> Nenhum dado de telas acessadas encontrado para o período selecionado.
                                        </div>
                                    @endif
                                </div>
                                
                                <!-- Tab de Gráficos -->
                                <div class="tab-pane fade" id="graficos-tab-pane" role="tabpanel" aria-labelledby="graficos-tab" tabindex="0">
                                    <!-- Gráfico de acessos aos menus -->
                                    <div class="card">
                                        <div class="card-header">
                                            <h5>Menus Mais Acessados</h5>
                                        </div>
                                        <div class="card-body">
                                            <canvas id="menuChart" height="300"></canvas>
                                        </div>
                                    </div>
                                    
                                    <!-- Verificar se temos dados para o gráfico de empresas -->
                                    @if($acessosPorEmpresa->count() > 0 && !$empresaId)
                                    <div class="card mt-4">
                                        <div class="card-header">
                                            <h5>Acessos por Empresa</h5>
                                        </div>
                                        <div class="card-body">
                                            <canvas id="empresasChart" height="300"></canvas>
                                        </div>
                                    </div>
                                    @endif
                                    
                                    <!-- Verificar se temos dados para o gráfico de usuários -->
                                    @if($acessosPorUsuario->count() > 0 && $empresaId && !$usuarioId)
                                    <div class="card mt-4">
                                        <div class="card-header">
                                            <h5>Acessos por Usuário</h5>
                                        </div>
                                        <div class="card-body">
                                            <canvas id="usuariosChart" height="300"></canvas>
                                        </div>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Tabela com os dados detalhados -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5>Detalhamento de Acessos</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-striped table-hover">
                                            <thead class="table-dark">
                                                <tr>
                                                    <th>Menu</th>
                                                    <th>Submenu</th>
                                                    <th class="text-center">Total de Acessos</th>
                                                    <th class="text-center">Porcentagem</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php
                                                    $totalGeral = $menusMaisAcessados->sum('total_acessos');
                                                @endphp
                                                
                                                @foreach($menusMaisAcessados as $item)
                                                <tr>
                                                    <td>{{ ucfirst($item->menu) }}</td>
                                                    <td>{{ $item->submenu ? ucfirst($item->submenu) : '-' }}</td>
                                                    <td class="text-center">{{ $item->total_acessos }}</td>
                                                    <td class="text-center">
                                                        {{ number_format(($item->total_acessos / $totalGeral) * 100, 2) }}%
                                                    </td>
                                                </tr>
                                                @endforeach
                                                
                                                @if($menusMaisAcessados->count() == 0)
                                                <tr>
                                                    <td colspan="4" class="text-center">Nenhum acesso registrado no período.</td>
                                                </tr>
                                                @endif
                                            </tbody>
                                            @if($menusMaisAcessados->count() > 0)
                                            <tfoot class="table-dark">
                                                <tr>
                                                    <th colspan="2">Total</th>
                                                    <th class="text-center">{{ $totalGeral }}</th>
                                                    <th class="text-center">100%</th>
                                                </tr>
                                            </tfoot>
                                            @endif
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
    $(document).ready(function() {
        // Dados pré-carregados do PHP (convertidos para JSON no PHP)
        var dadosMenu = {!! json_encode($menusMaisAcessados->take(10)->map(function($item) {
            return [
                'menu' => ucfirst($item->menu) . ($item->submenu ? ' - ' . ucfirst($item->submenu) : ''),
                'total' => $item->total_acessos
            ];
        })) !!};
        
        // Preparar dados para o gráfico
        var labels = [];
        var data = [];
        var backgroundColors = [];
        
        // Gerar cores aleatórias
        function getRandomColor() {
            var r = Math.floor(Math.random() * 200);
            var g = Math.floor(Math.random() * 200);
            var b = Math.floor(Math.random() * 200);
            return "rgba(" + r + ", " + g + ", " + b + ", 0.7)";
        }
        
        // Processar dados para o gráfico
        for (var i = 0; i < dadosMenu.length; i++) {
            labels.push(dadosMenu[i].menu);
            data.push(dadosMenu[i].total);
            backgroundColors.push(getRandomColor());
        }
        
        // Criar o gráfico
        var ctx = document.getElementById('menuChart').getContext('2d');
        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: labels,
                datasets: [{
                    label: 'Número de Acessos',
                    data: data,
                    backgroundColor: backgroundColors,
                    borderColor: backgroundColors.map(function(color) {
                        return color.replace('0.7', '1');
                    }),
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true,
                        title: {
                            display: true,
                            text: 'Total de Acessos'
                        }
                    },
                    x: {
                        title: {
                            display: true,
                            text: 'Menus/Submenus'
                        }
                    }
                },
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                return context.parsed.y + ' acessos';
                            }
                        }
                    }
                }
            }
        });
        
        // Gráfico por empresa (se disponível)
        @if($acessosPorEmpresa->count() > 0 && !$empresaId)
        var dadosEmpresas = {!! json_encode($acessosPorEmpresa->take(8)->map(function($item) {
            return [
                'nome' => $item->nome_empresa,
                'total' => $item->total_acessos
            ];
        })) !!};
        
        var labelsEmpresas = dadosEmpresas.map(function(item) { return item.nome; });
        var dataEmpresas = dadosEmpresas.map(function(item) { return item.total; });
        var colorsEmpresas = dadosEmpresas.map(function() { return getRandomColor(); });
        
        var ctxEmpresas = document.getElementById('empresasChart').getContext('2d');
        new Chart(ctxEmpresas, {
            type: 'doughnut',
            data: {
                labels: labelsEmpresas,
                datasets: [{
                    data: dataEmpresas,
                    backgroundColor: colorsEmpresas,
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'right'
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                var total = context.dataset.data.reduce(function(a, b) { return a + b; }, 0);
                                var percentual = Math.round((context.raw / total) * 100);
                                return context.label + ': ' + context.raw + ' (' + percentual + '%)';
                            }
                        }
                    }
                }
            }
        });
        @endif
        
        // Gráfico por usuário dentro de uma empresa específica
        @if($acessosPorUsuario->count() > 0 && $empresaId && !$usuarioId)
        var dadosUsuarios = {!! json_encode($acessosPorUsuario->take(10)->map(function($item) {
            return [
                'nome' => $item->nome_usuario,
                'total' => $item->total_acessos
            ];
        })) !!};
        
        var labelsUsuarios = dadosUsuarios.map(function(item) { return item.nome; });
        var dataUsuarios = dadosUsuarios.map(function(item) { return item.total; });
        var colorsUsuarios = dadosUsuarios.map(function() { return getRandomColor(); });
        
        var ctxUsuarios = document.getElementById('usuariosChart').getContext('2d');
        new Chart(ctxUsuarios, {
            type: 'pie',
            data: {
                labels: labelsUsuarios,
                datasets: [{
                    data: dataUsuarios,
                    backgroundColor: colorsUsuarios,
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'right'
                    },
                    tooltip: {
                        callbacks: {
                            label: function(context) {
                                var total = context.dataset.data.reduce(function(a, b) { return a + b; }, 0);
                                var percentual = Math.round((context.raw / total) * 100);
                                return context.label + ': ' + context.raw + ' (' + percentual + '%)';
                            }
                        }
                    }
                }
            }
        });
        @endif
    });
</script>
@endsection 