$("tbody .produto_id").select2({
    minimumInputLength: 2,
    language: "pt-BR",
    placeholder: "Digite para buscar o produto",
    width: "100%",
    ajax: {
        cache: true,
        url: path_url + "api/produtos",
        dataType: "json",
        data: function (params) {
            let empresa_id = $('#empresa_id').val()
            console.clear();
            var query = {
                pesquisa: params.term,
                empresa_id: empresa_id
            };
            return query;
        },
        processResults: function (response) {
            var results = [];
            
            $.each(response, function (i, v) {
                var o = {};
                o.id = v.id;
                if(v.codigo_variacao){
                    o.codigo_variacao = v.codigo_variacao
                }

                o.text = v.nome;
                o.text += ' R$ ' + convertFloatToMoeda(v.valor_compra);
                
                if(v.codigo_barras){
                    o.text += ' [' + v.codigo_barras  + ']';
                }
                o.value = v.id;
                results.push(o);
            });
            return {
                results: results,
            };
        },
    },
});

var KEY = null;
$(document).on("click", ".btn-modal-altera", function () {
    // $('#modal_altera_produto #check').removeAttr('checked')
    $inpNome = $(this).closest("td").find('.produto_nome')
    $inpGerenciaEstoque = $(this).closest("td").find('._gerenciar_estoque')
    $inpNcm = $(this).closest("tr").find('.ncm')
    $inpProdutoId = $(this).closest("td").find('._produto_id')
    $inpCategoriaId = $(this).closest("td").find('._categoria_id')
    $inpMarcaId = $(this).closest("td").find('._marca_id')
    $inpValorVenda = $(this).closest("tr").find('.valor_venda')
    $inpValorCompra = $(this).closest("tr").find('.valor_compra')
    $inpEstoqueMinimo = $(this).closest("tr").find('._estoque_minimo')
    $inpCodigoBarras = $(this).closest("tr").find('._codigo_barras')
    $inpCheck = $(this).closest("tr").find('._check')
    $inpMargem = $(this).closest("tr").find('._margem')
    $inpReferencia = $(this).closest("tr").find('._referencia')
    $inpReferenciaBalanca = $(this).closest("tr").find('._referencia_balanca')
    $inpUnidade = $(this).closest("tr").find('.unidade')
    $inpExportarBalanca = $(this).closest("tr").find('._exportar_balanca')
    $inpObservacao = $(this).closest("tr").find('._observacao')
    $inpObservacao2 = $(this).closest("tr").find('._observacao2')
    $inpObservacao3 = $(this).closest("tr").find('._observacao3')
    $inpObservacao4 = $(this).closest("tr").find('._observacao4')
    $inpDisponibilidade = $(this).closest("tr").find('._disponibilidade')
    $inpQuantidade = $(this).closest("tr").find('.qtd')
    $inpConversao = $(this).closest("tr").find('input[name="conversao_estoque[]"]')
    $inpValorPorUnidade = $(this).closest("tr").find('.valor_por_unidade')

    KEY = $(this).data('key')

    $('#modal_altera_produto').modal('show')
    $('#modal_altera_produto .modal-title').text($inpNome.val())
    $('#modal_altera_produto #modal_codigo').val($inpProdutoId.val())
    $('#modal_altera_produto #modal_nome').val($inpNome.val())

    $('#modal_altera_produto #modal_categoria_id').val($inpCategoriaId.val()).change()
    $('#modal_altera_produto #modal_codigo_barras').val($inpCodigoBarras.val()).change()
    $('#modal_altera_produto #modal_marca_id').val($inpMarcaId.val()).change()
    $('#modal_altera_produto #modal_gerenciar_estoque').val($inpGerenciaEstoque.val()).change()
    $('#modal_altera_produto #modal_ncm').val($inpNcm.val())
    $('#modal_altera_produto #modal_valor_venda').val($inpValorVenda.val())
    $('#modal_altera_produto #modal_valor_compra').val($inpValorCompra.val())
    $('#modal_altera_produto #modal_estoque_minimo').val($inpEstoqueMinimo.val())
    $('#modal_altera_produto #modal_margem').val($inpMargem.val())

    $('#modal_altera_produto #modal_referencia').val($inpReferencia.val())
    $('#modal_altera_produto #modal_referencia_balanca').val($inpReferenciaBalanca.val())
    $('#modal_altera_produto #modal_unidade').val($inpUnidade.val()).change()
    $('#modal_altera_produto #modal_exportar_balanca').val($inpExportarBalanca.val()).change()

    $('#modal_altera_produto #modal_observacao').val($inpObservacao.val())
    $('#modal_altera_produto #modal_observacao2').val($inpObservacao2.val())
    $('#modal_altera_produto #modal_observacao3').val($inpObservacao3.val())
    $('#modal_altera_produto #modal_observacao4').val($inpObservacao4.val())
    $('#modal_altera_produto #modal_disponibilidade').val(JSON.parse($inpDisponibilidade.val())).change()
    
    // Calcular e mostrar o valor por unidade
    updateValorPorUnidade($inpValorCompra.val(), $inpQuantidade.val(), $inpConversao.val(), '#modal_valor_por_unidade')

    if($inpCheck.val() == 1){
        $('#modal_altera_produto #check').prop('checked', 1)
    }else{
        $('#modal_altera_produto #check').prop('checked', 0)
    }

    // if($inpProdutoId.val() > 0){
        // let produto_id = $inpProdutoId.val()
        // $.get(path_url + "api/produtos/findId/" + produto_id)
        // .done((res) => {
        //     console.log(res)
        // })
        // .fail((err) => {
        //     console.log(err)
        // })
    // }

})

$(document).on("blur", "#modal_margem", function () {
    let margem = $(this).val()
    let valor_compra = convertMoedaToFloat($('#modal_valor_compra').val())

    $('#modal_valor_venda').val(convertFloatToMoeda(valor_compra + (valor_compra*(margem/100))))
    
    // Atualizar valor por unidade ao mudar a margem
    let quantidade = 1;
    let conversao = parseFloat($('.line_'+KEY).find('input[name="conversao_estoque[]"]').val()) || 1;
    updateValorPorUnidade($('#modal_valor_compra').val(), quantidade, conversao, '#modal_valor_por_unidade');
});

$(document).on("blur", "#modal_valor_compra", function () {
    let valor_compra = convertMoedaToFloat($(this).val())
    let margem = $('#modal_margem').val()

    $('#modal_valor_venda').val(convertFloatToMoeda(valor_compra + (valor_compra*(margem/100))))
    
    // Atualizar valor por unidade ao mudar o valor de compra
    let quantidade = 1;
    let conversao = parseFloat($('.line_'+KEY).find('input[name="conversao_estoque[]"]').val()) || 1;
    updateValorPorUnidade($(this).val(), quantidade, conversao, '#modal_valor_por_unidade');
});

$(document).on("click", ".btn-modal-alterar", function () {
    let nome = $('#modal_altera_produto #modal_nome').val()
    let categoria_id = $('#modal_altera_produto #modal_categoria_id').val()
    let codigo_barras = $('#modal_altera_produto #modal_codigo_barras').val()
    let marca_id = $('#modal_altera_produto #modal_marca_id').val()
    let gerenciar_estoque = $('#modal_altera_produto #modal_gerenciar_estoque').val()
    let ncm = $('#modal_altera_produto #modal_ncm').val()
    let valor_venda = $('#modal_altera_produto #modal_valor_venda').val()
    let valor_compra = $('#modal_altera_produto #modal_valor_compra').val()
    let estoque_minimo = $('#modal_altera_produto #modal_estoque_minimo').val()
    let margem = $('#modal_altera_produto #modal_margem').val()
    let check = $('#modal_altera_produto #check').is(':checked')

    let referencia = $('#modal_altera_produto #modal_referencia').val()
    let referencia_balanca = $('#modal_altera_produto #modal_referencia_balanca').val()
    let unidade = $('#modal_altera_produto #modal_unidade').val()
    let exportar_balanca = $('#modal_altera_produto #modal_exportar_balanca').val()
    let observacao = $('#modal_altera_produto #modal_observacao').val()
    let observacao2 = $('#modal_altera_produto #modal_observacao2').val()
    let observacao3 = $('#modal_altera_produto #modal_observacao3').val()
    let observacao4 = $('#modal_altera_produto #modal_observacao4').val()
    let disponibilidade = $('#modal_altera_produto #modal_disponibilidade').val()
    
    // Aplica o fator de conversão ao valor de venda
    let $tr = $('.line_'+KEY);
    let conversao = parseFloat($tr.find('input[name="conversao_estoque[]"]').val()) || 1;
    
    // Se o valor de conversão for maior que 1, dividimos o valor de venda pelo fator de conversão
    if (conversao > 1) {
        let valor_venda_float = convertMoedaToFloat(valor_venda);
        let valor_venda_unitario = valor_venda_float / conversao;
        valor_venda = convertFloatToMoeda(valor_venda_unitario);
    }

    disponibilidade = JSON.stringify(disponibilidade)
    $('.line_'+KEY).find('.ncm').val(ncm)
    $('.line_'+KEY).find('.produto_nome').val(nome)
    $('.line_'+KEY).find('._categoria_id').val(categoria_id)
    $('.line_'+KEY).find('._codigo_barras').val(codigo_barras)
    $('.line_'+KEY).find('._marca_id').val(marca_id)
    $('.line_'+KEY).find('._gerenciar_estoque').val(gerenciar_estoque)
    $('.line_'+KEY).find('.valor_venda').val(valor_venda)
    $('.line_'+KEY).find('.valor_compra').val(valor_compra)
    $('.line_'+KEY).find('._estoque_minimo').val(estoque_minimo)
    $('.line_'+KEY).find('._margem').val(margem)

    $('.line_'+KEY).find('._referencia').val(referencia)
    $('.line_'+KEY).find('._referencia_balanca').val(referencia_balanca)
    $('.line_'+KEY).find('.unidade').val(unidade)
    $('.line_'+KEY).find('._exportar_balanca').val(exportar_balanca)
    $('.line_'+KEY).find('._observacao').val(observacao)
    $('.line_'+KEY).find('._observacao2').val(observacao2)
    $('.line_'+KEY).find('._observacao3').val(observacao3)
    $('.line_'+KEY).find('._observacao4').val(observacao4)
    $('.line_'+KEY).find('._disponibilidade').val(disponibilidade)
    
    // Atualizar o valor por unidade na tabela
    let quantidade = parseFloat($('.line_'+KEY).find('.qtd').val()) || 1;
    updateValorPorUnidade(valor_compra, quantidade, conversao, '.line_'+KEY+' .valor_por_unidade');

    if(check == true){
        $('.line_'+KEY).find('._check').val(1)
        $('.line_'+KEY).addClass('bg-success')
    }else{
        $('.line_'+KEY).find('._check').val(0)
        $('.line_'+KEY).removeClass('bg-success')
    }
    $('#modal_altera_produto').modal('hide')

});

$(document).on("change", ".produto_id", function () {
    let produto_id = $(this).val()
    $cadProd = $(this).prev().prev().prev().prev().prev();
    $label = $(this).closest('td').find('.text-danger');
    $inpKey = $(this).closest('td').find('._key');
    let key = $inpKey.val()
    // console.log($label)
    // console.log($cadProd)
    // $cadProd.val('0')
    $label.text('Produto vinculado')
    $label.removeClass('text-danger')
    $label.addClass('text-primary')


    $.get(path_url + "api/produtos/findId/" + produto_id)
    .done((res) => {
        // console.log(res)
        $('.line_'+key).find('._produto_id').val(res.id)
        $('.line_'+key).find('.produto_nome').val(res.nome)
        $('.line_'+key).find('._categoria_id').val(res.categoria_id)
        $('.line_'+key).find('._marca_id').val(res.marca_id)
        $('.line_'+key).find('._codigo_barras').val(res.codigo_barras)
        $('.line_'+key).find('.ncm').val(res.ncm)
        $('.line_'+key).find('._estoque_minimo').val(res.estoque_minimo)
        $('.line_'+key).find('._gerenciar_estoque').val(res.gerenciar_estoque).change()
        $('.line_'+key).find('.valor_venda').val(convertFloatToMoeda(res.valor_unitario))
        $('.line_'+key).find('.valor_compra').val(convertFloatToMoeda(res.valor_compra))
        $('.line_'+key).find('._margem').val(res.percentual_lucro)

    })
    .fail((err) => {
        console.log(err)
    })
    // alterar dados no html
})

// Evento para quando o fator de conversão for alterado
$(document).on("change", "input[name='conversao_estoque[]']", function() {
    let $tr = $(this).closest('tr');
    let conversao = parseFloat($(this).val().replace(',', '.'));
    
    // Se o valor de conversão for inválido ou zero, usar 1
    if (isNaN(conversao) || conversao <= 0) {
        conversao = 1;
        $(this).val(1);
    }
    
    // Obtém o valor de compra atual (valor unitário)
    let valor_compra = convertMoedaToFloat($tr.find('.valor_compra').val());
    
    // Obtém a margem de lucro
    let margem = parseFloat($tr.find('._margem').val());
    
    // Calcula o valor de venda por unidade (após a conversão)
    let valor_venda_total = valor_compra + (valor_compra * (margem/100));
    let valor_venda_unitario = valor_venda_total / conversao;
    
    // Atualiza o campo de valor de venda
    $tr.find('.valor_venda').val(convertFloatToMoeda(valor_venda_unitario));
    
    // Atualiza o valor por unidade
    let quantidade = parseFloat($tr.find('.qtd').val()) || 1;
    updateValorPorUnidade($tr.find('.valor_compra').val(), quantidade, conversao, $tr.find('.valor_por_unidade'));
    
    // Se o modal estiver aberto, atualiza o valor por unidade também no modal
    if ($('#modal_altera_produto').is(':visible') && KEY !== null) {
        updateValorPorUnidade($('#modal_valor_compra').val(), quantidade, conversao, '#modal_valor_por_unidade');
    }
});

// Função para calcular e atualizar o valor por unidade
function updateValorPorUnidade(valorCompra, quantidade, conversao, elementSelector) {
    let valor_compra = convertMoedaToFloat(valorCompra);
    quantidade = parseFloat(quantidade) || 1;
    conversao = parseFloat(conversao) || 1;
    
    // Valor total ÷ quantidade = valor por unidade
    let valor_total = valor_compra * quantidade;
    let valor_por_unidade = valor_total / (quantidade * conversao);
    
    // Formatar e atualizar o campo
    $(elementSelector).val(convertFloatToMoeda(valor_por_unidade));
}

// Garante que os valores iniciais sejam atualizados quando a página carregar
$(document).ready(function() {
    // Calcular o valor por unidade para cada produto na tabela
    $("input[name='conversao_estoque[]']").each(function() {
        let $tr = $(this).closest('tr');
        let conversao = parseFloat($(this).val()) || 1;
        let valor_compra = $tr.find('.valor_compra').val();
        let quantidade = parseFloat($tr.find('.qtd').val()) || 1;
        
        updateValorPorUnidade(valor_compra, quantidade, conversao, $tr.find('.valor_por_unidade'));
    });
    
    // Inicializar select2 para busca de produtos no modal de vinculação
    $(".select-produto-vincular").select2({
        minimumInputLength: 2,
        language: "pt-BR",
        placeholder: "Digite para buscar o produto",
        width: "100%",
        dropdownParent: $("#modal_vincular_produto"),
        ajax: {
            cache: true,
            url: path_url + "api/produtos",
            dataType: "json",
            data: function (params) {
                let empresa_id = $('#empresa_id').val()
                var query = {
                    pesquisa: params.term,
                    empresa_id: empresa_id
                };
                return query;
            },
            processResults: function (response) {
                var results = [];
                
                $.each(response, function (i, v) {
                    var o = {};
                    o.id = v.id;
                    o.text = v.nome;
                    o.text += ' R$ ' + convertFloatToMoeda(v.valor_compra);
                    
                    if(v.codigo_barras){
                        o.text += ' [' + v.codigo_barras  + ']';
                    }
                    o.value = v.id;
                    results.push(o);
                });
                return {
                    results: results,
                };
            },
        },
    });
    
    // Verificar e preencher ao carregar a página
    verificarNomeFantasia();
    
    // Monitorar alterações no campo de razão social
    $('input[name="fornecedor_nome"]').on('input', function() {
        verificarNomeFantasia();
    });
    
    // Monitorar o foco no campo de nome fantasia
    $('input[name="nome_fantasia"]').on('focus', function() {
        if ($(this).val().trim() === '') {
            verificarNomeFantasia();
        }
    });
    
    function verificarNomeFantasia() {
        let razaoSocial = $('input[name="fornecedor_nome"]').val().trim();
        let nomeFantasia = $('input[name="nome_fantasia"]').val().trim();
        
        if (nomeFantasia === '' && razaoSocial !== '') {
            $('input[name="nome_fantasia"]').val(razaoSocial);
        }
    }
});

function modalXml(nome, valor, cfop){

    $('#modal_show_xml').modal('show')
    let html = '<h3>Descrição: <strong>' + nome + '</strong></h3>'
    html += '<h4>Valor: <strong>R$ ' + convertFloatToMoeda(valor) + '</strong></h4>'
    html += '<h4>CFOP: <strong>' + cfop + '</strong></h4>'
    $('#modal_show_xml .modal-body').html(html)
}

// Verificar se as funções de conversão monetária existem
// Se não existirem, adicioná-las ao código
if (typeof convertMoedaToFloat !== 'function') {
    function convertMoedaToFloat(value) {
        if (!value) {
            return 0;
        }
        
        var number_without_mask = value.toString().replace(/\./g, "").replace(",", ".");
        return parseFloat(number_without_mask.replace(/[^0-9\.]+/g, ""));
    }
}

if (typeof convertFloatToMoeda !== 'function') {
    function convertFloatToMoeda(value) {
        value = parseFloat(value);
        return value.toLocaleString("pt-BR", {
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
        });
    }
}

// Abrir modal para vincular produto
$(document).on("click", ".btn-vincular-produto", function() {
    let key = $(this).data('key');
    let $tr = $('.line_' + key);
    let nomeProduto = $tr.find('.produto_nome').val();
    
    $('#linha_atual').val(key);
    $('#produto_xml_nome').text(nomeProduto);
    $('.select-produto-vincular').val(null).trigger('change');
    
    $('#modal_vincular_produto').modal('show');
});

// Confirmar vinculação de produto
$(document).on("click", ".btn-confirmar-vinculo", function() {
    let produtoId = $('.select-produto-vincular').val();
    
    if (!produtoId) {
        alert('Selecione um produto para vincular!');
        return;
    }
    
    let key = $('#linha_atual').val();
    let $tr = $('.line_' + key);
    
    // Atualizar o status e o botão
    $tr.find('.cadastrar_produto').val(0);
    $tr.find('.produto-status').text('*Produto vinculado manualmente').removeClass('text-danger').addClass('text-success');
    $tr.find('.btn-vincular-produto').hide();
    
    // Buscar informações do produto e preencher os campos
    $.get(path_url + "api/produtos/findId/" + produtoId)
    .done((res) => {
        $tr.find('._produto_id').val(res.id);
        $tr.find('.produto_id').html('<option value="' + res.id + '">' + res.nome + '</option>');
        $tr.find('._categoria_id').val(res.categoria_id);
        $tr.find('._marca_id').val(res.marca_id);
        $tr.find('._codigo_barras').val(res.codigo_barras);
        $tr.find('.ncm').val(res.ncm);
        $tr.find('._estoque_minimo').val(res.estoque_minimo);
        $tr.find('._gerenciar_estoque').val(res.gerenciar_estoque);
        $tr.find('.valor_venda').val(convertFloatToMoeda(res.valor_unitario));
        $tr.find('._margem').val(res.percentual_lucro);
        
        // Atualizar outros campos relevantes
        $tr.find('._referencia').val(res.referencia || '');
        $tr.find('._referencia_balanca').val(res.referencia_balanca || '');
        $tr.find('.unidade').val(res.unidade);
        
        // Recalcular valor por unidade
        let conversao = parseFloat($tr.find('input[name="conversao_estoque[]"]').val()) || 1;
        let valor_compra = $tr.find('.valor_compra').val();
        let quantidade = parseFloat($tr.find('.qtd').val()) || 1;
        
        updateValorPorUnidade(valor_compra, quantidade, conversao, $tr.find('.valor_por_unidade'));
        
        $('#modal_vincular_produto').modal('hide');
    })
    .fail((err) => {
        console.log(err);
        alert('Erro ao buscar informações do produto. Tente novamente.');
    });
});


