<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Adiciona campos à tabela conta_pagars
        Schema::table('conta_pagars', function (Blueprint $table) {
            // Campos para categorização
            $table->foreignId('categoria_id')->nullable()->after('observacao');
            $table->string('prioridade', 15)->nullable()->after('categoria_id');
            
            // Campos para aprovação
            $table->string('nivel_aprovacao', 20)->nullable()->after('prioridade');
            $table->foreignId('aprovado_por')->nullable()->after('nivel_aprovacao');
            $table->dateTime('data_aprovacao')->nullable()->after('aprovado_por');
            
            // Campos para recorrência
            $table->boolean('recorrente')->default(false)->after('data_aprovacao');
            $table->string('periodicidade', 15)->nullable()->after('recorrente');
            $table->integer('total_parcelas')->nullable()->after('periodicidade');
            $table->integer('parcela_atual')->nullable()->after('total_parcelas');
            $table->foreignId('parent_id')->nullable()->after('parcela_atual');
            
            // Centro de custo
            $table->foreignId('centro_custo_id')->nullable()->after('parent_id');
        });

        // Adiciona campos à tabela conta_recebers
        Schema::table('conta_recebers', function (Blueprint $table) {
            // Campos para categorização
            $table->foreignId('categoria_id')->nullable()->after('observacao');
            $table->string('prioridade', 15)->nullable()->after('categoria_id');
            
            // Campos para recorrência
            $table->boolean('recorrente')->default(false)->after('prioridade');
            $table->string('periodicidade', 15)->nullable()->after('recorrente');
            $table->integer('total_parcelas')->nullable()->after('periodicidade');
            $table->integer('parcela_atual')->nullable()->after('total_parcelas');
            $table->foreignId('parent_id')->nullable()->after('parcela_atual');
            
            // Centro de custo
            $table->foreignId('centro_custo_id')->nullable()->after('parent_id');
        });

        // Criar tabela de categorias financeiras
        Schema::create('categoria_contas', function (Blueprint $table) {
            $table->id();
            $table->string('nome', 100);
            $table->text('descricao')->nullable();
            $table->foreignId('empresa_id')->nullable()->constrained('empresas');
            $table->string('cor', 10)->nullable();
            $table->string('icone', 50)->nullable();
            $table->string('tipo', 15)->comment('pagar, receber, ambos');
            $table->foreignId('pai_id')->nullable()->references('id')->on('categoria_contas');
            $table->boolean('ativo')->default(true);
            $table->timestamps();
        });

        // Criar tabela de centros de custo
        Schema::create('centro_custos', function (Blueprint $table) {
            $table->id();
            $table->string('nome', 100);
            $table->string('codigo', 20)->nullable();
            $table->text('descricao')->nullable();
            $table->foreignId('empresa_id')->nullable()->constrained('empresas');
            $table->foreignId('pai_id')->nullable()->references('id')->on('centro_custos');
            $table->boolean('ativo')->default(true);
            $table->timestamps();
        });

        // Criar tabela de alocações de centro de custo
        Schema::create('alocacao_centro_custos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('conta_pagar_id')->nullable()->constrained('conta_pagars');
            $table->foreignId('centro_custo_id')->nullable()->constrained('centro_custos');
            $table->decimal('valor', 16, 7);
            $table->decimal('porcentagem', 5, 2);
            $table->text('observacao')->nullable();
            $table->timestamps();
        });

        // Criar tabela de anexos de contas
        Schema::create('anexo_contas', function (Blueprint $table) {
            $table->id();
            $table->foreignId('conta_pagar_id')->nullable()->constrained('conta_pagars');
            $table->foreignId('conta_receber_id')->nullable()->constrained('conta_recebers');
            $table->string('nome_arquivo', 255);
            $table->string('caminho_arquivo', 255);
            $table->string('tipo_arquivo', 50)->nullable();
            $table->integer('tamanho_arquivo')->nullable();
            $table->text('descricao')->nullable();
            $table->foreignId('usuario_id')->nullable()->constrained('users');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Remove anexos
        Schema::dropIfExists('anexo_contas');

        // Remove alocações de centro de custo
        Schema::dropIfExists('alocacao_centro_custos');

        // Remove centros de custo
        Schema::dropIfExists('centro_custos');

        // Remove categorias
        Schema::dropIfExists('categoria_contas');

        // Remove campos da tabela conta_pagars
        Schema::table('conta_pagars', function (Blueprint $table) {
            $table->dropColumn([
                'categoria_id',
                'prioridade',
                'nivel_aprovacao',
                'aprovado_por',
                'data_aprovacao',
                'recorrente',
                'periodicidade',
                'total_parcelas',
                'parcela_atual',
                'parent_id',
                'centro_custo_id'
            ]);
        });

        // Remove campos da tabela conta_recebers
        Schema::table('conta_recebers', function (Blueprint $table) {
            $table->dropColumn([
                'categoria_id',
                'prioridade',
                'recorrente',
                'periodicidade',
                'total_parcelas',
                'parcela_atual',
                'parent_id',
                'centro_custo_id'
            ]);
        });
    }
}; 