<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MesaComanda extends Model
{
    use HasFactory;

    protected $table = 'mesa_comandas';

    protected $fillable = [
        'empresa_id',
        'numero',
        'status',
        'nome_cliente',
        'valor_total',
        'abertura',
        'fechamento',
    ];

    // Relacionamento com Empresa (opcional)
    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }

    // Relacionamento com itens da comanda
    public function itens()
    {
        return $this->hasMany(ItemComanda::class, 'mesa_comanda_id');
    }
} 