<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\OrdemProducao;
use App\Models\ItemProducao;

class OrdemProducaoController extends Controller
{

    public function __construct()
    {
        $this->middleware('permission:ordem_producao_create', ['only' => ['create', 'store']]);
        $this->middleware('permission:ordem_producao_edit', ['only' => ['edit', 'update']]);
        $this->middleware('permission:ordem_producao_view', ['only' => ['show', 'index']]);
        $this->middleware('permission:ordem_producao_delete', ['only' => ['destroy']]);
    }

    public function index(Request $request){

        $data = OrdemProducao::where('empresa_id', $request->empresa_id)
        ->orderBy('id', 'desc')
        ->paginate(env("PAGINACAO"));

        return view('ordem_producao.index', compact('data'));
    }

    public function create(Request $request){
        $data = ItemProducao::where('produtos.empresa_id', $request->empresa_id)
        ->select('item_producaos.*')
        ->join('produtos', 'produtos.id', '=', 'item_producaos.produto_id')
        ->where('item_producaos.status', 0)
        ->get();
        dd($data);

        return view('ordem_producao.create', compact('data'));

    }
}
