<?php

namespace App\Events;

use App\Models\Empresa;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class LimiteUsoAtingido
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $empresa;
    public $tipoLimite;
    public $valorAtual;
    public $valorLimite;

    /**
     * Create a new event instance.
     *
     * @param Empresa $empresa
     * @param string $tipoLimite Tipo de limite atingido (ex: 'documentos', 'armazenamento')
     * @param mixed $valorAtual Valor atual atingido
     * @param mixed $valorLimite Valor limite configurado
     * @return void
     */
    public function __construct(Empresa $empresa, $tipoLimite, $valorAtual, $valorLimite)
    {
        $this->empresa = $empresa;
        $this->tipoLimite = $tipoLimite;
        $this->valorAtual = $valorAtual;
        $this->valorLimite = $valorLimite;
    }
} 