<div class="modal fade modal-action-pos" id="buscar_comanda" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="buscarComandaLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="buscarComandaLabel">Buscar Comanda/Mesa</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <label for="numeroComanda" class="form-label">Número da Mesa/Comanda</label>
                        <input type="number" class="form-control" id="numeroComanda" placeholder="Digite o número da mesa/comanda" min="1">
                        <div class="invalid-feedback" id="numeroComandaError"></div>
                    </div>
                </div>
                <div class="row mt-3" id="infoComanda" style="display: none;">
                    <div class="col-md-12">
                        <div class="alert alert-info">
                            <strong>Mesa/Comanda encontrada:</strong>
                            <div id="detalhesComanda"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="btnBuscarComanda">Buscar</button>
                <button type="button" class="btn btn-success" id="btnCarregarComanda" style="display: none;">Carregar no PDV</button>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Event listener para o botão de buscar comanda
    $(document).on('click', '#btnBuscarComanda', function() {
        buscarComanda();
    });

    // Event listener para Enter no campo de número da comanda
    $(document).on('keypress', '#numeroComanda', function(e) {
        if (e.which === 13) { // Enter
            e.preventDefault();
            buscarComanda();
        }
    });

    // Event listener para carregar comanda no PDV (remove listeners anteriores para evitar duplicação)
    $(document).off('click', '#btnCarregarComanda').on('click', '#btnCarregarComanda', function() {
        carregarComandaNoPDV();
    });

    // Limpar modal ao fechar
    $('#buscar_comanda').on('hidden.bs.modal', function() {
        $('#numeroComanda').val('').removeClass('is-invalid');
        $('#numeroComandaError').text('');
        $('#infoComanda').hide();
        $('#btnCarregarComanda').hide();
        $('#btnBuscarComanda').show();
    });
});

// Função para buscar comanda/mesa
function buscarComanda() {
    const numeroComanda = $('#numeroComanda').val();
    
    if (!numeroComanda) {
        $('#numeroComanda').addClass('is-invalid');
        $('#numeroComandaError').text('Por favor, informe o número da mesa/comanda.');
        return;
    }

    $('#numeroComanda').removeClass('is-invalid');
    $('#numeroComandaError').text('');
    $('#btnBuscarComanda').prop('disabled', true).text('Buscando...');

    $.ajax({
        url: '/api/buscar-comanda',
        method: 'POST',
        data: {
            numero: numeroComanda,
            empresa_id: $('#empresa_id').val(),
            _token: $('meta[name="csrf-token"]').attr('content')
        },
        success: function(response) {
            if (response.success) {
                const comanda = response.data;
                let detalhes = `
                    <strong>Número:</strong> ${comanda.numero}<br>
                    <strong>Cliente:</strong> ${comanda.nome_cliente || 'Não informado'}<br>
                    <strong>Status:</strong> ${comanda.status}<br>
                    <strong>Valor Total:</strong> R$ ${comanda.valor_total}<br>
                    <strong>Itens:</strong> ${comanda.itens.length} item(ns)
                `;
                
                $('#detalhesComanda').html(detalhes);
                $('#infoComanda').show();
                $('#btnBuscarComanda').hide();
                $('#btnCarregarComanda').show();
                
                // Armazenar dados da comanda para carregamento posterior
                window.comandaEncontrada = comanda;
            } else {
                $('#numeroComanda').addClass('is-invalid');
                $('#numeroComandaError').text(response.message || 'Mesa/Comanda não encontrada ou não está em aberto.');
            }
        },
        error: function(xhr) {
            let errorMessage = 'Erro ao buscar mesa/comanda.';
            if (xhr.responseJSON && xhr.responseJSON.message) {
                errorMessage = xhr.responseJSON.message;
            }
            $('#numeroComanda').addClass('is-invalid');
            $('#numeroComandaError').text(errorMessage);
        },
        complete: function() {
            $('#btnBuscarComanda').prop('disabled', false).text('Buscar');
        }
    });
}

// Flag para evitar múltiplas execuções
let carregandoComanda = false;

// Função para carregar comanda no PDV
function carregarComandaNoPDV() {
    if (carregandoComanda) {
        return; // Evita execução múltipla
    }
    
    if (!window.comandaEncontrada) {
        swal('Erro', 'Nenhuma comanda foi encontrada para carregar.', 'error');
        return;
    }

    carregandoComanda = true;
    const comanda = window.comandaEncontrada;
    
    // Limpar carrinho atual
    limparCarrinho();
    
    // Definir cliente se houver
    if (comanda.nome_cliente) {
        $('#cliente_nome').val(comanda.nome_cliente);
    }
    
    // Fechar modal primeiro
    $('#buscar_comanda').modal('hide');
    
    // Agrupar itens por produto_id para evitar duplicação
    let itensAgrupados = {};
    comanda.itens.forEach(function(item) {
        let chave = item.produto_id + '_' + (item.variacao_id || 'null');
        if (itensAgrupados[chave]) {
            // Se já existe, somar a quantidade
            itensAgrupados[chave].quantidade = parseFloat(itensAgrupados[chave].quantidade) + parseFloat(item.quantidade);
        } else {
            // Se não existe, adicionar novo
            itensAgrupados[chave] = {
                produto_id: item.produto_id,
                produto_nome: item.produto_nome,
                quantidade: parseFloat(item.quantidade),
                valor_unitario: item.valor_unitario,
                variacao_id: item.variacao_id
            };
        }
    });
    
    // Carregar itens agrupados no PDV
    Object.values(itensAgrupados).forEach(function(item) {
        const produto = {
            id: item.produto_id,
            nome: item.produto_nome,
            valor_unitario: item.valor_unitario,
            codigo_variacao: item.variacao_id || null
        };
        adicionarProdutoDiretamente(produto, item.quantidade);
    });
    
    // Armazenar ID da comanda para atualização posterior
    $('#mesa_comanda_id').val(comanda.id);
    
    // Recalcular totais após um pequeno delay
    setTimeout(function() {
        calcularTotal();
    }, 500);
    
    swal('Sucesso', `Mesa/Comanda ${comanda.numero} carregada com sucesso!`, 'success');
    
    // Reset da flag após conclusão
    carregandoComanda = false;
}

// Função para abrir modal de busca de comanda (chamada pelo botão)
function abrirBuscaComanda() {
    $('#buscar_comanda').modal('show');
}
</script>