@extends('layouts.app', ['title' => 'Registro de Contagem Manual'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="col-md-12">
                    <h4 class="mb-3">Registro de Contagem Manual - Inventário #{{ $inventario->numero_sequencial }}</h4>
                    <p class="text-muted">
                        Registre as quantidades contadas para cada produto do inventário. 
                        Preencha apenas os produtos que foram contados fisicamente.
                    </p>
                </div>
                <hr class="mt-3">
                
                @if(session('flash_success'))
                <div class="alert alert-success">
                    {{ session('flash_success') }}
                </div>
                @endif
                
                @if(session('flash_error'))
                <div class="alert alert-danger">
                    {{ session('flash_error') }}
                </div>
                @endif

                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="card bg-light">
                            <div class="card-body">
                                <h5><i class="ri-information-line text-primary"></i> Informações do Inventário</h5>
                                <div class="mt-3">
                                    <p><strong>Referência:</strong> {{ $inventario->referencia }}</p>
                                    <p><strong>Tipo:</strong> {{ \App\Models\Inventario::tipos()[$inventario->tipo] ?? 'Não definido' }}</p>
                                    <p><strong>Data de Início:</strong> {{ \Carbon\Carbon::parse($inventario->inicio)->format('d/m/Y') }}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card border-info">
                            <div class="card-body">
                                <h5><i class="ri-information-line text-info"></i> Informações</h5>
                                <p class="mt-3">
                                    @if(isset($vindo_da_comparacao) && $vindo_da_comparacao)
                                    Você está visualizando apenas os itens selecionados na tela de comparação.
                                    Realize os ajustes necessários e clique em "Salvar Contagem" para atualizar as quantidades.
                                    @else
                                    Registre as quantidades contadas para cada produto. Os ajustes no estoque serão realizados
                                    posteriormente na tela de análise e comparação.
                                    @endif
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6">
                        <h5>Produtos no Inventário: {{ $itens->total() }}</h5>
                    </div>
                    <div class="col-md-6 text-end">
                        <a href="{{ route('processo-inventario.opcoes', $inventario->id) }}" class="btn btn-secondary">
                            <i class="ri-arrow-left-line"></i> Voltar
                        </a>
                    </div>
                </div>

                <form action="{{ route('processo-inventario.manual', $inventario->id) }}" method="GET" class="mb-3">
                    <div class="row">
                        <div class="col-md-4">
                            <input type="text" class="form-control" name="busca" placeholder="Buscar por nome ou código" 
                                   value="{{ request()->busca }}">
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" name="order_by">
                                <option value="produtos.nome" {{ request()->order_by == 'produtos.nome' || !request()->order_by ? 'selected' : '' }}>Ordenar por Nome</option>
                                <option value="produtos.id" {{ request()->order_by == 'produtos.id' ? 'selected' : '' }}>Ordenar por ID</option>
                                <option value="produtos.codigo_barras" {{ request()->order_by == 'produtos.codigo_barras' ? 'selected' : '' }}>Ordenar por Código de Barras</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" name="order_dir">
                                <option value="asc" {{ request()->order_dir == 'asc' || !request()->order_dir ? 'selected' : '' }}>Crescente</option>
                                <option value="desc" {{ request()->order_dir == 'desc' ? 'selected' : '' }}>Decrescente</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <button type="submit" class="btn btn-primary w-100">
                                <i class="ri-search-line"></i> Aplicar
                            </button>
                        </div>
                    </div>
                </form>
                
                <form action="{{ route('processo-inventario.salvar-manual', $inventario->id) }}" method="POST">
                    @csrf
                    @if(isset($vindo_da_comparacao) && $vindo_da_comparacao)
                    <input type="hidden" name="vindo_da_comparacao" value="1">
                    @endif
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Código de Barras</th>
                                    <th>Produto</th>
                                    <th>Quantidade Contada</th>
                                    <th>Observação</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($itens as $item)
                                <tr class="{{ !is_null($item->quantidade) ? 'produto-contado' : '' }}">
                                    <td>{{ $item->produto->id }}</td>
                                    <td>{{ $item->produto->codigo_barras }}</td>
                                    <td>{{ $item->produto->nome }}</td>
                                    <td>
                                        <input type="hidden" name="item_id[]" value="{{ $item->id }}">
                                        <input type="number" min="0" step="0.01" name="quantidade[]" class="form-control quantidade" 
                                               value="{{ old('quantidade.'.$loop->index, $item->quantidade) }}">
                                    </td>
                                    <td>
                                        <input type="text" name="observacao[]" class="form-control" 
                                               value="{{ old('observacao.'.$loop->index, $item->observacao) }}" placeholder="Observação">
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-3">
                        {{ $itens->appends(request()->except('page'))->links() }}
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <button type="submit" class="btn btn-primary">
                                <i class="ri-save-line"></i> Salvar Contagem
                            </button>
                            @if(isset($vindo_da_comparacao) && $vindo_da_comparacao)
                            <a href="{{ route('processo-inventario.comparar', $inventario->id) }}" class="btn btn-secondary">
                                <i class="ri-arrow-left-line"></i> Voltar para Comparação
                            </a>
                            @else
                            <a href="{{ route('processo-inventario.opcoes', $inventario->id) }}" class="btn btn-secondary">
                                <i class="ri-arrow-left-line"></i> Voltar para Opções
                            </a>
                            @endif
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
    $(document).ready(function() {
        // Formata o campo de quantidade como número
        $('.quantidade').inputmask('numeric', {
            rightAlign: false,
            digits: 2,
            allowMinus: false
        });
        
        // Navegação vertical para campos de quantidade
        $('input[name="quantidade[]"]').keydown(function(e) {
            if (e.which === 13 || e.which === 9) { // Enter ou Tab
                e.preventDefault();
                
                // Encontra o próximo campo de quantidade
                var $allInputs = $('input[name="quantidade[]"]');
                var index = $allInputs.index(this);
                
                if (index < $allInputs.length - 1) {
                    // Move para o próximo campo na mesma coluna
                    $allInputs.eq(index + 1).focus().select();
                } else if (e.which === 9) { // Se for Tab no último campo
                    // Move para o primeiro campo de observação
                    $('input[name="observacao[]"]:first').focus().select();
                }
            }
        });
        
        // Navegação vertical para campos de observação
        $('input[name="observacao[]"]').keydown(function(e) {
            if (e.which === 13 || e.which === 9) { // Enter ou Tab
                e.preventDefault();
                
                // Encontra o próximo campo de observação
                var $allInputs = $('input[name="observacao[]"]');
                var index = $allInputs.index(this);
                
                if (index < $allInputs.length - 1) {
                    // Move para o próximo campo na mesma coluna
                    $allInputs.eq(index + 1).focus().select();
                } else if (e.which === 9) { // Se for Tab no último campo
                    // Move para o checkbox de ajustar estoque
                    $('#ajustar_estoque').focus();
                }
            }
        });
        
        // Inicializa o foco no primeiro campo de quantidade
        setTimeout(function() {
            $('input[name="quantidade[]"]:first').focus().select();
        }, 500);
    });
</script>
@endsection

@section('css')
<style>
    .table-success {
        background-color: #d1e7dd !important;
    }
    .table-info {
        background-color: #cff4fc !important;
    }
    .produto-contado {
        background-color: #f8f9fa !important;
    }
    
    .produto-contado td {
        text-decoration: none;
        color: #6c757d;
    }
</style>
@endsection 