@extends('layouts.app', ['title' => 'Itens Importados - Inventário'])
@section('content')
<div class="mt-3">
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h4>Produtos Importados - Inventário #{{ $inventario->numero_sequencial }}</h4>
                    <div>
                        <a href="{{ route('processo-inventario.comparar', $inventario->id) }}" class="btn btn-primary">
                            <i class="ri-bar-chart-line"></i> Ir para Conferência
                        </a>
                        <a href="{{ route('processo-inventario.opcoes', $inventario->id) }}" class="btn btn-secondary">
                            <i class="ri-arrow-left-line"></i> Voltar para Opções
                        </a>
                    </div>
                </div>
                
                @if(session('flash_success'))
                <div class="alert alert-success">
                    {{ session('flash_success') }}
                </div>
                @endif
                
                @if(session('flash_error'))
                <div class="alert alert-danger">
                    {{ session('flash_error') }}
                </div>
                @endif
                
                @if(session('erros_importacao'))
                <div class="alert alert-warning">
                    <h5>Detalhes dos erros de importação:</h5>
                    <ul>
                        @foreach(session('erros_importacao') as $erro)
                        <li>{{ $erro }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                
                <div class="alert alert-info">
                    <i class="ri-information-line"></i> <strong>Total de produtos importados:</strong> {{ $total }}
                    <p class="mb-0 mt-1">Para fazer ajustes nas quantidades ou outras alterações, utilize a tela de <a href="{{ route('processo-inventario.comparar', $inventario->id) }}" class="alert-link">Conferência</a>.</p>
                </div>

                <div class="table-responsive mt-4">
                    <table class="table table-striped table-bordered table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th class="text-center" width="5%">#</th>
                                <th width="10%">Cód. Barras</th>
                                <th>Produto</th>
                                <th class="text-center" width="15%">Qtd Contada</th>
                                <th class="text-center" width="15%">Estoque Atual</th>
                                <th class="text-center" width="15%">Diferença</th>
                                <th>Observação</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if($itens->count() > 0)
                                @foreach($itens as $item)
                                    @php
                                        $estoque_atual = $item->produto->estoque ? $item->produto->estoque->quantidade : 0;
                                        $diferenca = $item->quantidade - $estoque_atual;
                                        $classe_diferenca = $diferenca == 0 ? 'success' : ($diferenca > 0 ? 'warning' : 'danger');
                                    @endphp
                                    <tr>
                                        <td class="text-center">{{ $loop->iteration }}</td>
                                        <td class="text-muted">{{ $item->produto->codigo_barras }}</td>
                                        <td>
                                            <strong>{{ $item->produto->nome }}</strong>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-primary">{{ number_format($item->quantidade, 2, ',', '.') }}</span>
                                        </td>
                                        <td class="text-center">
                                            {{ number_format($estoque_atual, 2, ',', '.') }}
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-{{ $classe_diferenca }}">
                                                {{ number_format($diferenca, 2, ',', '.') }}
                                            </span>
                                        </td>
                                        <td>{{ $item->observacao }}</td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="7" class="text-center">Nenhum produto importado com quantidade.</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                
                <div class="mt-3">
                    <div class="card border-info">
                        <div class="card-header bg-info text-white">
                            <h5 class="mb-0">Próximos passos</h5>
                        </div>
                        <div class="card-body">
                            <ol>
                                <li>Verifique se todos os produtos foram importados corretamente.</li>
                                <li>Clique em <strong>Ir para Conferência</strong> para visualizar e analisar as divergências de estoque.</li>
                                <li>Na tela de conferência, você poderá ajustar individualmente os produtos ou finalizar o inventário.</li>
                            </ol>
                        </div>
                    </div>
                </div>
                
                <div class="d-flex justify-content-end mt-4">
                    <a href="{{ route('processo-inventario.comparar', $inventario->id) }}" class="btn btn-primary">
                        <i class="ri-bar-chart-line"></i> Ir para Conferência
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 