<div class="row">
    <div class="col-md-4">
        {!!Form::select('produto_id', 'Produto')
        ->attrs(['class' => 'form-select'])->required()
        ->options(isset($item) ? [$item->produto->id => $item->produto->nome] : [])
        ->disabled(isset($item) ? true : false)
        ->id('inp-produto_id')
        !!}
    </div>

    @if(isset($item) && __countLocalAtivo() > 1)
    <div class="row">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>Local</th>
                        <th>Quantidade</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($locais as $l)
                    <tr>
                        <td>
                            @if($l->local)
                            <input type="hidden" readonly class="form-control" required name="local_id[]" value="{{ $l->local_id }}">
                            <input readonly class="form-control" required value="{{ $l->local->descricao }}">
                            @else
                            <input type="hidden" readonly class="form-control" required name="local_id[]" value="{{ $firstLocation->id }}">
                            <input readonly class="form-control" required value="{{ $firstLocation->nome }}">
                            <input type="hidden" name="novo_estoque" value="1">
                            @endif
                        </td>
                        <td>
                            <input class="form-control @if($item->produto->unidadeDecimal()) quantidade @endif" @if(!$item->produto->unidadeDecimal()) value="{{ number_format($l->quantidade, 0) }}" @else value="{{ number_format($l->quantidade, 3) }}" @endif required name="quantidade[]" @if(!$item->produto->unidadeDecimal()) data-mask="000000" @endif>
                        </td>
                    </tr>

                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    @else
    <!-- Informações do Produto Selecionado -->
    <div class="col-md-12 mb-3" id="produto-info" style="display: none;">
        <div class="card border-info">
            <div class="card-header bg-info text-white">
                <h6 class="mb-0"><i class="ri-information-line"></i> Informações do Produto</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <strong class="fs-5">Estoque Atual:</strong>
                        <div class="mt-2">
                            <span id="estoque-atual" class="badge bg-primary display-4 fw-bold">0</span>
                            <span id="produto-unidade" class="text-muted ms-2 fs-6">-</span>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <strong class="fs-5">Categoria:</strong>
                        <div class="mt-2">
                            <span id="produto-categoria" class="text-muted fs-6">-</span>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <strong class="fs-5">Status:</strong>
                        <div class="mt-2">
                            <span id="estoque-status" class="badge bg-success display-6 fw-bold">Disponível</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Tipo de Movimentação -->
    <div class="col-md-3">
        <label for="tipo_movimentacao" class="form-label">Tipo de Movimentação</label>
        <select class="form-select" id="tipo_movimentacao" name="tipo_movimentacao" required>
            <option value="">Selecione</option>
            <option value="entrada" class="text-success">➕ Entrada (Adicionar)</option>
            <option value="saida" class="text-danger">➖ Saída (Remover)</option>
        </select>
    </div>

    <div class="col-md-3">
        {!!Form::text('quantidade', 'Quantidade')
        ->attrs(['class' => 'quantidade'])
        ->required()
        ->value(isset($item) ? ((!$item->produto->unidadeDecimal()) ? number_format($item->quantidade, 0, ',', '.') : number_format($item->quantidade, 3, ',', '.')) : '')
        !!}
    </div>

    @if(__countLocalAtivo() > 1)
    <div class="col-md-3">
        <label for="">Local</label>
        <select required class="select2" data-toggle="select2" name="local_id" id="local_id">
            <option value="">Selecione</option>
            @foreach(__getLocaisAtivoUsuario() as $local)
            <option @isset($item) @if($item->local_id == $local->id) selected @endif @endif value="{{ $local->id }}">{{ $local->descricao }}</option>
            @endforeach
        </select>
    </div>
    @endif
    @endif

    <input name="produto_variacao_id" id="produto_variacao_id" type="hidden">
    <hr class="mt-4">
    <div class="col-12" style="text-align: right;">
        <button type="submit" class="btn btn-success px-5" id="btn-store">Salvar</button>
    </div>
</div>
@include('modals._variacao')