@extends('layouts.app', ['title' => 'Receber contas selecionadas'])
@section('content')
<div class="page-content">
    <div class="card border-top border-0 border-4 border-primary">
        <div class="card-body p-5">
            <div class="page-breadcrumb d-sm-flex align-items-center mb-3">
                <div class="ms-auto">
                    <a href="{{ route('conta-receber.index')}}" type="button" class="btn btn-danger btn-sm">
                        <i class="ri-arrow-left-double-fill"></i>Voltar
                    </a>
                </div>
            </div>
            <div class="card-title d-flex align-items-center">
                <h4 class="mb-0 text-primary">Receber contas selecionadas</h4>
            </div>
            <hr>
            
            <form id="form-receber-contas" method="POST" action="{{ route('conta-receber.recebe-select') }}">
                @csrf
            
            <div class="pl-lg-4">
                <div class="card mb-4">
                    <div class="card-header bg-light">
                        <h5 class="mb-0">Contas Selecionadas</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>Cliente</th>
                                        <th>Referência</th>
                                        <th>Vencimento</th>
                                        <th class="text-right">Valor Pendente</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @php $total = 0; @endphp
                                    @foreach($contas as $conta)
                                    <tr>
                                        <td>{{ $conta->cliente->razao_social ?? 'N/A' }}</td>
                                        <td>{{ $conta->referencia ?? '--' }}</td>
                                        <td>{{ __data_pt($conta->data_vencimento, false) }}</td>
                                        <td class="text-right">R$ {{ __moeda($conta->valorPendente()) }}</td>
                                    </tr>
                                    <input type="hidden" name="item_recebe_paga[]" value="{{ $conta->id }}">
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th colspan="3" class="text-right">Total:</th>
                                        <th class="text-right">R$ {{ __moeda($valorTotalPendente) }}</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
                
                <div class="card">
                    <div class="card-header bg-primary text-white">
                        <h5 class="mb-0">Formas de Pagamento</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8">
                                <!-- Card: Adicionar Forma de Pagamento -->
                                <div class="card mb-3">
                                    <div class="card-header bg-light">
                                        <h6 class="mb-0 font-weight-bold text-primary">Adicionar Forma de Pagamento</h6>
                    </div>
                    <div class="card-body">
                        <div class="row g-2">
                                            <div class="col-md-4">
                                                <label class="form-label">Tipo de Pagamento</label>
                                                <select id="tipo_pagamento_atual" class="form-select">
                                                    <option value="">Selecione</option>
                                                    @foreach($tiposPagamento as $key => $tipo)
                                                        <option value="{{ $key }}">{{ $tipo }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                            <div class="col-md-3">
                                                <label class="form-label">Valor</label>
                                                <input type="text" id="valor_pagamento_atual" class="form-control moeda" placeholder="0,00">
                            </div>
                            <div class="col-md-3">
                                                <label class="form-label">Observação</label>
                                                <input type="text" id="observacao_pagamento_atual" class="form-control" placeholder="Opcional">
                                            </div>
                                            <div class="col-md-2 d-flex align-items-end">
                                                <button type="button" id="adicionar-pagamento" class="btn btn-success">
                                                    <i class="ri-add-line"></i> Adicionar
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                            </div>

                                <!-- Card: Pagamentos Registrados -->
                                <div class="card">
                                    <div class="card-header bg-light">
                                        <h6 class="mb-0 font-weight-bold text-primary">Pagamentos Registrados</h6>
                                    </div>
                                    <div class="card-body">
                                        <div id="mensagem-pagamento" class="text-center my-2"></div>
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped" id="tabela-pagamentos">
                                                <thead>
                                                    <tr>
                                                        <th>Tipo de Pagamento</th>
                                                        <th>Valor</th>
                                                        <th>Observação</th>
                                                        <th class="text-center" width="80">Ações</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="lista-pagamentos">
                                                    <!-- Os pagamentos serão adicionados dinamicamente via JavaScript -->
                                                </tbody>
                                                <tfoot>
                                                    <tr>
                                                        <th colspan="1" class="text-right">Total:</th>
                                                        <th class="text-right" id="total-pagamentos">R$ 0,00</th>
                                                        <th colspan="2"></th>
                                                    </tr>
                                                    <tr>
                                                        <th colspan="1" class="text-right">Valor Pendente:</th>
                                                        <th class="text-right valor-pendente">R$ {{ __moeda($valorTotalPendente) }}</th>
                                                        <th colspan="2"></th>
                                                    </tr>
                                                    <tr>
                                                        <th colspan="1" class="text-right">Valor Restante:</th>
                                                        <th class="text-right valor-restante text-danger">R$ {{ __moeda($valorTotalPendente) }}</th>
                                                        <th colspan="2"></th>
                                                    </tr>
                                                    <tr>
                                                        <th colspan="1" class="text-right">Valor Troco:</th>
                                                        <th class="text-right valor-troco text-danger">R$ 0,00</th>
                                                        <th colspan="2"></th>
                                                    </tr>
                                                </tfoot>
                                            </table>
                                        </div>
                                        <div class="alert alert-info mt-3 py-2 d-none" id="sem-pagamentos">
                                            <i class="ri-information-line"></i> Nenhum pagamento registrado. Adicione pelo menos uma forma de pagamento.
                                        </div>
                                    </div>
                            </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="card mb-3">
                                    <div class="card-header bg-light">
                                        <h6 class="mb-0 font-weight-bold text-primary">Informações do Recebimento</h6>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-3 div-conta-empresa">
                                            <label class="form-label">Conta Empresa</label>
                                            {!!Form::select('conta_empresa_id', 'Conta Empresa')->required()!!}
                                        </div>
                                        
                                        <!-- Campo de Data do Recebimento como hidden input -->
                                        <input type="hidden" name="data_recebimento" id="data_recebimento" value="{{ date('Y-m-d') }}">
                                        
                                        <div id="dados-pagamento-parcial" class="mb-3" style="display: none;">
                                            <div class="alert alert-warning py-2">
                                                    <i class="ri-information-line me-2"></i>
                                                <strong>Pagamento Parcial</strong>
                                                <p class="mb-0">O valor é inferior ao total das contas.</p>
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Nova data de vencimento</label>
                                                <input type="date" name="data_nova_vencimento" id="data_nova_vencimento" class="form-control" value="{{ date('Y-m-d', strtotime('+30 days')) }}">
                                                <small class="form-text text-muted">Data para o saldo restante</small>
                                            </div>
                                            <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" id="pagamento_parcial" name="pagamento_parcial" value="1">
                                                    <label class="form-check-label" for="pagamento_parcial">
                                                        Confirmo o pagamento parcial
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                
                                <div class="d-grid gap-2">
                                    <input type="hidden" name="valor_pago" id="valor_pago" value="0">
                                    <input type="hidden" name="redirect_to_pdv" value="0"> // 0 - PARA O LISTA DE CPAGAR  1 -  REDIRECIONA PARA O PDV 
                                    <button type="button" id="btn-confirmar-recebimento" class="btn btn-success btn-lg">
                                        <i class="ri-checkbox-circle-line me-1"></i> Confirmar Recebimento
                                    </button>
                                    <!-- Botão de submit oculto que pode ser acionado via JavaScript -->
                                    <button type="submit" id="btn-submit-form" class="d-none">Submit</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal de Confirmação -->
<div class="modal fade" id="modal-confirma-recebimento" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">Confirmação de Recebimento</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Tem certeza que deseja finalizar o recebimento destas contas?</p>
                <div class="alert alert-info">
                    <i class="ri-information-line me-2"></i>
                    <p class="mb-0">Ao confirmar, os pagamentos serão registrados e as contas serão baixadas no sistema.</p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                <button type="button" id="btn-confirmar-modal" class="btn btn-success">Confirmar</button>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script type="text/javascript" src="/js/controla_conta_empresa.js"></script>
<script>
    $(document).ready(function() {
        console.log("Inicializando JavaScript da tela de recebimentos múltiplos");
        
        // Melhor verificação do formulário com mensagem de erro mais clara
        const form = document.getElementById('form-receber-contas');
        if (!form) {
            console.error("ERRO CRÍTICO: Formulário 'form-receber-contas' não encontrado na página!");
        } else {
            console.log("Formulário encontrado com sucesso:", form);
        }
        
        // Valor total pendente
        const valorTotalPendente = parseFloat('{{ $valorTotalPendente }}');
        
        // Array para armazenar os pagamentos
        let pagamentos = [];
        
        // Verifica se tem pagamentos
        function verificaPagamentos() {
            if (pagamentos.length === 0) {
                $('#sem-pagamentos').removeClass('d-none');
                $('#mensagem-pagamento').html('');
            } else {
                $('#sem-pagamentos').addClass('d-none');
            }
        }
        
        // Inicialização
        verificaPagamentos();
        
        // Adicionar novo pagamento
        $('#adicionar-pagamento').on('click', function() {
            const tipoPagamento = $('#tipo_pagamento_atual').val();
            const valorPagamento = $('#valor_pagamento_atual').val();
            const observacao = $('#observacao_pagamento_atual').val();
            
            // Validações
            if (!tipoPagamento) {
                alert('Selecione o tipo de pagamento');
                $('#tipo_pagamento_atual').focus();
                return;
            }
            
            if (!valorPagamento || converteMoedaFloat(valorPagamento) <= 0) {
                alert('Informe um valor válido para o pagamento');
                $('#valor_pagamento_atual').focus();
                return;
            }
            
            // Adicionar à lista de pagamentos
            const tipoPagamentoTexto = $('#tipo_pagamento_atual option:selected').text();
            const valorFloat = converteMoedaFloat(valorPagamento);
            
            const novoPagamento = {
                tipo: tipoPagamento,
                tipoTexto: tipoPagamentoTexto,
                valor: valorFloat,
                observacao: observacao
            };
            
            pagamentos.push(novoPagamento);
            
            // Limpar campos
            $('#tipo_pagamento_atual').val('');
            $('#valor_pagamento_atual').val('');
            $('#observacao_pagamento_atual').val('');
            $('#tipo_pagamento_atual').focus();
            
            // Atualizar tabela e valores
            atualizarTabelaPagamentos();
            atualizarTotais();
            verificaPagamentos();
        });
        
        // Remover pagamento
        $(document).on('click', '.btn-remover-pagamento', function() {
            const index = $(this).data('index');
            pagamentos.splice(index, 1);
            atualizarTabelaPagamentos();
            atualizarTotais();
            verificaPagamentos();
        });
        
        // Atualizar tabela de pagamentos
        function atualizarTabelaPagamentos() {
            const $tabela = $('#lista-pagamentos');
            $tabela.empty();
            
            pagamentos.forEach(function(pagamento, index) {
                const valorFormatado = formatarMoeda(pagamento.valor);
                
                let html = '<tr>';
                html += '<td>' + pagamento.tipoTexto + '<input type="hidden" name="tipos_pagamento[]" value="' + pagamento.tipo + '"></td>';
                html += '<td>R$ ' + valorFormatado + '<input type="hidden" name="valores_pagamento[]" value="' + pagamento.valor + '"></td>';
                html += '<td>' + (pagamento.observacao || '--') + '<input type="hidden" name="observacoes_pagamento[]" value="' + (pagamento.observacao || '') + '"></td>';
                html += '<td class="text-center">';
                html += '<button type="button" class="btn btn-sm btn-danger btn-remover-pagamento" data-index="' + index + '"><i class="ri-delete-bin-line"></i></button>';
                html += '</td>';
                html += '</tr>';
                
                $tabela.append(html);
            });
        }
        
        // Atualizar totais
        function atualizarTotais() {
            let totalPagamentos = 0;
            
            pagamentos.forEach(function(pagamento) {
                totalPagamentos += pagamento.valor;
            });
            
            // Atualizar total de pagamentos
            $('#total-pagamentos').text('R$ ' + formatarMoeda(totalPagamentos));
            
            // Atualizar valor pago (hidden)
            $('#valor_pago').val(totalPagamentos);
            
            // Calcular valor restante
            const valorRestante = valorTotalPendente - totalPagamentos;
            if (valorRestante >= 0) {
                $('.valor-restante').text('R$ ' + formatarMoeda(valorRestante));
            } else {
                $('.valor-restante').text('R$ 0,00');
            }

            const valorTroco = totalPagamentos - valorTotalPendente;
            if (valorTroco >= 0) {
                $('.valor-troco').text('R$ ' + formatarMoeda(valorTroco));
            } else {
                $('.valor-troco').text('R$ 0,00');
            }   

            // Verificar pagamento parcial
            verificarPagamentoParcial(totalPagamentos, valorRestante);
        }
        
        // Verificar se é pagamento parcial
        function verificarPagamentoParcial(totalPagamentos, valorRestante) {
            // Se não houver pagamentos ainda, esconder campos de pagamento parcial
            if (pagamentos.length === 0) {
                $('#dados-pagamento-parcial').hide();
                $('#pagamento_parcial').prop('required', false);
                return;
            }
            
            // Considerar igual se a diferença for menor que 0.01 (evita problemas de arredondamento)
            if (valorRestante > 0.01) {
                $('#dados-pagamento-parcial').slideDown();
                $('#pagamento_parcial').prop('required', true);
            } else {
                $('#dados-pagamento-parcial').slideUp();
                $('#pagamento_parcial').prop('required', false);
            }
        }
        
        // Mostrar modal de confirmação
        let modal = null;
        try {
            // Tentar inicializar o modal com Bootstrap 5
            modal = new bootstrap.Modal(document.getElementById('modal-confirma-recebimento'));
        } catch (e) {
            console.warn("Erro ao inicializar modal com Bootstrap 5, tentando jQuery:", e);
            // Fallback para jQuery
            try {
                $('#modal-confirma-recebimento').modal({backdrop: 'static', keyboard: false});
                modal = {
                    show: function() { $('#modal-confirma-recebimento').modal('show'); },
                    hide: function() { $('#modal-confirma-recebimento').modal('hide'); }
                };
            } catch (e2) {
                console.error("Não foi possível inicializar o modal:", e2);
            }
        }
        
        // Ao clicar no botão de confirmar recebimento
        $('#btn-confirmar-recebimento').on('click', function() {
            console.log("Botão confirmar recebimento clicado");
            
            // Validações antes de mostrar o modal
            if (pagamentos.length === 0) {
                alert('Adicione pelo menos uma forma de pagamento antes de continuar.');
                return;
            }
            
            // Verificar pagamento parcial
            let totalPagamentos = 0;
            pagamentos.forEach(function(p) { totalPagamentos += p.valor; });
            
            const valorRestante = valorTotalPendente - totalPagamentos;
            
            if (valorRestante > 0.01) {
                // É pagamento parcial
                if (!$('#pagamento_parcial').is(':checked')) {
                    alert('Você precisa confirmar o pagamento parcial antes de continuar.');
                    return;
                }
            }
            
            // Se tudo OK, mostrar o modal de confirmação
            if (modal) {
                modal.show();
            } else {
                // Se não conseguiu inicializar o modal, perguntar diretamente
                if (confirm('Tem certeza que deseja finalizar o recebimento destas contas?')) {
                    submeterFormulario();
                }
            }
        });
        
        // Função para submeter o formulário
        function submeterFormulario() {
            console.log("Tentando submeter o formulário");
            
            try {
                // Obter o formulário - usar querySelector como alternativa se getElementById falhar
                const form = document.getElementById('form-receber-contas') || document.querySelector('form');
                
                if (!form) {
                    console.error("ERRO CRÍTICO: Formulário não encontrado por ID nem por seletor genérico");
                    alert("Erro ao processar o formulário. Por favor, tente novamente ou contate o suporte.");
                    return false;
                }
                
                console.log("Formulário encontrado:", form);
                
                // Garantir que o método seja POST
                form.method = 'POST';
                
                // Verificar se o token CSRF está presente
                let csrfToken = document.querySelector('meta[name="csrf-token"]').content;
                let csrfInput = form.querySelector('input[name="_token"]');
                
                if (!csrfInput) {
                    csrfInput = document.createElement('input');
                    csrfInput.type = 'hidden';
                    csrfInput.name = '_token';
                    csrfInput.value = csrfToken;
                    form.appendChild(csrfInput);
                }
                
                // Adicionar campo oculto para indicar redirecionamento para PDV se não existir
                if (!form.querySelector('input[name="redirect_to_pdv"]')) {
                    let redirectInput = document.createElement('input');
                    redirectInput.type = 'hidden';
                    redirectInput.name = 'redirect_to_pdv';
                    redirectInput.value = '1';
                    form.appendChild(redirectInput);
                }
                
                // Criar FormData com todos os campos do formulário
                const formData = new FormData(form);
                
                // Adicionar todas as linhas de pagamento
                const pagamentoRows = document.querySelectorAll('#tabela-pagamentos tbody tr');
                pagamentoRows.forEach((row, index) => {
                    // CORREÇÃO: Pegar os valores dos inputs hidden que já existem em cada linha
                    const tipo = row.querySelector('input[name="tipos_pagamento[]"]').value;
                    const valor = row.querySelector('input[name="valores_pagamento[]"]').value;
                    const observacao = row.querySelector('input[name="observacoes_pagamento[]"]').value || '';
                    
                    console.log(`Adicionando pagamento ${index}: tipo=${tipo}, valor=${valor}`);
                    
                    // Adicionar ao FormData
                    formData.append(`pagamentos[${index}][tipo]`, tipo);
                    formData.append(`pagamentos[${index}][valor]`, valor);
                    formData.append(`pagamentos[${index}][observacao]`, observacao);
                });
                
                // Verificar se temos pagamentos antes de enviar
                if (pagamentos.length === 0) {
                    alert('É necessário adicionar pelo menos uma forma de pagamento!');
                    return false;
                }
                
                // Verificar se o valor pago foi definido corretamente
                if (parseFloat(document.getElementById('valor_pago').value) <= 0) {
                    console.error("Valor pago não foi definido corretamente");
                    alert('Erro: Valor de pagamento inválido. Por favor, adicione os pagamentos novamente.');
                    return false;
                }
                
                console.log("Enviando formulário com os seguintes dados:", Object.fromEntries(formData));
                
                // Submeter o formulário usando Fetch API
                fetch('{{ route("conta-receber.recebe-select") }}', {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-CSRF-TOKEN': csrfToken
                    },
                    redirect: 'follow'
                })
                .then(response => {
                    console.log("Status da resposta:", response.status);
                    
                    if (!response.ok) {
                        // Se a resposta não for bem-sucedida, lançar um erro para ser capturado pelo catch
                        return response.text().then(text => {
                            throw new Error('Erro no processamento: ' + text);
                        });
                    }
                    
                    if (response.redirected) {
                        console.log("Redirecionando para:", response.url);
                        // Criar um cookie temporário para indicar sucesso
                        document.cookie = "recebimento_finalizado=true; path=/; max-age=30";
                        window.location.href = response.url;
                    } else {
                        return response.text();
                    }
                })
                .then(html => {
                    if (html) {
                        try {
                            // Tentar analisar a resposta como JSON para verificar se há erro
                            const jsonResponse = JSON.parse(html);
                            if (jsonResponse.error) {
                                alert('Erro: ' + jsonResponse.error);
                                console.error('Erro retornado pelo servidor:', jsonResponse.error);
                                return;
                            }
                        } catch (e) {
                            // Se não for JSON, provavelmente é HTML
                        }
                        
                        // Criar um cookie temporário para indicar sucesso
                        document.cookie = "recebimento_finalizado=true; path=/; max-age=30";
                        
                        // Se recebemos HTML em vez de redirecionamento, redirecionar para PDV
                        console.log("Redirecionando para o PDV");
                        window.location.href = '{{ route("frontbox.create") }}';
                    }
                })
                .catch(error => {
                    // Remover overlay de carregamento se existir
                    const overlay = document.getElementById('loading-overlay');
                    if (overlay) overlay.remove();
                    
                    // Reativar o botão de confirmação
                    $('#btn-confirmar-modal').prop('disabled', false).html('Confirmar');
                    
                    console.error('Erro ao submeter formulário:', error);
                    alert('Erro ao processar o recebimento: ' + error.message);
                    
                    // Manter na página atual em caso de erro para que o usuário possa tentar novamente
                    return false;
                });
                
                return true;
            } catch (error) {
                console.error("Erro ao submeter formulário:", error);
                
                // Em caso de erro, redirecionar para o PDV após 2 segundos
                setTimeout(function() {
                    window.location.href = '{{ route("frontbox.create") }}';
                }, 2000);
                
                return false;
            }
        }
        
        // Ao clicar no botão confirmar dentro do modal
        $('#btn-confirmar-modal').on('click', function(e) {
            console.log("Botão confirmar no modal clicado");
            
            // Desabilitar o botão para prevenir múltiplos cliques
            $(this).prop('disabled', true).html('<i class="spinner-border spinner-border-sm"></i> Processando...');
            
            // Exibir overlay de carregamento para indicar que o processamento está acontecendo
            $('body').append('<div id="loading-overlay" style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.7); z-index: 9999; display: flex; justify-content: center; align-items: center;"><div style="background: white; padding: 20px; border-radius: 5px;"><i class="ri-loader-4-line fa-spin" style="font-size: 30px; margin-right: 10px;"></i> Processando pagamento...</div></div>');
            
            // Submeter o formulário diretamente (sem tentar ocultar o modal)
            submeterFormulario();
            
            // Evitar comportamento padrão do botão
            return false;
        });
        
        // Formatar valor de moeda
        function formatarMoeda(valor) {
            return valor.toLocaleString('pt-BR', {minimumFractionDigits: 2, maximumFractionDigits: 2});
        }
        
        // Função para converter string de moeda para float
        function converteMoedaFloat(valor) {
            if (!valor) return 0;
            return parseFloat(valor.replace('.', '').replace(',', '.'));
        }
        
        console.log("JavaScript da tela de recebimentos múltiplos inicializado");
    });
</script>
@endsection 