@extends('layouts.app', ['title' => 'Editar Consignação'])
@section('content')

<div class="container-fluid">
    <div class="row mb-3">
        <div class="col-md-8">
            <h4 class="mb-0">
                <i class="ri-edit-line me-2"></i>
                Editar Consignação <strong>#{{ $consignacao->numero_consignacao }}</strong>
            </h4>
            <div class="small text-muted">
                Criada em: {{ $consignacao->data_consignacao->format('d/m/Y H:i') }} |
                Status: <span class="badge bg-{{ $consignacao->status_color }}">{{ $consignacao->status_text }}</span>
            </div>
        </div>
        <div class="col-md-4 text-end">
            <a href="{{ route('consignacao.show', $consignacao->id) }}" class="btn btn-secondary">
                <i class="ri-arrow-left-line me-1"></i> Voltar
            </a>
        </div>
    </div>

    {!! Form::open()->put()->route('consignacao.update', $consignacao->id)->id('form-edit-consignacao') !!}

    <div class="row mb-3">
        <div class="col-md-4">
            <div class="card">
                <div class="card-header bg-light">
                    <strong>Cliente</strong>
                </div>
                <div class="card-body">
                    <div><strong>{{ $consignacao->cliente->nome }}</strong></div>
                    <div class="text-muted small">{{ $consignacao->cliente->cpf_cnpj }}</div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-header bg-light">
                    <strong>Vendedor</strong>
                </div>
                <div class="card-body">
                    <div><strong>{{ $consignacao->funcionario->nome ?? '--' }}</strong></div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-header bg-light">
                    <strong>Informações</strong>
                </div>
                <div class="card-body">
                    <div><strong>Data de Vencimento:</strong> {{ $consignacao->data_vencimento ? $consignacao->data_vencimento->format('d/m/Y') : '--' }}</div>
                    <div><strong>Valor Total:</strong> <span class="text-success">{{ __moeda($consignacao->valor_total) }}</span></div>
                </div>
            </div>
        </div>
    </div>

    <div class="card mb-3">
        <div class="card-header">
            <strong>Editar Itens da Consignação</strong>
            <small class="text-muted ms-2">(Apenas quantidade devolvida pode ser alterada)</small>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>Produto</th>
                            <th>Qtd. Consignada</th>
                            <th>Qtd. Vendida</th>
                            <th>Qtd. Devolvida</th>
                            <th>Valor Unitário</th>
                            <th>Subtotal</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($consignacao->itens as $index => $item)
                        <tr>
                            <td>
                                <strong>{{ $item->descricao }}</strong>
                                <br>
                                <small class="text-muted">{{ $item->produto->codigo ?? '' }}</small>
                            </td>
                            <td>{{ $item->quantidade }}</td>
                            <td>{{ $item->quantidade_vendida }}</td>
                            <td>
                                <input type="number" 
                                       name="itens[{{ $index }}][quantidade_devolvida]" 
                                       value="{{ $item->quantidade_devolvida }}" 
                                       class="form-control form-control-sm" 
                                       min="0" 
                                       max="{{ $item->quantidade_vendida }}" 
                                       step="0.001"
                                       onchange="calcularSubtotal({{ $index }})">
                                <input type="hidden" name="itens[{{ $index }}][item_id]" value="{{ $item->id }}">
                                <input type="hidden" name="itens[{{ $index }}][produto_id]" value="{{ $item->produto_id }}">
                                <input type="hidden" name="itens[{{ $index }}][produto_variacao_id]" value="{{ $item->produto_variacao_id }}">
                                <input type="hidden" name="itens[{{ $index }}][quantidade]" value="{{ $item->quantidade }}">
                                <input type="hidden" name="itens[{{ $index }}][quantidade_vendida]" value="{{ $item->quantidade_vendida }}">
                                <input type="hidden" name="itens[{{ $index }}][valor_unitario]" value="{{ $item->valor_unitario }}">
                            </td>
                            <td>{{ __moeda($item->valor_unitario) }}</td>
                            <td>
                                <span id="subtotal-{{ $index }}">{{ __moeda($item->sub_total) }}</span>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <strong>Observações</strong>
                </div>
                <div class="card-body">
                    {!! Form::textarea('observacao', 'Observações')->attrs(['rows' => 3])->value($consignacao->observacao) !!}
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <strong>Ações</strong>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <button type="submit" class="btn btn-success btn-lg">
                            <i class="ri-check-line me-2"></i> Salvar Alterações
                        </button>
                        <a href="{{ route('consignacao.show', $consignacao->id) }}" class="btn btn-secondary">
                            <i class="ri-close-line me-2"></i> Cancelar
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {!! Form::close() !!}
</div>

@endsection

@section('js')
<script>
function calcularSubtotal(index) {
    // Esta função pode ser expandida para recalcular subtotais se necessário
    // Por enquanto, apenas valida se a quantidade devolvida não excede a vendida
    const input = document.querySelector(`input[name="itens[${index}][quantidade_devolvida]"]`);
    const quantidadeVendida = parseFloat(document.querySelector(`input[name="itens[${index}][quantidade_vendida]"]`).value);
    const quantidadeDevolvida = parseFloat(input.value);
    
    if (quantidadeDevolvida > quantidadeVendida) {
        alert('A quantidade devolvida não pode ser maior que a quantidade vendida!');
        input.value = quantidadeVendida;
    }
}

// Validação do formulário
$('#form-edit-consignacao').on('submit', function(e) {
    let isValid = true;
    
    // Verificar se todas as quantidades devolvidas são válidas
    $('input[name*="[quantidade_devolvida]"]').each(function() {
        const quantidadeVendida = parseFloat($(this).closest('tr').find('input[name*="[quantidade_vendida]"]').val());
        const quantidadeDevolvida = parseFloat($(this).val());
        
        if (quantidadeDevolvida > quantidadeVendida) {
            alert('A quantidade devolvida não pode ser maior que a quantidade vendida!');
            isValid = false;
            return false;
        }
    });
    
    if (!isValid) {
        e.preventDefault();
    }
});
</script>
@endsection 