<!DOCTYPE html>
<html>
<head>
    <title>Relatório de Caixa</title>
    <style>
        body { font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #222; }
        .header { display: flex; align-items: center; border: 1px solid #ccc; border-radius: 6px; margin-bottom: 10px; padding: 10px; }
        .logo { width: 80px; height: 80px; background: #f5f5f5; border-radius: 6px; display: flex; align-items: center; justify-content: center; margin-right: 20px; }
        .logo img { max-width: 70px; max-height: 70px; }
        .title { flex: 1; text-align: center; font-size: 18px; font-weight: bold; letter-spacing: 1px; }
        .info { margin: 10px 0 15px 0; text-align: center; font-size: 13px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 18px; }
        th, td { border: 1px solid #bbb; padding: 4px 6px; font-size: 12px; }
        th { background: #f5f5f5; font-weight: bold; text-align: center; }
        .section-title { background: #f5f5f5; font-weight: bold; text-align: center; font-size: 14px; border: 1px solid #bbb; border-bottom: none; padding: 6px 0; }
        .saldo-final { font-size: 18px; font-weight: bold; text-align: center; margin-top: 10px; }
        .no-border { border: none !important; }
    </style>
</head>
<body>
    <div class="header">
        <!-- Logo removida -->
        <div class="title">NEXT SISTEMAS</div>
    </div>
    <div class="info">
        Caixa aberto em {{ date('d/m/Y H:i:s', strtotime($item->created_at)) }} como valor de R$ {{ __moeda($item->valor_abertura) }} pelo usuário: {{ $usuario->email ?? $usuario->name ?? '' }}
    </div>

    <!-- Saldo na Abertura do Caixa -->
    <div class="section-title">Saldo na Abertura do Caixa</div>
    <table>
        <thead>
            <tr>
                <th style="text-align: center;">Operador</th>
                <th style="text-align: center;">Forma Pagamento</th>
                <th style="text-align: right;">Saldo</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td style="text-align: center;">{{ $usuario->name }}</td>
                <td style="text-align: center;">Dinheiro</td>
                <td style="text-align: right;">R$ {{ __moeda($item->valor_abertura) }}</td>
            </tr>
        </tbody>
    </table>

    <!-- Vendas Realizadas no PDV -->
    <div class="section-title">Vendas Realizadas no PDV</div>
    <table>
        <thead>
            <tr>
                <th style="text-align: center;">Código</th>
                <th style="text-align: center;">Data</th>
                <th style="text-align: center;">Forma Pagamento</th>
                <th style="text-align: right;">Valor</th>
                <th style="text-align: right;">Saldo</th>
            </tr>
        </thead>
        <tbody>
            @php
                $saldo = $item->valor_abertura;
            @endphp
            @foreach($data as $venda)
                @php
                    $valor = $venda->tipo != 'OS' ? $venda->total : $venda->valor;
                    $forma = $venda->tipo != 'OS' ? (isset($venda->tipo_pagamento) ? App\Models\Nfce::getTipoPagamento($venda->tipo_pagamento) : '-') : (isset($venda->forma_pagamento) ? App\Models\Nfce::getTipoPagamento($venda->forma_pagamento) : '-');
                    $saldo += $valor;
                @endphp
                <tr>
                    <td style="text-align: center;">{{ $venda->id }}</td>
                    <td style="text-align: center;">{{ date('d/m/Y H:i:s', strtotime($venda->created_at)) }}</td>
                    <td style="text-align: center;">{{ $forma }}</td>
                    <td style="text-align: right;">R$ {{ __moeda($valor) }}</td>
                    <td style="text-align: right;">R$ {{ __moeda($saldo) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <!-- Retiradas Realizadas no Caixa -->
    <div class="section-title">Retiradas Realizadas no Caixa</div>
    <table>
        <thead>
            <tr>
                <th style="text-align: center;">Data</th>
                <th style="text-align: center;">Forma Pagamento</th>
                <th style="text-align: center;">Motivo</th>
                <th style="text-align: right;">Valor</th>
                <th style="text-align: right;">Saldo</th>
            </tr>
        </thead>
        <tbody>
            @php
                // Juntar sangrias e contas pagas, ordenando por data
                $retiradas = collect();
                if(isset($sangrias)) {
                    foreach($sangrias as $s) {
                        $retiradas->push([
                            'data' => $s->created_at,
                            'forma' => 'Dinheiro',
                            'motivo' => $s->motivo ?? $s->observacao ?? '',
                            'valor' => $s->valor,
                            'tipo' => 'sangria',
                        ]);
                    }
                }
                if(isset($pagar)) {
                    foreach($pagar as $p) {
                        $retiradas->push([
                            'data' => $p->data_pagamento,
                            'forma' => App\Models\Nfce::getTipoPagamento($p->tipo_pagamento),
                            'motivo' => $p->descricao,
                            'valor' => $p->valor_integral,
                            'tipo' => 'conta',
                        ]);
                    }
                }
                $retiradas = $retiradas->sortBy('data');
                $saldoRetirada = $saldo;
            @endphp
            @forelse($retiradas as $r)
                @php
                    $saldoRetirada -= $r['valor'];
                @endphp
                <tr>
                    <td style="text-align: center;">{{ date('d/m/Y H:i:s', strtotime($r['data'])) }}</td>
                    <td style="text-align: center;">{{ $r['forma'] }}</td>
                    <td style="text-align: center;">{{ $r['motivo'] }}</td>
                    <td style="text-align: right;">R$ {{ __moeda($r['valor']) }}</td>
                    <td style="text-align: right;">R$ {{ __moeda($saldoRetirada) }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" style="text-align:center;">Nenhuma retirada registrada neste caixa.</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <!-- Devoluções Realizadas no Caixa -->
    <div class="section-title">Devoluções Realizadas no Caixa</div>
    <table>
        <thead>
            <tr>
                <th style="text-align: center;">Código</th>
                <th style="text-align: center;">Data</th>
                <th style="text-align: center;">Forma Pagamento</th>
                <th style="text-align: right;">Valor</th>
                <th style="text-align: right;">Saldo</th>
            </tr>
        </thead>
        <tbody>
            @php
                // Juntar devoluções e vendas canceladas
                $devolucoesECanceladas = collect();
                foreach($devolucoes as $dev) {
                    $devolucoesECanceladas->push([
                        'codigo' => $dev->venda_id,
                        'data' => $dev->data_devolucao ?? $dev->created_at,
                        'forma' => App\Models\Nfce::getTipoPagamento($dev->tipo_pagamento),
                        'valor' => $dev->valor_total,
                        'tipo' => 'devolucao'
                    ]);
                }
                foreach($data as $venda) {
                    if(isset($venda->estado) && $venda->estado == 'cancelado') {
                        $devolucoesECanceladas->push([
                            'codigo' => $venda->id,
                            'data' => $venda->created_at,
                            'forma' => isset($venda->tipo_pagamento) ? App\Models\Nfce::getTipoPagamento($venda->tipo_pagamento) : '-',
                            'valor' => $venda->total,
                            'tipo' => 'cancelada'
                        ]);
                    }
                }
                $devolucoesECanceladas = $devolucoesECanceladas->sortBy('data');
                $saldoDevolucao = $saldoRetirada;
            @endphp
            @foreach($devolucoesECanceladas as $item)
                @php $saldoDevolucao -= $item['valor']; @endphp
                <tr>
                    <td style="text-align: center;">{{ $item['codigo'] }}</td>
                    <td style="text-align: center;">{{ date('d/m/Y H:i:s', strtotime($item['data'])) }}</td>
                    <td style="text-align: center;">{{ $item['forma'] }}</td>
                    <td style="text-align: right;">R$ {{ __moeda($item['valor']) }}</td>
                    <td style="text-align: right;">R$ {{ __moeda($saldoDevolucao) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <!-- Resumo de vendas por forma de pagamento (em tabela) -->
    <div class="section-title">Resumo de Vendas por Forma de Pagamento</div>
    <table>
        <thead>
            <tr>
                <th style="text-align: center;">Forma de Pagamento</th>
                <th style="text-align: right;">Valor Total</th>
            </tr>
        </thead>
        <tbody>
            @php
                $totaisPorForma = [];
                foreach($data as $venda) {
                    if(isset($venda->estado) && $venda->estado == 'cancelado') continue;
                    // Para OS
                    if($venda->tipo == 'OS') {
                        $forma = isset($venda->forma_pagamento) ? App\Models\Nfce::getTipoPagamento($venda->forma_pagamento) : '-';
                        if(!isset($totaisPorForma[$forma])) $totaisPorForma[$forma] = 0;
                        $totaisPorForma[$forma] += $venda->valor;
                    } else {
                        // Para NFCe/NFe, pode ter múltiplas faturas
                        $faturas = $venda->fatura ?? \App\Models\FaturaNfce::where('nfce_id', $venda->id)->get();
                        if($faturas && count($faturas) > 0) {
                            foreach($faturas as $f) {
                                $forma = App\Models\Nfce::getTipoPagamento($f->tipo_pagamento);
                                if(!isset($totaisPorForma[$forma])) $totaisPorForma[$forma] = 0;
                                $totaisPorForma[$forma] += $f->valor;
                            }
                        } else {
                            $forma = isset($venda->tipo_pagamento) ? App\Models\Nfce::getTipoPagamento($venda->tipo_pagamento) : '-';
                            if(!isset($totaisPorForma[$forma])) $totaisPorForma[$forma] = 0;
                            $totaisPorForma[$forma] += $venda->total;
                        }
                    }
                }
            @endphp
            @foreach($totaisPorForma as $forma => $valor)
                <tr>
                    <td style="text-align: center;">{{ strtoupper($forma) }}</td>
                    <td style="text-align: right;">R$ {{ __moeda($valor) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <!-- Saldo Atual do Caixa -->
    <div class="section-title">Saldo Atual do Caixa</div>
    <div class="saldo-final">
        R$ {{ __moeda($saldoDevolucao) }}
    </div>
</body>
</html>
