<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Garantir que a tabela existe
        if (!Schema::hasTable('devolucoes')) {
            return;
        }

        // Se a coluna antiga existir, migrar dados para a nova e remover a antiga
        if (Schema::hasColumn('devolucoes', 'observacoes')) {
            // Se a coluna nova não existir por algum motivo, cria-la
            Schema::table('devolucoes', function (Blueprint $table) {
                if (!Schema::hasColumn('devolucoes', 'observacao')) {
                    $table->text('observacao')->nullable()->after('tipo_pagamento');
                }
            });

            // Copiar dados de observacoes -> observacao quando observacao estiver nula
            DB::statement("UPDATE devolucoes SET observacao = COALESCE(observacao, observacoes)");

            // Remover coluna antiga
            Schema::table('devolucoes', function (Blueprint $table) {
                if (Schema::hasColumn('devolucoes', 'observacoes')) {
                    $table->dropColumn('observacoes');
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (!Schema::hasTable('devolucoes')) {
            return;
        }

        // Recriar a coluna antiga e copiar os dados de volta
        Schema::table('devolucoes', function (Blueprint $table) {
            if (!Schema::hasColumn('devolucoes', 'observacoes')) {
                $table->text('observacoes')->nullable()->after('tipo_pagamento');
            }
        });

        // Copiar dados de observacao -> observacoes quando observacoes estiver nula
        DB::statement("UPDATE devolucoes SET observacoes = COALESCE(observacoes, observacao)");

        // Opcional: manter a coluna 'observacao'. Não removemos para evitar perda de compatibilidade.
    }
};
