<?php

namespace App\Services;

use Dompdf\Dompdf;

class CupomNaoFiscal
{
    /**
     * Renderiza o PDF do cupom não fiscal.
     *
     * @param mixed $venda Objeto da venda (Nfce) ou pré-venda, contendo itens e faturas
     * @param mixed $config Configurações/Empresa para exibição (logo, nome, etc.)
     * @param int $isPreVenda 1 para pré-venda, 0 para PDV normal
     * @param mixed $troca Objeto de troca opcional para exibir dados específicos
     * @return string PDF binário
     */
    public function render($venda, $config, int $isPreVenda = 0, $troca = null): string
    {
        // Normalizar dados mínimos esperados na view
        $empresa = $config; // alias na view
        $itens = $venda->itens ?? [];
        $faturas = $venda->fatura ?? [];
        $cliente = $venda->cliente ?? null;

        $data = [
            'empresa' => $empresa,
            'venda' => $venda,
            'itens' => $itens,
            'faturas' => $faturas,
            'cliente' => $cliente,
            'isPreVenda' => (bool)$isPreVenda,
            'troca' => $troca,
        ];

        $html = view('cupom.nao_fiscal', $data);

        $domPdf = new Dompdf(["enable_remote" => true]);
        $domPdf->loadHtml($html);

        // Largura padrão 78mm ~ 220pt; altura automática
        $domPdf->set_paper([0, 0, 226, 1000]);
        $domPdf->render();

        // Retorna o binário do PDF
        return $domPdf->output();
    }
}


