<?php

namespace App\Observers;

use App\Models\Nfe;
use App\Models\Nfce;
use App\Models\TaxaPagamento;
use App\Models\FaturaNfe;
use App\Models\FaturaNfce;

class TaxaPagamentoObserver
{
    /**
     * Salva a taxa atual no NFe quando for criado
     */
    public function createdNfe(Nfe $nfe)
    {
        $this->salvarTaxaNfe($nfe);
    }

    /**
     * Salva a taxa atual no NFCe quando for criado
     */
    public function createdNfce(Nfce $nfce)
    {
        $this->salvarTaxaNfce($nfce);
    }

    /**
     * Salva a taxa atual na fatura de NFe quando for criada
     */
    public function createdFaturaNfe(FaturaNfe $fatura)
    {
        $this->salvarTaxaFaturaNfe($fatura);
    }

    /**
     * Salva a taxa atual na fatura de NFCe quando for criada
     */
    public function createdFaturaNfce(FaturaNfce $fatura)
    {
        $this->salvarTaxaFaturaNfce($fatura);
    }

    /**
     * Salva a taxa de pagamento atual no registro de NFe
     */
    private function salvarTaxaNfe(Nfe $nfe)
    {
        if (!empty($nfe->tipo_pagamento) && !empty($nfe->empresa_id)) {
            $bandeira_cartao = $nfe->bandeira_cartao;
            
            $taxa = TaxaPagamento::where('empresa_id', $nfe->empresa_id)
                ->where('tipo_pagamento', $nfe->tipo_pagamento)
                ->when($bandeira_cartao != '' && $bandeira_cartao != '99', function ($q) use ($bandeira_cartao) {
                    return $q->where('bandeira_cartao', $bandeira_cartao);
                })
                ->first();
                
            if ($taxa) {
                $nfe->taxa_percentual = $taxa->taxa;
                $nfe->save();
            }
        }
    }

    /**
     * Salva a taxa de pagamento atual no registro de NFCe
     */
    private function salvarTaxaNfce(Nfce $nfce)
    {
        if (!empty($nfce->tipo_pagamento) && !empty($nfce->empresa_id)) {
            $bandeira_cartao = $nfce->bandeira_cartao;
            
            $taxa = TaxaPagamento::where('empresa_id', $nfce->empresa_id)
                ->where('tipo_pagamento', $nfce->tipo_pagamento)
                ->when($bandeira_cartao != '' && $bandeira_cartao != '99', function ($q) use ($bandeira_cartao) {
                    return $q->where('bandeira_cartao', $bandeira_cartao);
                })
                ->first();
                
            if ($taxa) {
                $nfce->taxa_percentual = $taxa->taxa;
                $nfce->save();
            }
        }
    }

    /**
     * Salva a taxa de pagamento atual no registro de fatura de NFe
     */
    private function salvarTaxaFaturaNfe(FaturaNfe $fatura)
    {
        if (!empty($fatura->tipo_pagamento) && !empty($fatura->nfe) && !empty($fatura->nfe->empresa_id)) {
            $bandeira_cartao = $fatura->nfe->bandeira_cartao;
            
            $taxa = TaxaPagamento::where('empresa_id', $fatura->nfe->empresa_id)
                ->where('tipo_pagamento', $fatura->tipo_pagamento)
                ->when($bandeira_cartao != '' && $bandeira_cartao != '99', function ($q) use ($bandeira_cartao) {
                    return $q->where('bandeira_cartao', $bandeira_cartao);
                })
                ->first();
                
            if ($taxa) {
                $fatura->taxa_percentual = $taxa->taxa;
                $fatura->save();
            }
        }
    }

    /**
     * Salva a taxa de pagamento atual no registro de fatura de NFCe
     */
    private function salvarTaxaFaturaNfce(FaturaNfce $fatura)
    {
        if (!empty($fatura->tipo_pagamento) && !empty($fatura->nfce) && !empty($fatura->nfce->empresa_id)) {
            $bandeira_cartao = $fatura->nfce->bandeira_cartao;
            
            $taxa = TaxaPagamento::where('empresa_id', $fatura->nfce->empresa_id)
                ->where('tipo_pagamento', $fatura->tipo_pagamento)
                ->when($bandeira_cartao != '' && $bandeira_cartao != '99', function ($q) use ($bandeira_cartao) {
                    return $q->where('bandeira_cartao', $bandeira_cartao);
                })
                ->first();
                
            if ($taxa) {
                $fatura->taxa_percentual = $taxa->taxa;
                $fatura->save();
            }
        }
    }
} 