<?php

namespace App\Observers;

use App\Models\FaturaNfe;
use App\Models\TaxaPagamento;

class FaturaNfeTaxaObserver
{
    /**
     * Handle the FaturaNfe "created" event.
     */
    public function created(FaturaNfe $fatura)
    {
        if (!empty($fatura->tipo_pagamento) && !empty($fatura->nfe) && !empty($fatura->nfe->empresa_id)) {
            $bandeira_cartao = $fatura->nfe->bandeira_cartao;
            
            $taxa = TaxaPagamento::where('empresa_id', $fatura->nfe->empresa_id)
                ->where('tipo_pagamento', $fatura->tipo_pagamento)
                ->when($bandeira_cartao != '' && $bandeira_cartao != '99', function ($q) use ($bandeira_cartao) {
                    return $q->where('bandeira_cartao', $bandeira_cartao);
                })
                ->first();
                
            if ($taxa) {
                $fatura->taxa_percentual = $taxa->taxa;
                $fatura->save();
            }
        }
    }
} 