<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;


class ValidaEmpresa
{
	public function handle($request, Closure $next)
	{
		// Debug: Verificar se o middleware está sendo executado
		\Log::info('ValidaEmpresa executado');
		// Debug: Verificar o relacionamento
		$usuarioEmpresa = auth()->user()->empresa;
		\Log::info('UsuarioEmpresa:', [$usuarioEmpresa]);
		if ($usuarioEmpresa) {
			\Log::info('empresa_id:', [$usuarioEmpresa->empresa_id]);
		} else {
			\Log::warning('UsuarioEmpresa é null para o usuário logado.');
		}
		// Opcional: descomente para debug visual direto na tela
		// dd($usuarioEmpresa, $usuarioEmpresa ? $usuarioEmpresa->empresa_id : null);
		$request->merge(['empresa_id' => $usuarioEmpresa ? $usuarioEmpresa->empresa_id : null]);
		return $next($request);
	}
}
