<?php

namespace App\Http\Middleware;

use Closure;
use Response;
use App\Models\ApiConfig;
use Illuminate\Support\Facades\Log;

class ValidaApiToken
{

	public function handle($request, Closure $next){
		
		$token = $request->header('Authorization');
        // normalize token: trim and optionally strip 'Bearer '
        if (is_string($token)) {
            $token = trim($token);
            if (stripos($token, 'Bearer ') === 0) {
                $token = trim(substr($token, 7));
            }
        }

        // TEMP LOG: diagnostico especifico para usuarios
        $path = $request->path();
        if (strpos($path, 'api/v1/usuarios') === 0) {
            Log::info('ValidaApiToken usuarios debug', [
                'path' => $path,
                'authorization_header_present' => $request->hasHeader('Authorization'),
                'authorization_header_value' => $request->header('Authorization'),
                'normalized_token' => $token,
            ]);
        }

		$apiConfig = ApiConfig::where('token', $token)->first();
        // Fallback: se não encontrar por header, tenta pegar 'token' via query/body
        if ($apiConfig == null) {
            $altToken = $request->input('token');
            if (is_string($altToken)) {
                $altToken = trim($altToken);
            }
            if ($altToken) {
                $apiConfig = ApiConfig::where('token', $altToken)->first();
                if ($apiConfig) {
                    $token = $altToken; // passa a usar o token alternativo
                }
            }
        }
        if($apiConfig == null){
            Log::warning('ValidaApiToken token_not_found', [
                'path' => $request->path(),
                'authorization_header_value' => $request->header('Authorization'),
                'normalized_token' => $token,
                'fallback_token' => $request->input('token'),
                'normalized_token_length' => is_string($token) ? strlen($token) : null,
            ]);
            $path = $request->path();
            if (strpos($path, 'api/v1/usuarios') === 0) {
                return response()->json([
                    'message' => 'Token não encontrado!',
                    'debug' => [
                        'authorization_header_present' => $request->hasHeader('Authorization'),
                        'authorization_header_value' => $request->header('Authorization'),
                        'normalized_token' => $token,
                        'fallback_token' => $request->input('token'),
                        'normalized_token_length' => is_string($token) ? strlen($token) : null,
                    ]
                ], 401);
            }
            return response()->json("Token não encontrado!", 401);
        }

		if($apiConfig->status == 0){
			return response()->json("Token desativado!", 401);
		}

		$request->merge([
			'empresa_id' => $apiConfig->empresa->id,
			'token' => $token
		]);

		return $next($request);
	}
}