<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class UpdateCertificateServices extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'certificate:update-services';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Atualiza todos os serviços para usar a nova classe CertificateUtil';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info('Atualizando serviços para usar CertificateUtil...');

        $services = [
            'app/Services/NFCeServiceApi.php',
            'app/Services/MDFeService.php',
            'app/Services/DFeService.php',
            'app/Services/CTeOsService.php'
        ];

        foreach ($services as $service) {
            $this->updateService($service);
        }

        $this->info('Serviços atualizados com sucesso!');
        return 0;
    }

    private function updateService($filePath)
    {
        if (!file_exists($filePath)) {
            $this->warn("Arquivo não encontrado: {$filePath}");
            return;
        }

        $content = file_get_contents($filePath);
        $originalContent = $content;

        // Adicionar import da CertificateUtil
        if (strpos($content, 'use App\\Utils\\CertificateUtil;') === false) {
            $content = str_replace(
                'use App\\Utils\\EstoqueUtil;',
                "use App\\Utils\\EstoqueUtil;\nuse App\\Utils\\CertificateUtil;",
                $content
            );
        }

        // Substituir Certificate::readPfx por CertificateUtil::loadCertificate
        $content = preg_replace(
            '/Certificate::readPfx\(\$([^,]+)->arquivo,\s*\$([^)]+)->senha\)/',
            'CertificateUtil::loadCertificate($$1->arquivo, $$2->senha, $$1->tipo_certificado ?? \'auto\')',
            $content
        );

        // Substituir a linha completa do tools
        $content = preg_replace(
            '/\$this->tools\s*=\s*new\s+Tools\([^)]+,\s*CertificateUtil::loadCertificate\([^)]+\)\);/',
            '$this->tools = new Tools(json_encode($config), $certificate);',
            $content
        );

        // Adicionar a variável certificate antes do tools
        $content = preg_replace(
            '/(\$this->config\s*=\s*\$config;)/',
            "$1\n\t\t\n\t\t// Carregar certificado usando a nova classe utilitária\n\t\t\$certificate = CertificateUtil::loadCertificate(\n\t\t\t\$empresa->arquivo, \n\t\t\t\$empresa->senha, \n\t\t\t\$empresa->tipo_certificado ?? 'auto'\n\t\t);",
            $content
        );

        if ($content !== $originalContent) {
            file_put_contents($filePath, $content);
            $this->info("Atualizado: {$filePath}");
        } else {
            $this->warn("Nenhuma alteração necessária: {$filePath}");
        }
    }
}

