
<?php $__env->startSection('css'); ?>
<style type="text/css">
    .image-variation{
        width: 180px;
        height: 100px;
        margin-top: 10px;
        border-radius: 10px;
    }
</style>
<?php $__env->stopSection(); ?>
<div id="basicwizard">
    <ul class="nav nav-pills nav-justified form-wizard-header mb-4 m-2">
        <li class="nav-item">
            <a href="#tab-identificacao" data-bs-toggle="tab" data-toggle="tab"  class="nav-link rounded-0 py-1"> 
                <i class="ri-product-hunt-fill fw-normal fs-18 align-middle me-1"></i>
                <span class="d-none d-sm-inline">Identificação</span>
            </a>
        </li>
        <li class="nav-item">
            <a href="#tab-fiscal" data-bs-toggle="tab" data-toggle="tab" class="nav-link rounded-0 py-1">
                <i class="ri-file-code-line fs-18 align-middle me-1"></i>
                <span class="d-none d-sm-inline tab-fiscal">Fiscal</span>
            </a>
        </li>
        <li class="nav-item">
            <a href="#tab-outros" data-bs-toggle="tab" data-toggle="tab" class="nav-link rounded-0 py-1">
                <i class="ri-stack-line fs-18 align-middle me-1"></i>
                <span class="d-none d-sm-inline">Outros</span>
            </a>
        </li>
    </ul>

    <div class="tab-content b-0 mb-0">
        <div class="tab-pane" id="tab-identificacao">
            <div class="row g-2 m-2">

                <input type="hidden" value="<?php echo e(isset($item) ? 1 : 0); ?>" id="edit">
                <div class="col-md-6">
                    <?php echo Form::text('nome', 'Nome')
                    ->required(); ?>

                </div>
                <div class="col-md-2 col-produto">
                    <?php echo Form::tel('valor_compra', 'Valor de compra')
                    ->required()
                    ->value(isset($item) ? __moeda($item->valor_compra) : '')
                    ->attrs(['class' => 'moeda']); ?>

                </div>

                <div class="col-md-2 col-produto">
                    <?php echo Form::tel('percentual_lucro', '% lucro')
                    ->required()
                    ->value(isset($item) ? $item->percentual_lucro : ($configGeral ? $configGeral->percentual_lucro_produto : ''))
                    ->attrs(['class' => 'percentual']); ?>

                </div>

                <?php if($configGeral && $configGeral->app_valor_aprazo == 1): ?>
                <div class="col-md-2 col-produto">
                    <?php echo Form::tel('valor_unitario', 'Valor de venda à vista')
                    ->required()
                    ->value(isset($item) ? __moeda($item->valor_unitario) : '')
                    ->attrs(['class' => 'moeda']); ?>

                </div>

                <div class="col-md-2 col-produto">
                    <?php echo Form::tel('valor_prazo', 'Valor de venda à prazo')
                    ->value(isset($item) ? __moeda($item->valor_prazo) : '')
                    ->attrs(['class' => 'moeda']); ?>

                </div>

                <?php else: ?>
                <div class="col-md-2 col-produto">
                    <?php echo Form::tel('valor_unitario', 'Valor de venda')
                    ->required()
                    ->value(isset($item) ? __moeda($item->valor_unitario) : '')
                    ->attrs(['class' => 'moeda']); ?>

                </div>
                <?php endif; ?>

                <div class="col-md-2 col-produto">
                    <?php echo Form::tel('valor_minimo_venda', 'Valor mínimo de venda')
                    ->value(isset($item) ? __moeda($item->valor_minimo_venda) : '')
                    ->attrs(['class' => 'moeda']); ?>

                </div>

                <div class="col-md-2">
                    <label class="form-label">Código de barras</label>
                    <div class="input-group input-group-merge" style="margin-top: -8px">
                        <input type="text" name="codigo_barras" value="<?php echo e(isset($item) ? $item->codigo_barras : old('codigo_barras')); ?>" id="codigo_barras" class="form-control">
                        <div class="input-group-text">
                            <span class="ri-barcode-box-line" onclick="gerarCode(1)"></span>
                        </div>
                    </div>
                </div>

                <div class="col-md-2">
                    <label class="form-label">2º Código de barras</label>
                    <div class="input-group input-group-merge" style="margin-top: -8px">
                        <input type="text" name="codigo_barras2" value="<?php echo e(isset($item) ? $item->codigo_barras2 : old('codigo_barras2')); ?>" id="codigo_barras2" class="form-control">
                        <div class="input-group-text">
                            <span class="ri-barcode-box-line" onclick="gerarCode(2)"></span>
                        </div>
                    </div>
                </div>

                <div class="col-md-2">
                    <label class="form-label">3º Código de barras</label>
                    <div class="input-group input-group-merge" style="margin-top: -8px">
                        <input type="text" name="codigo_barras3" value="<?php echo e(isset($item) ? $item->codigo_barras3 : old('codigo_barras3')); ?>" id="codigo_barras3" class="form-control">
                        <div class="input-group-text">
                            <span class="ri-barcode-box-line" onclick="gerarCode(3)"></span>
                        </div>
                    </div>
                </div>

                <div class="col-md-2">
                    <?php echo Form::tel('referencia', 'Referência'); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::select('gerenciar_estoque', 'Gerenciar estoque', ['0' => 'Não', '1' => 'Sim'])
                    ->attrs(['class' => 'form-select'])
                    ->value(isset($item) ? $item->gerenciar_estoque : ($configGeral ? $configGeral->gerenciar_estoque : '')); ?>

                </div>

                <?php if(!isset($item)): ?>
                <div class="col-md-2">
                    <?php echo Form::tel('estoque_inicial', 'Estoque inicial')
                    ->attrs(['class' => 'quantidade']); ?>

                </div>
                <?php endif; ?>

                <div class="col-md-3">
                    <label>Categoria</label>
                    <div class="input-group flex-nowrap">
                        <select class="select2" name="categoria_id" id="categoria_id">
                            <option value="">Selecione</option>
                            <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php if(isset($item)): ?> <?php if($item->categoria_id == $c->id): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($c->id); ?>"><?php echo e($c->nome); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <button class="btn btn-dark" data-bs-toggle="modal" data-bs-target="#modal_categoria_produto" type="button">
                            <i class="ri-add-circle-fill"></i>
                        </button>
                    </div>
                </div>

                <div class="col-md-3">
                    <?php echo Form::select('sub_categoria_id', 'Subcategoria')
                    ->attrs(['class' => 'form-select'])
                    ->options(isset($item) && $item->subcategoria ? [$item->subcategoria->id => $item->subcategoria->nome] : []); ?>

                </div>

                <div class="col-md-3">
                    <label>Marca</label>
                    <div class="input-group flex-nowrap">
                        <select class="select2" name="marca_id" id="marca_id">
                            <option value="">Selecione</option>
                            <?php $__currentLoopData = $marcas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $m): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php if(isset($item)): ?> <?php if($item->marca_id == $m->id): ?> selected <?php endif; ?> <?php endif; ?> value="<?php echo e($m->id); ?>"><?php echo e($m->nome); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <button class="btn btn-dark" data-bs-toggle="modal" data-bs-target="#modal_marca" type="button">
                            <i class="ri-add-circle-fill"></i>
                        </button>
                    </div>
                </div>

                <div class="col-md-2">
                    <?php echo Form::text('estoque_minimo', 'Estoque mínimo')
                    ->attrs(['data-mask' => '00000.00', 'data-mask-reverse' => 'true']); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::text('alerta_validade', 'Alerta de validade (dias)')
                    ->attrs(['data-mask' => '000']); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::tel('referencia_balanca', 'Referência balança')
                    ->attrs(); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::select('unidade', 'Unidade', $unidades->pluck('nome', 'nome')->all())
                    ->required()
                    ->attrs(['class' => 'select2'])
                    ->value(isset($item) ? $item->unidade : 'UN'); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::select('status', 'Ativo', ['1' => 'Sim', '0' => 'Não'])
                    ->attrs(['class' => 'form-select'])->required(); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::select('composto', 'Composto', ['0' => 'Não', '1' => 'Sim'])->attrs(['class' => 'form-select']); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::select('variavel', 'Com variações', ['0' => 'Não', '1' => 'Sim'])->attrs(['class' => 'form-select'])
                    ->value((isset($item) && $item->variacao_modelo_id != null) ? 1 : 0); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::select('combo', 'Tipo combo', ['0' => 'Não', '1' => 'Sim'])->attrs(['class' => 'form-select']); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::select('tipo_unico', 'Tipo único', ['0' => 'Não', '1' => 'Sim'])->attrs(['class' => 'form-select tooltipp']); ?>

                    <div class="text-tooltip d-none">
                        Marcar como sim se for usar identificação única para cada item na compra e venda
                    </div>
                </div>

                <div class="col-md-2">
                    <?php echo Form::select('balanca_pdv', 'Balança PDV', ['0' => 'Não', '1' => 'Sim'])->attrs(['class' => 'form-select']); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::select('exportar_balanca', 'Exportar para Balança', ['0' => 'Não', '1' => 'Sim'])->attrs(['class' => 'form-select']); ?>

                </div>

                <?php if(__countLocalAtivo() > 1): ?>
                <div class="col-md-4">
                    <label for="">Disponibilidade</label>

                    <select required class="select2 form-control select2-multiple" data-toggle="select2" name="locais[]" multiple="multiple">
                        <?php $__currentLoopData = __getLocaisAtivoUsuario(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $local): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option <?php if(sizeof(__getLocaisAtivoUsuario()) == 1): ?> selected <?php endif; ?> <?php if(in_array($local->id, (isset($item) ? $item->locais->pluck('localizacao_id')->toArray() : []))): ?> selected <?php endif; ?> value="<?php echo e($local->id); ?>"><?php echo e($local->descricao); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <?php else: ?>

                <input type="hidden" value="<?php echo e(__getLocalAtivo() ? __getLocalAtivo()->id : ''); ?>" name="local_id">
                <?php endif; ?>

                <div class="col-md-2">
                    <?php echo Form::tel('valor_atacado', 'Valor de atacado')
                    ->value(isset($item) ? __moeda($item->valor_atacado) : '')
                    ->attrs(['class' => 'moeda']); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::tel('quantidade_atacado', 'Quantidade para atacado')
                    ->value(isset($item) ? $item->quantidade_atacado : '')
                    ->attrs(['data-mask' => '000']); ?>

                </div>

                <div class="col-md-3">
                    <?php echo Form::tel('observacao', 'Observação'); ?>

                </div>
                <div class="col-md-3">
                    <?php echo Form::tel('observacao2', 'Observação 2'); ?>

                </div>
                <div class="col-md-3">
                    <?php echo Form::tel('observacao3', 'Observação 3'); ?>

                </div>
                <div class="col-md-3">
                    <?php echo Form::tel('observacao4', 'Observação 4'); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::select('tipo_dimensao', 'Tipo dimensão', ['0' => 'Não', '1' => 'Sim'])->attrs(['class' => 'form-select tooltipp2']); ?>

                    <div class="text-tooltip2 d-none">
                        Marcar como sim se for usar para registrar as dimensões do produto na venda
                    </div>
                </div>

                <div class="col-md-2">
                    <?php echo Form::tel('espessura', 'Espessura')->attrs(['data-mask' => '00000.00', 'data-mask-reverse' => 'true']); ?>

                </div>
                <div class="col-md-2">
                    <?php echo Form::tel('largura', 'Largura')
                    ->attrs(['class' => '']); ?>

                </div>
                <div class="col-md-2">
                    <?php echo Form::tel('altura', 'Altura')
                    ->attrs(['class' => '']); ?>

                </div>
                <div class="col-md-2">
                    <?php echo Form::tel('comprimento', 'Comprimento')
                    ->attrs(['class' => '']); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::tel('peso', 'Peso')
                    ->attrs(['class' => 'peso']); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::select('tipo_producao', 'Para produção', ['0' => 'Não', '1' => 'Sim'])->attrs(['class' => 'form-select tooltipp3']); ?>

                    <div class="text-tooltip3 d-none">
                        Marcar como sim se for usar este produto para produção após realizar vendas
                    </div>
                </div>

                <div class="col-12 div-variavel">
                    <div class="table-responsive">
                        <table class="table table-dynamic">
                            <thead class="table-dark">
                                <tr>
                                    <th>Variação</th>
                                    <th>Valores da variação</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td width="250px">
                                        <div class="mt-1">
                                            <?php echo Form::select('variacao_modelo_id', 'Variação principal', ['' => 'Selecione'] + $variacoes->pluck('descricao', 'id')->all())
                                            ->attrs(['class' => 'form-select'])
                                            ->value(isset($item) ? $item->variacao_modelo_id : null); ?>

                                        </div>

                                        <div class="mt-2">
                                            <?php echo Form::select('sub_variacao_modelo_id', 'Sub variação', ['' => 'Selecione'] + $variacoes->pluck('descricao', 'id')->all())
                                            ->attrs(['class' => 'form-select'])
                                            ->value(isset($item) ? $item->variacao_modelo_id : null); ?>

                                        </div>
                                    </td>
                                    <td>
                                        <div class="row">
                                            <table class="table table-dynamic table-variacao">
                                                <thead class="table-success">
                                                    <tr>
                                                        <th>Descrição</th>
                                                        <th>Valor</th>
                                                        <th>Código de barras</th>
                                                        <th>Referência</th>
                                                        <th>Estoque</th>
                                                        <th>Imagem</th>
                                                        <th>

                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if(isset($item)): ?>
                                                    <?php $__currentLoopData = $item->variacoes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr class="dynamic-form">
                                                        <input type="hidden" name="variacao_id[]]]" value="<?php echo e($v->id); ?>">
                                                        <td>
                                                            <input type="text" class="form-control" name="descricao_variacao[]" value="<?php echo e($v->descricao); ?>" required readonly>
                                                        </td>
                                                        <td>
                                                            <input type="tel" class="form-control moeda" name="valor_venda_variacao[]" value="<?php echo e(__moeda($v->valor)); ?>" required>
                                                        </td>

                                                        <td>
                                                            <input type="tel" class="form-control ignore" name="codigo_barras_variacao[]" value="<?php echo e($v->codigo_barras); ?>">
                                                        </td>
                                                        <td>
                                                            <input type="text" class="form-control ignore" name="referencia_variacao[]" value="<?php echo e($v->referencia); ?>">
                                                        </td>
                                                        <td>
                                                            <input readonly type="text" class="form-control ignore" name="estoque_variacao[]" value="">
                                                        </td>
                                                        <td>
                                                            <input class="ignore" accept="image/*" type="file" class="form-control" name="imagem_variacao[]" value="">
                                                            <img src="<?php echo e($v->img); ?>" class="image-variation"><br>
                                                            <span>imagem atual</span>
                                                        </td>
                                                        <td>
                                                            <button type="button" class="btn btn-sm btn-danger btn-remove-tr-variacao">
                                                                <i class="ri-subtract-line"></i>
                                                            </button>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="row col-12 col-lg-3 mt-3">
                                            <button type="button" class="btn btn-dark btn-add-tr-variacao">
                                                <i class="ri-add-fill"></i>
                                                Adicionar linha
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="col-12 div-combo">

                    <div class="row m-2">
                        <div class="col-md-3"></div>
                        <div class="col-md-6 col-12">
                            <select id="inp-produto_combo_id"></select>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-dynamic table-combo">
                            <thead class="table-dark">
                                <tr>
                                    <th>Produto</th>
                                    <th>Quantidade</th>
                                    <th>Valor de compra</th>
                                    <th>Subtotal</th>
                                    <th>Ação</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(isset($item)): ?>
                                <?php $__currentLoopData = $item->itensDoCombo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="dynamic-form">
                                    <input type="hidden" name="produto_combo_id[]" value="<?php echo e($c->item_id); ?>">
                                    <td style="width: 420px">
                                        <span><?php echo e($c->produtoDoCombo->nome); ?></span>
                                    </td>
                                    <td style="width: 120px">
                                        <input type="tel" class="form-control qtd-combo quantidade" name="quantidade_combo[]" 
                                        value="<?php echo e($c->quantidade); ?>">
                                    </td>
                                    <td>
                                        <input type="tel" class="form-control moeda valor-compra-combo" name="valor_compra_combo[]" value="<?php echo e(__moeda($c->valor_compra)); ?>">
                                    </td>
                                    <td>
                                        <input type="tel" class="form-control moeda subtotal-combo" name="subtotal_combo[]" value="<?php echo e(__moeda($c->sub_total)); ?>">
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-danger btn-remove-tr-combo">
                                            <i class="ri-subtract-line"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="row">
                        <div class="col-md-2">
                            <?php echo Form::tel('margem_combo', 'Margem %')
                            ->value(isset($item) ? $item->margem_combo : ($configGeral ? $configGeral->margem_combo : ''))
                            ->attrs(['class' => 'percentual']); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::tel('valor_combo', 'Valor do  combo')
                            ->value(isset($item) ? __moeda($item->valor_unitario) : __moeda(0))
                            ->attrs(['class' => 'moeda']); ?>

                        </div>
                    </div>
                </div>

                <div class="col-12"></div>

                <div class="card col-md-3 mt-3 form-input">
                    <div class="preview">
                        <button type="button" id="btn-remove-imagem" class="btn btn-link-danger btn-sm btn-danger">x</button>
                        <?php if(isset($item)): ?>
                        <img id="file-ip-1-preview" src="<?php echo e($item->img); ?>">
                        <?php else: ?>
                        <img id="file-ip-1-preview" src="/imgs/no-image.png">
                        <?php endif; ?>
                    </div>
                    <label for="file-ip-1">Imagem</label>
                    <?php if(isset($item)): ?>
                    <a class="btn btn-danger btn-sm w-50 mt-2 mb-1" href="<?php echo e(route('produtos.remove-image', [$item->id])); ?>">
                        <i class="ri-close-line"></i>
                        Remover imagem
                    </a>
                    <?php endif; ?>
                    <input type="file" id="file-ip-1" name="image" accept="image/*" onchange="showPreview(event);">
                </div>
            </div>
        </div>
    </div>
    <!-- fim identificação -->

    <div class="tab-content b-0 mb-0">
        <div class="tab-pane" id="tab-fiscal">
            <div class="row g-2 m-2">

                <div class="col-md-2">
                    <?php echo Form::select('padrao_id', 'Padrão de tributação', ['' => 'Selecione'] + $padroes->pluck('descricao', 'id')->all())
                    ->attrs(['class' => 'form-select'])
                    ->value(isset($item) ? $item->padrao_id : ($padraoTributacao != null ? $padraoTributacao->id : '')); ?>

                </div>

                <div class="col-md-4">
                    <?php echo Form::select('ncm', 'NCM')
                    ->required(__isPlanoFiscal())
                    ->options(isset($item) ? ($item->_ncm ? [$item->ncm => $item->_ncm->descricao] : []) : []); ?>

                </div>
                <div class="col-md-2">
                    <?php echo Form::tel('cest', 'CEST')
                    ->attrs(['class' => 'cest']); ?>

                </div>
                <div class="col-md-2">
                    <?php echo Form::tel('perc_icms', '% ICMS')
                    ->attrs(['class' => 'percentual'])
                    ->required(__isPlanoFiscal()); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::tel('perc_pis', '% PIS')
                    ->required(__isPlanoFiscal())
                    ->attrs(['class' => 'percentual']); ?>

                </div>
                <div class="col-md-2">
                    <?php echo Form::tel('perc_cofins', '% COFINS')
                    ->required(__isPlanoFiscal())
                    ->attrs(['class' => 'percentual']); ?>

                </div>
                <div class="col-md-2">
                    <?php echo Form::tel('perc_ipi', '% IPI')
                    ->required(__isPlanoFiscal())
                    ->attrs(['class' => 'percentual']); ?>

                </div>
                <div class="col-md-2">
                    <?php echo Form::tel('perc_red_bc', '% Red BC')
                    ->attrs(['class' => 'percentual']); ?>

                </div>

                <div class="col-md-4">
                    <?php echo Form::select('origem', 'Origem', App\Models\Produto::origens())
                    ->required(__isPlanoFiscal())
                    ->attrs(['class' => 'form-select select2']); ?>

                </div>

                <div class="col-md-6">
                    <?php echo Form::select('cst_csosn', 'CST/CSOSN', $listaCTSCSOSN)
                    ->required(__isPlanoFiscal())
                    ->attrs(['class' => 'form-select']); ?>

                </div>
                <div class="col-md-4">
                    <?php echo Form::select('cst_pis', 'CST PIS', App\Models\Produto::listaCST_PIS_COFINS())
                    ->required(__isPlanoFiscal())
                    ->attrs(['class' => 'form-select']); ?>

                </div>
                <div class="col-md-4">
                    <?php echo Form::select('cst_cofins', 'CST COFINS', App\Models\Produto::listaCST_PIS_COFINS())
                    ->required(__isPlanoFiscal())
                    ->attrs(['class' => 'form-select']); ?>

                </div>
                <div class="col-md-4">
                    <?php echo Form::select('cst_ipi', 'CST IPI', App\Models\Produto::listaCST_IPI())
                    ->required(__isPlanoFiscal())
                    ->attrs(['class' => 'form-select']); ?>

                </div>
                <div class="col-md-6">
                    <?php echo Form::select('cEnq', 'Código de enquandramento de IPI', App\Models\Produto::listaCenqIPI())
                    ->required(__isPlanoFiscal())
                    ->attrs(['class' => 'form-select select2']); ?>

                </div>
                <div class="col-md-2">
                    <?php echo Form::tel('cfop_estadual', 'CFOP Estadual')
                    ->required(__isPlanoFiscal())
                    ->attrs(['class' => 'cfop']); ?>

                </div>
                <div class="col-md-2">
                    <?php echo Form::tel('cfop_outro_estado', 'CFOP Inter Estadual')
                    ->required(__isPlanoFiscal())
                    ->attrs(['class' => 'cfop']); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::tel('cfop_entrada_estadual', 'CFOP Entrada Estadual')
                    ->required(__isPlanoFiscal())
                    ->attrs(['class' => 'cfop']); ?>

                </div>
                <div class="col-md-2">
                    <?php echo Form::tel('cfop_entrada_outro_estado', 'CFOP Entrada Inter Estadual')
                    ->required(__isPlanoFiscal())
                    ->attrs(['class' => 'cfop']); ?>

                </div>
                <div class="col-md-2">
                    <?php echo Form::text('codigo_beneficio_fiscal', 'Código benefício'); ?>

                </div>

                <div class="col-md-3">
                    <?php echo Form::select('modBCST', 'Modalidade BC-ST', App\Models\Produto::modalidadesBCST())
                    ->attrs(['class' => 'form-select']); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::tel('pICMSST', '% ICMS ST')
                    ->attrs(['class' => 'percentual']); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::tel('pMVAST', '% MVA ST')
                    ->attrs(['class' => 'percentual']); ?>

                </div>

                <div class="col-md-2">
                    <?php echo Form::tel('redBCST', '% Red BC ST')
                    ->attrs(['class' => 'percentual']); ?>

                </div>
            </div>
        </div>
    </div>
    
    <div class="tab-content b-0 mb-0">
        <div class="tab-pane" id="tab-outros">
            <div class="row g-2">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>
                                    <div class="form-check form-switch">
                                        <input type="checkbox" class="form-check-input" id="inp-petroleo" <?php if(isset($item)): ?> <?php if($item->codigo_anp != ''): ?> checked <?php endif; ?> <?php endif; ?>> <strong>Derivado do petróleo</strong>
                                    </div>
                                </h4>
                            </div>
                            <div class="card-body div-petroleo d-none m-card" style="margin-top: -40px">

                                <div class="row">

                                    <div class="col-md-4">
                                        <?php echo Form::select('codigo_anp', 'ANP', ['' => 'Selecione'] + App\Models\Produto::listaAnp())
                                        ->attrs(['class' => 'select2']); ?>

                                    </div>

                                    <div class="col-md-1">
                                        <?php echo Form::tel('perc_glp', '%GLP')
                                        ->attrs(['class' => 'percentual']); ?>

                                    </div>
                                    <div class="col-md-1">
                                        <?php echo Form::tel('perc_gnn', '%GNN')
                                        ->attrs(['class' => 'percentual']); ?>

                                    </div>
                                    <div class="col-md-1">
                                        <?php echo Form::tel('perc_gni', '%GNI')
                                        ->attrs(['class' => 'percentual']); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::tel('valor_partida', 'Valor de partida')
                                        ->attrs(['class' => 'moeda']); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::text('unidade_tributavel', 'Un. tributável'); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::tel('quantidade_tributavel', 'Qtd. tributável'); ?>

                                    </div>

                                    <div class="col-md-3">
                                        <?php echo Form::tel('adRemICMSRet', 'Alíquota ad rem do imposto retido')
                                        ->attrs(['data-mask' => '00,0000']); ?>

                                    </div>
                                    <div class="col-md-3">
                                        <?php echo Form::tel('pBio', 'Indice de mistura do Biodiesel')
                                        ->attrs(['class' => 'percentual']); ?>

                                    </div>
                                    <div class="col-md-2">
                                        <?php echo Form::tel('pOrig', '% de origem')
                                        ->attrs(['class' => 'percentual']); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::select('indImport', 'Indicador de importação',
                                        [ 0 => 'Não', 1 => 'Sim']
                                        )
                                        ->attrs(['class' => 'form-select']); ?>

                                    </div>

                                    <div class="col-md-3">
                                        <?php echo Form::select('cUFOrig', 'UF de origem do produtor ou do importador', ['' => 'Selecione'] + App\Models\Cidade::getEstadosCodigo())
                                        ->attrs(['class' => 'select2']); ?>

                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if(__isActivePlan(Auth::user()->empresa, 'Cardapio')): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>
                                    <?php if(isset($cardapio)): ?>
                                    <?php if($cardapio == 1): ?>
                                    <input type="hidden" name="redirect_cardapio" value="1">
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <div class="form-check form-switch form-checkbox-danger">
                                        <input type="checkbox" name="cardapio" class="form-check-input" id="inp-cardapio" <?php if(isset($item)): ?> <?php if($item->cardapio): ?> checked <?php endif; ?> <?php endif; ?> <?php if(isset($cardapio)): ?> <?php if($cardapio == 1): ?> checked <?php endif; ?> <?php endif; ?> ><strong>Cardápio</strong>
                                    </div>
                                </h4>
                            </div>
                            <div class="card-body div-cardapio d-none m-card" style="margin-top: -40px">

                                <div class="row">

                                    <div class="col-md-2">
                                        <?php echo Form::tel('valor_cardapio', 'Valor de Cardápio')
                                        ->value((isset($item) && $item->valor_cardapio > 0) ? __moeda($item->valor_cardapio) : '')
                                        ->attrs(['class' => 'moeda']); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::tel('tempo_preparo', 'Tempo de preparo (minutos)')
                                        ->attrs(['data-mask' => '000']); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::select('tipo_carne', 'Escolher ponto da carne', ['0' => 'Não', '1' => 'Sim'])
                                        ->attrs(['class' => 'form-select']); ?>

                                    </div>

                                    <?php if(__isInternacionalizar(Auth::user()->empresa)): ?>
                                    <div class="col-md-3">
                                        <?php echo Form::text('nome_en', 'Nome (em inglês)'); ?>

                                    </div>
                                    <div class="col-md-3">
                                        <?php echo Form::text('nome_es', 'Nome (em espanhol)'); ?>

                                    </div>
                                    <?php endif; ?>

                                    <div class="col-md-12">
                                        <?php echo Form::tel('descricao', 'Descrição')
                                        ->value(isset($item) ? $item->descricao_pt : '')
                                        ->attrs(['class' => '']); ?>

                                    </div>

                                    <?php if(__isInternacionalizar(Auth::user()->empresa)): ?>
                                    <div class="col-md-12">
                                        <?php echo Form::tel('descricao_en', 'Descrição (em inglês)')
                                        ->value(isset($item) ? $item->descricao_en : '')
                                        ->attrs(['class' => '']); ?>

                                    </div>

                                    <div class="col-md-12">
                                        <?php echo Form::tel('descricao_es', 'Descrição (em espanhol)')
                                        ->value(isset($item) ? $item->descricao_es : '')
                                        ->attrs(['class' => '']); ?>

                                    </div>

                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if(__isActivePlan(Auth::user()->empresa, 'Delivery')): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>
                                    <?php if(isset($delivery)): ?>
                                    <?php if($delivery == 1): ?>
                                    <input type="hidden" name="redirect_delivery" value="1">
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <div class="form-check form-switch form-checkbox-success">
                                        <input type="checkbox" name="delivery" class="form-check-input" id="inp-delivery" <?php if(isset($item)): ?> <?php if($item->delivery): ?> checked <?php endif; ?> <?php endif; ?> <?php if(isset($delivery)): ?> <?php if($delivery == 1): ?> checked <?php endif; ?> <?php endif; ?> ><strong>Delivery/MarketPlace</strong>
                                    </div>
                                </h4>
                            </div>

                            <div class="card-body div-delivery d-none m-card" style="margin-top: -40px">

                                <div class="row">

                                    <div class="col-md-2">
                                        <?php echo Form::tel('valor_delivery', 'Valor de Deivery')
                                        ->value((isset($item) && $item->valor_delivery > 0) ? __moeda($item->valor_delivery) : '')
                                        ->attrs(['class' => 'moeda']); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::select('destaque_delivery', 'Destaque', ['0' => 'Não', '1' => 'Sim'])
                                        ->attrs(['class' => 'form-select']); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::select('oferta_delivery', 'Oferta', ['0' => 'Não', '1' => 'Sim'])
                                        ->attrs(['class' => 'form-select']); ?>

                                    </div>

                                    <div class="col-12">
                                        <?php echo Form::textarea('texto_delivery', 'Descrição'); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if(!isset($item)): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>
                                    <?php if(isset($nuvemshop)): ?>
                                    <?php if($nuvemshop == 1): ?>
                                    <input type="hidden" name="redirect_nuvemshop" value="1">
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <div class="form-check form-switch form-checkbox-info">
                                        <input type="checkbox" name="nuvemshop" class="form-check-input" id="inp-nuvemshop" <?php if(isset($item)): ?> <?php if($item->nuvem_shop_id != null): ?> checked <?php endif; ?> <?php endif; ?> <?php if(isset($nuvemshop)): ?> <?php if($nuvemshop == 1): ?> checked <?php endif; ?> <?php endif; ?> ><strong>Nuvem Shop</strong>
                                    </div>
                                </h4>
                            </div>
                            <div class="card-body div-nuvemshop d-none m-card" style="margin-top: -40px">

                                <div class="row">

                                    <div class="col-md-2">
                                        <?php echo Form::tel('nuvem_shop_valor', 'Valor para nuvem shop')
                                        ->attrs(['class' => 'moeda inp-nuvemshop']); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::tel('nuvem_shop_valor_promocional', 'Valor promocional')
                                        ->attrs(['class' => 'moeda']); ?>

                                    </div>

                                    <div class="col-md-4">
                                        <?php echo Form::select('categoria_nuvem_shop', 'Categoria'); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::tel('altura_nuvem_shop', 'Altura')
                                        ->attrs(['class' => 'dimensao inp-nuvemshop']); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::tel('largura_nuvem_shop', 'Largura')
                                        ->attrs(['class' => 'dimensao inp-nuvemshop']); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::tel('comprimento_nuvem_shop', 'Comprimento')
                                        ->attrs(['class' => 'dimensao inp-nuvemshop']); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::tel('peso_nuvem_shop', 'Peso')
                                        ->attrs(['class' => 'peso inp-nuvemshop']); ?>

                                    </div>

                                    <div class="col-12">
                                        <?php echo Form::textarea('texto_nuvem_shop', 'Descrição'); ?>

                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if(!isset($item)): ?>
                <?php if($configMercadoLivre && $configMercadoLivre->access_token): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>
                                    <?php if(isset($mercadolivre)): ?>
                                    <?php if($mercadolivre == 1): ?>
                                    <input type="hidden" name="redirect_mercadolivre" value="1">
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <div class="form-check form-switch form-checkbox-warning">
                                        <input type="checkbox" name="mercadolivre" class="form-check-input" id="inp-mercadolivre" <?php if(isset($item)): ?> <?php if($item->mercado_livre_id != null): ?> checked <?php endif; ?> <?php endif; ?> <?php if(isset($mercadolivre)): ?> <?php if($mercadolivre == 1): ?> checked <?php endif; ?> <?php endif; ?> ><strong>Mercado livre</strong>
                                    </div>
                                </h4>
                            </div>

                            <div class="card-body div-mercadolivre d-none m-card" style="margin-top: -40px">

                                <div class="row">

                                    <div class="col-md-2">
                                        <?php echo Form::tel('mercado_livre_valor', 'Valor do anúcio')
                                        ->value((isset($item) && $item->mercado_livre_valor > 0) ? __moeda($item->mercado_livre_valor) : '')
                                        ->attrs(['class' => 'moeda input-ml']); ?>

                                    </div>

                                    <div class="col-md-4">
                                        <?php echo Form::select('mercado_livre_categoria', 'Categoria do anúncio')
                                        ->attrs(['class' => 'form-select select2 input-ml'])
                                        ->options((isset($item) && $item->mercado_livre_categoria) ? 
                                        [$item->mercado_livre_categoria => $item->categoriaMercadoLivre->nome] : []); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::select('condicao_mercado_livre', 'Condição do item', ['new' => 'Novo', 'used' => 'Usado', 'not_specified' => 'Não especificado'])
                                        ->attrs(['class' => 'form-select input-ml']); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::tel('quantidade_mercado_livre', 'Quantidade disponível')
                                        ->attrs(['data-mask' => '00000', 'class' => 'input-ml'])
                                        ->value((isset($item) && $item->estoque) ? number_format($item->estoque->quantidade,0) : ''); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::select('mercado_livre_tipo_publicacao', 'Tipo publicação')
                                        ->attrs(['class' => 'select2 input-ml']); ?>

                                    </div>

                                    <input type="hidden" id="tipo_publicacao_hidden" value="<?php echo e(isset($item) ? $item->mercado_livre_tipo_publicacao : ''); ?>">

                                    <div class="col-md-6">
                                        <?php echo Form::text('mercado_livre_youtube', 'Link do youtube')
                                        ->attrs(['class' => '']); ?>

                                    </div>

                                    <div class="col-md-3">
                                        <?php echo Form::text('mercado_livre_modelo', 'Modelo')
                                        ->attrs(['class' => '']); ?>

                                    </div>

                                    <div class="col-md-12">
                                        <?php echo Form::textarea('mercado_livre_descricao', 'Descrição')
                                        ->attrs(['rows' => '12']); ?>

                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php endif; ?>

                <?php if(__isActivePlan(Auth::user()->empresa, 'Ecommerce')): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>
                                    <?php if(isset($ecommerce)): ?>
                                    <?php if($ecommerce == 1): ?>
                                    <input type="hidden" name="redirect_ecommerce" value="1">
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <div class="form-check form-switch form-checkbox-info">
                                        <input type="checkbox" name="ecommerce" class="form-check-input" id="inp-ecommerce" <?php if(isset($item)): ?> <?php if($item->ecommerce): ?> checked <?php endif; ?> <?php endif; ?> <?php if(isset($ecommerce)): ?> <?php if($ecommerce == 1): ?> checked <?php endif; ?> <?php endif; ?> ><strong>Ecommerce</strong>
                                    </div>
                                </h4>
                            </div>

                            <div class="card-body div-ecommerce d-none m-card" style="margin-top: -40px">

                                <div class="row">

                                    <div class="col-md-2">
                                        <?php echo Form::tel('valor_ecommerce', 'Valor de Ecommerce')
                                        ->value((isset($item) && $item->valor_ecommerce > 0) ? __moeda($item->valor_ecommerce) : '')
                                        ->attrs(['class' => 'moeda']); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::tel('percentual_desconto', '% de desconto')
                                        ->attrs(['class' => 'percentual']); ?>

                                    </div>

                                    <div class="col-md-8">
                                        <?php echo Form::text('descricao_ecommerce', 'Descrição curta')
                                        ->attrs(['class' => '']); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::select('destaque_ecommerce', 'Destaque', ['0' => 'Não', '1' => 'Sim'])
                                        ->attrs(['class' => 'form-select']); ?>

                                    </div>

                                    <div class="col-12">
                                        <?php echo Form::textarea('texto_ecommerce', 'Descrição longa')
                                        ->attrs(['class' => 'tiny']); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if(__isActivePlan(Auth::user()->empresa, 'Reservas')): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>
                                    <?php if(isset($reserva)): ?>
                                    <?php if($reserva == 1): ?>
                                    <input type="hidden" name="redirect_reserva" value="1">
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <div class="form-check form-switch form-checkbox-light">
                                        <input type="checkbox" name="reserva" class="form-check-input" id="inp-reserva" <?php if(isset($item)): ?> <?php if($item->reserva): ?> checked <?php endif; ?> <?php endif; ?> <?php if(isset($reserva)): ?> <?php if($reserva == 1): ?> checked <?php endif; ?> <?php endif; ?> ><strong>Reserva</strong>
                                    </div>
                                </h4>
                            </div>

                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if(__isActivePlan(Auth::user()->empresa, 'Woocommerce')): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>
                                    <?php if(isset($woocommerce)): ?>
                                    <?php if($woocommerce == 1): ?>
                                    <input type="hidden" name="redirect_woocommerce" value="1">
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <div class="form-check form-switch form-checkbox-dark">
                                        <input type="checkbox" name="woocommerce" class="form-check-input" id="inp-woocommerce" <?php if(isset($item)): ?> <?php if($item->woocommerce): ?> checked <?php endif; ?> <?php endif; ?> <?php if(isset($woocommerce)): ?> <?php if($woocommerce == 1): ?> checked <?php endif; ?> <?php endif; ?> ><strong>Woocommerce</strong>
                                    </div>
                                </h4>
                            </div>

                            <div class="card-body div-woocommerce d-none m-card" style="margin-top: -40px">

                                <div class="row">

                                    <div class="col-md-2">
                                        <?php echo Form::tel('woocommerce_valor', 'Valor para woocommerce')
                                        ->value((isset($item) && $item->woocommerce_valor > 0) ? __moeda($item->woocommerce_valor) : '')
                                        ->attrs(['class' => 'moeda inp-woocommerce']); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::text('woocommerce_slug', 'Slug')
                                        ->value(isset($item) ? $item->woocommerce_slug : '')
                                        ->attrs(['class' => '']); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::select('woocommerce_status', 'Status ', ['publish' => 'Publicado', 'private' => 'Privado', 'pending' => 'Pendente'])
                                        ->attrs(['class' => 'form-select'])
                                        ->value(isset($item) ? $item->woocommerce_status : ''); ?>

                                    </div>

                                    <div class="col-md-2">
                                        <?php echo Form::select('woocommerce_stock_status', 'Status de estoque', ['instock' => 'Em estoque', 'outofstock' => 'Fora de estoque'])
                                        ->attrs(['class' => 'form-select'])
                                        ->value(isset($item) ? $item->woocommerce_stock_status : ''); ?>

                                    </div>

                                    <!-- <div class="col-md-2">
                                        <?php echo Form::tel('largura', 'Largura')
                                        ->attrs(['class' => 'dimensao']); ?>

                                    </div>
                                    <div class="col-md-2">
                                        <?php echo Form::tel('comprimento', 'Comprimento')
                                        ->attrs(['class' => 'dimensao']); ?>

                                    </div>
                                    <div class="col-md-2">
                                        <?php echo Form::tel('altura', 'Altura')
                                        ->attrs(['class' => 'dimensao']); ?>

                                    </div>
                                    <div class="col-md-2">
                                        <?php echo Form::tel('peso', 'Peso')
                                        ->attrs(['class' => 'peso']); ?>

                                    </div> -->

                                    <div class="col-md-4">
                                        <div class="form-group">

                                            <label for="">Categoria</label>
                                            <select class="select2 form-control select2-multiple" name="categorias_woocommerce[]"  multiple="multiple" id="categorias_woocommerce">
                                                <?php $__currentLoopData = $categoriasWoocommerce; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($c->id); ?>"><?php echo e($c->nome); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <?php echo Form::textarea('woocommerce_descricao', 'Descrição')
                                        ->attrs(['rows' => '12', 'class' => 'tiny'])
                                        ->value(isset($item) ? $item->woocommerce_descricao : ''); ?>

                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if(__isActivePlan(Auth::user()->empresa, 'IFood')): ?>
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>
                                    <?php if(isset($ifood)): ?>
                                    <?php if($ifood == 1): ?>
                                    <input type="hidden" name="redirect_ifood" value="1">
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <div class="form-check form-switch form-checkbox-danger">
                                        <input type="checkbox" name="ifood" class="form-check-input" id="inp-ifood" <?php if(isset($item)): ?> <?php if($item->ifood): ?> checked <?php endif; ?> <?php endif; ?> <?php if(isset($ifood)): ?> <?php if($ifood == 1): ?> checked <?php endif; ?> <?php endif; ?> ><strong>IFood</strong>
                                    </div>
                                </h4>
                            </div>

                            <div class="card-body div-ifood d-none m-card" style="margin-top: -40px">

                                <div class="row">

                                    <div class="col-md-2">
                                        <?php echo Form::tel('ifood_valor', 'Valor para IFood')
                                        ->value((isset($item) && $item->ifood_valor > 0) ? __moeda($item->ifood_valor) : '')
                                        ->attrs(['class' => 'moeda inp-ifood']); ?>

                                    </div>

                                    <div class="col-md-3">
                                        <?php echo Form::select('ifood_categoria_id', 'Categoria', ['' => 'Selecione'] + $categoriasProdutoIfood->pluck('nome', 'id')->all())
                                        ->attrs(['class' => 'form-select']); ?>

                                    </div>

                                    <div class="col-md-12">
                                        <?php echo Form::textarea('ifood_descricao', 'Descrição')
                                        ->attrs(['rows' => '12', 'class' => 'tiny'])
                                        ->value(isset($item) ? $item->ifood_descricao : ''); ?>

                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <!-- <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="row">
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div> -->

            </div>
        </div>
    </div>

</div>
<hr class="mt-4">
<?php if(!isset($not_submit)): ?>
<div class="col-12" style="text-align: right;">
    <button type="submit" class="btn btn-success btn-action px-5">Salvar</button>
</div>
<?php endif; ?>
</div>
<?php if(!isset($not_submit)): ?>
<?php $__env->startSection('js'); ?>

<script type="text/javascript" src="/js/produto.js"></script>

<script src="/tinymce/tinymce.min.js"></script>
<script type="text/javascript">
    $(function(){
        tinymce.init({ selector: 'textarea.tiny', language: 'pt_BR'})

        setTimeout(() => {
            $('.tox-promotion, .tox-statusbar__right-container').addClass('d-none')
        }, 1000)
    })

    $(document).on("blur", "#inp-cfop_estadual", function () {

        let v = $(this).val().substring(1,4)
        $("#inp-cfop_outro_estado").val('6'+v)
        $("#inp-cfop_entrada_estadual").val('1'+v)
        $("#inp-cfop_entrada_outro_estado").val('2'+v)
    })

    <?php if(isset($item) && !$item->_ncm): ?>
    swal('Alerta', 'O NCM <?php echo e($item->ncm); ?> não esta cadastrado no sistema, avise o administrador!', 'warning')
    <?php endif; ?>
</script>
<script src="/assets/vendor/twitter-bootstrap-wizard/jquery.bootstrap.wizard.min.js"></script>
<script src="/assets/js/pages/demo.form-wizard.js"></script>
<?php $__env->stopSection(); ?>
<?php endif; ?>
<?php /**PATH /www/wwwroot/erp.royalsistema.com.br/resources/views/produtos/_forms.blade.php ENDPATH**/ ?>