@extends('layouts.app', ['title' => 'Configurações - Notificação de cobrança'])
@section('content')
    <style>
        label[for="inp-crt_onz"],
        label[for="inp-pfx_onz"],
        label[for="inp-key_onz"] {
            margin-right: 10px;
        }
    </style>

    <div class="card mt-1">
        <div class="card-header">
            <h4>Configurações - Notificação de cobrança</h4>
            <div style="text-align: right; margin-top: -35px;">
                <a href="{{ route('notificacao-cobranca.index') }}" class="btn btn-danger btn-sm px-3">
                    <i class="ri-arrow-left-double-fill"></i>Voltar
                </a>
            </div>
        </div>
        <div class="card-body">
            {!! Form::open()->fill($config)->multipart()->post()->route('notificacao-cobranca.configSave') !!}
            <div class="pl-lg-4">

                <h4>Pay Mundi:</h4>

                <div class="row g-2 mb-4">
                    <div class="col-md-6">
                        {!! Form::text('public_key_cashin_paymundi', 'Public Key: Chave pública CASH-IN') !!}
                    </div>

                    <div class="col-md-6">
                        {!! Form::text('secret_key_cashin_paymundi', 'Secret Key: Chave secreta CASH-IN') !!}
                    </div>
                </div>

                <h4>K1 Bank:</h4>

                <div class="row g-2">
                    <div class="col-md-12">
                        {!! Form::file('crt_onz', 'Certificado (.crt)') !!}
                        @if (!empty($config->crt_onz))
                            <a href="{{ asset($config->crt_onz) }}" target="_blank" class="btn btn-primary mb-2 mt-2">Ver
                                arquivo atual (.crt)</a>
                        @endif

                        {!! Form::file('pfx_onz', 'Certificado (.pfx)') !!}
                        @if (!empty($config->pfx_onz))
                            <a href="{{ asset($config->pfx_onz) }}" target="_blank" class="btn btn-primary mb-2 mt-2">Ver
                                arquivo atual (.pfx)</a>
                        @endif

                        {!! Form::file('key_onz', 'Certificado (.key)') !!}
                        @if (!empty($config->key_onz))
                            <a href="{{ asset($config->key_onz) }}" target="_blank" class="btn btn-primary mb-2 mt-2">Ver
                                arquivo atual (.key)</a>
                        @endif
                        <br>
                        {!! Form::text('senha_onz', 'Senha certificado') !!}
                    </div>

                    <div class="col-md-6">
                        {!! Form::text('client_id_onz', 'Client ID') !!}
                    </div>

                    <div class="col-md-6">
                        {!! Form::text('client_secret_onz', 'Client Secret') !!}
                    </div>
                </div>

                <hr>

                <h4>Configurações de cobrança:</h4>

                {!! Form::text('chave_pix', 'Sua chave PIX') !!}
                <br />

                {!! Form::textarea('frase_cobranca', 'Mensagem de cobrança')->attrs(['rows' => '10']) !!}
                <small class="form-text text-muted">
                    Você pode usar as seguintes variáveis na mensagem de cobrança:
                </small>
                <div class="alert alert-info mt-2">
                    <ul>
                        <li><b>@cliente</b>: Nome do cliente</li>
                        <li><b>@dataVencimento</b>: Data de vencimento</li>
                        <li><b>@valor</b>: Valor da cobrança</li>
                        <li><b>@codigoPix</b>: Código PIX para pagamento</li>
                    </ul>
                </div>
            </div>
            <hr class="mt-4">
            <div class="col-12" style="text-align: right;">
                <button type="submit" class="btn btn-success px-5" id="btn-store">Salvar</button>
            </div>

            {!! Form::close() !!}
        </div>

    </div>
@endsection
