<?php
session_start();
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type');

// Verificar se o usuário está logado
if (!isset($_SESSION['usuario_id'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Usuário não autenticado'
    ]);
    exit;
}

// Capturar erros fatais
register_shutdown_function(function() {
    $error = error_get_last();
    if ($error && $error['type'] === E_ERROR) {
        echo json_encode([
            'success' => false,
            'message' => 'Erro fatal: ' . $error['message']
        ]);
    }
});

try {
    require_once 'db/conexao.php';
    
    // Filtrar tarefas apenas do usuário logado
    $stmt = $pdo->prepare("SELECT * FROM tarefas WHERE usuario_id = ? ORDER BY data DESC, criado_em DESC");
    $stmt->execute([$_SESSION['usuario_id']]);
    $tarefas = $stmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'data' => $tarefas
    ]);
} catch(PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro ao listar tarefas: ' . $e->getMessage()
    ]);
} catch(Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Erro geral: ' . $e->getMessage()
    ]);
}
?>