<?php
session_start();
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type');

// Verificar se o usuário está logado
if (!isset($_SESSION['usuario_id'])) {
    echo json_encode([
        'success' => false,
        'message' => 'Usuário não autenticado'
    ]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        require_once 'db/conexao.php';
        
        $input = json_decode(file_get_contents('php://input'), true);
        
        $titulo = trim($input['titulo'] ?? '');
        $data = $input['data'] ?? '';
        $descricao = trim($input['descricao'] ?? '');
        
        if (empty($titulo) || empty($data)) {
            echo json_encode([
                'success' => false,
                'message' => 'Título e data são obrigatórios'
            ]);
            exit;
        }
        
        // Incluir o usuario_id na inserção
        $stmt = $pdo->prepare("INSERT INTO tarefas (titulo, data, descricao, usuario_id) VALUES (?, ?, ?, ?)");
        $stmt->execute([$titulo, $data, $descricao, $_SESSION['usuario_id']]);
        
        echo json_encode([
            'success' => true,
            'message' => 'Tarefa adicionada com sucesso',
            'id' => $pdo->lastInsertId()
        ]);
    } catch(PDOException $e) {
        echo json_encode([
            'success' => false,
            'message' => 'Erro ao adicionar tarefa: ' . $e->getMessage()
        ]);
    } catch(Exception $e) {
        echo json_encode([
            'success' => false,
            'message' => 'Erro geral: ' . $e->getMessage()
        ]);
    }
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Método não permitido'
    ]);
}
?>