<?php
// Configuração de banco - ajuste se necessário
const DB_HOST = 'localhost';
const DB_USER = 'root';
const DB_PASS = '';
const DB_NAME = 'slide';

function get_db_connection(): ?mysqli {
    // Conecta ao servidor
    $serverConn = @new mysqli(DB_HOST, DB_USER, DB_PASS);
    if ($serverConn->connect_error) {
        error_log('Erro MySQL (server): ' . $serverConn->connect_error);
        return null;
    }

    // Cria BD se não existir
    $serverConn->query('CREATE DATABASE IF NOT EXISTS `' . DB_NAME . '` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci');

    // Conecta ao BD específico
    $conn = @new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    if ($conn->connect_error) {
        error_log('Erro MySQL (db): ' . $conn->connect_error);
        return null;
    }

    // Cria tabela se não existir
    $create = 'CREATE TABLE IF NOT EXISTS `videos` (
        `id` INT AUTO_INCREMENT PRIMARY KEY,
        `nome_arquivo` VARCHAR(255) NOT NULL,
        `caminho` VARCHAR(255) NOT NULL,
        `data_envio` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4';

    if (!$conn->query($create)) {
        error_log('Falha ao criar tabela: ' . $conn->error);
    }

    return $conn;
}