<?php

namespace CloudDfe\SdkPHP;

class Client
{
    /**
     * @var int
     */
    protected $ambiente = 2;
    /**
     * @var array
     */
    protected $url = [
        'api' => [
            '1' => 'https://api.integranotas.com.br/v1',
            '2' => 'https://hom-api.integranotas.com.br/v1'
        ]
    ];
    /**
     * @var string
     */
    protected $token = "";
    /**
     * @var array
     * [
     *    "debug" => false,
     *    "timeout" => 10,
     *    "http_version" => "1.1",
     *    "port" => 443
     * ]
     */
    protected $options = [];
    /**
     * @var string
     */
    protected $uri = "";
    /**
     * @var array
     */
    protected $params = [];
    /**
     * @var HttpCurl
     */
    protected $client;

    /**
     * Client constructor.
     * @param array $params
     * @param string $direction
     * @throws \Exception
     */
    public function __construct($params = [], $direction = "api")
    {
        $this->params = $params;
        if (empty($params)) {
            throw new \Exception("Devem ser passados os parametros básicos.");
        }
        if (!in_array($params["ambiente"], [1, 2])) {
            throw new \Exception("O ambiente deve ser 1-produção ou 2-homologação.");
        }
        if (empty($params["token"])) {
            throw new \Exception("O token é obrigatorio.");
        }
        $this->ambiente = !empty($params["ambiente"]) ? $params["ambiente"] : 2;
        $this->token = !empty($params["token"]) ? $params["token"] : "";
        $this->options = !empty($params["options"]) ? $params["options"] : [];
        $debug = false;
        if (!empty($params["options"])) {
            $debug = $params["options"]["debug"] == true ? true : false;
        }
        $this->uri = $this->url[$direction][$this->ambiente];
        if (!empty($params["options"]["url"])) {
            $this->uri = $params["options"]["url"];
        }
        $this->client = new HttpCurl([
            "debug" => $debug,
            "base_uri" => $this->uri,
            "token" => $this->token,
            "options" => $this->options
        ]);
    }

    /**
     * @param string $route
     * @param array $payload
     * @return \stdClass
     * @throws \Exception
     */
    public function sendMultpart($route, $payload)
    {
        return json_decode($this->client->sendMultipart($route, $payload));
    }

    /**
     * Envia os dados ao servidor
     * @param string $method
     * @param string $route
     * @param array $payload
     * @return \stdClass
     */
    public function send($method, $route, $payload = [])
    {
        return json_decode($this->client->request($method, $route, $payload));
    }
}
