<?php $__env->startSection('content'); ?>
<div class="mt-3">
    <div class="row">
        <div class="card">
            <?php if($item->status == 0): ?>
            <a href="<?php echo e(route('caixa.create')); ?>" class="btn btn-success">
                <i class="ri-add-circle-fill"></i>
                Abrir Caixa
            </a>
            <?php else: ?>
            <div class="card-body">
                <div class="card-body mt-1">
                    <div class="bg-light-subtle border-top border-bottom border-light">
                        <div class="row text-center">

                            <?php if(__countLocalAtivo() > 1): ?>
                            <h5 class="mt-2">Local: <strong class="text-danger"><?php echo e($item->localizacao ? $item->localizacao->descricao : ''); ?></strong></h5>
                            <?php endif; ?>
                            <div class="col">
                                <p class="text-muted mt-3"><i class="ri-shield-user-fill"></i> Usuário</p>
                                <h3 class="fw-normal mb-3">
                                    <span><?php echo e($item->usuario->name); ?></span>
                                </h3>
                            </div>
                            <div class="col">
                                <p class="text-muted mt-3"><i class="ri-file-list-2-line"></i> Data de Abertura</p>
                                <h3 class="fw-normal mb-3">
                                    <span><?php echo e(__data_pt($item->created_at, 1)); ?></span>
                                </h3>
                            </div>
                            <div class="col">
                                <p class="text-muted mt-3"><i class="ri-money-dollar-circle-line"></i> Valor de Abertura</p>
                                <h3 class="fw-normal mb-3">
                                    <span><?php echo e(__moeda($item->valor_abertura)); ?></span>
                                </h3>
                            </div>
                            <?php if($item->contaEmpresa): ?>
                            <div class="col">
                                <p class="text-muted mt-3"><i class="ri-money-dollar-circle-line"></i> Conta</p>
                                <h3 class="fw-normal mb-3">
                                    <span><?php echo e($item->contaEmpresa->nome); ?></span>
                                </h3>
                            </div>
                            <?php endif; ?>
                        </div>

                        <?php if($item->observacao): ?>
                        <div class="row">
                            <div class="col-12 m-3 text-primary">
                                <?php echo e($item->observacao); ?>

                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="row mt-3">
                    <h3 class="text-center">Total por Tipo de Pagamento Vendas:</h3>
                    <?php $__currentLoopData = $somaTiposPagamento; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($tp > 0): ?>
                    <div class="col-sm-4 col-lg-3 col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <h3 class="">
                                    <?php echo e(App\Models\Nfce::getTipoPagamento($key)); ?>

                                </h3>
                            </div>
                            <?php
                            if($key == '01') $somaDinheiro = $tp;
                            ?>
                            <div class="card-body">
                                <h4 class="text-success">R$ <?php echo e(__moeda($tp)); ?></h4>
                            </div>
                        </div>
                    </div>
                    
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div class="row text-center mt-4">
                        <div class="col-md-4">
                            <div class="card">
                                <h3>Total de vendas: <strong class="text-danger">R$<?php echo e(__moeda($totalVendas)); ?></strong></h3>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <h3>Total de compras: <strong class="text-danger">R$<?php echo e(__moeda($totalCompras)); ?></strong></h3>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <h3>Venda de produtos: <strong class="text-danger">R$<?php echo e(__moeda($totalVendas-$somaServicos)); ?></strong></h3>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="card">
                                <h3>Venda de serviços: <strong class="text-danger">R$<?php echo e(__moeda($somaServicos)); ?></strong></h3>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <h3>Total de registros: <strong class="text-danger"><?php echo e(sizeof($data)); ?></strong></h3>
                            </div>
                        </div>
                    </div>
                </div>
                <h3 class="text-center mt-3">Movimentações do caixa</h3>
                <div class="col-md-12 mt-4 table-responsive">
                    <div class="table-responsive-sm">
                        <table class="table table-centered">
                            <thead class="table-dark">
                                <tr>
                                    <th>Tipo</th>
                                    <th>Data</th>
                                    <th>Valor</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $somaReceita = 0; 
                                $somaDespesa = 0; 
                                ?>
                                <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($i->tipo); ?></td>
                                    <td><?php echo e(__data_pt($i->created_at, 1)); ?></td>
                                    <?php if($i->tipo != 'OS'): ?>
                                    <td>
                                        <strong>R$ <?php echo e(__moeda($i->total)); ?></strong>
                                        <br>
                                        <?php if($i->receita == 1): ?>
                                        <strong class="text-success">Receita</strong>
                                        <?php else: ?>
                                        <strong class="text-danger">Despesa</strong>
                                        <?php endif; ?>
                                    </td>
                                    <?php else: ?>
                                    <td>
                                        <strong>R$ <?php echo e(__moeda($i->valor)); ?></strong>
                                        <br>
                                        <?php if($i->receita == 1): ?>
                                        <strong class="text-success">Receita</strong>
                                        <?php else: ?>
                                        <strong class="text-danger">Despesa</strong>
                                        <?php endif; ?>
                                    </td>

                                    <?php endif; ?>
                                </tr>
                                <?php
                                if($i->receita == 1 && $i->tipo != 'OS'){
                                    $somaReceita += $i->total;
                                }elseif($i->receita == 1 && $i->tipo == 'OS'){
                                    $somaReceita += $i->valor;
                                }else{
                                    $somaDespesa += $i->total;
                                }
                                ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="text-center">Nenhum registro</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-12 col-md-3">
                        <div class="card card-custom gutter-b bg-light-info">
                            <div class="card-body">
                                <h4 class="card-title">Total Receita: <strong class="text-success">R$ <?php echo e(__moeda($somaReceita)); ?></strong></h4>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-3">
                        <div class="card card-custom gutter-b bg-light-info">
                            <div class="card-body">
                                <h4 class="card-title">Total Despesa: <strong class="text-danger">R$ <?php echo e(__moeda($somaDespesa)); ?></strong></h4>
                            </div>
                        </div>
                    </div>
                </div>

                <h3 class="text-center mt-5">Movimentações de Recebimentos</h3>
                <div class="col-md-12 mt-4 table-responsive">
                    <div class="table-responsive-sm">
                        <table class="table table-centered">
                            <thead class="table-dark">
                                <tr>
                                    <th>Tipo</th>
                                    <th>Data</th>
                                    <th>Valor</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $contas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($i->tipo); ?></td>
                                    <td><?php echo e(__data_pt($i->created_at, 0)); ?></td>
                                    <td><?php echo e(__moeda($i->valor_integral)); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="3" class="text-center">Nenhum registro</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="row mt-3">
                    <div class="col-12 col-xl-6">
                        <div class="card card-custom gutter-b bg-light-info">
                            <div class="card-body">
                                <h3 class="card-title">Total Recebido:</h3>
                                <?php if(sizeof($receber) > 0): ?>
                                <h4>Valor: R$ <?php echo e(__moeda($receber->sum('valor_integral'))); ?></h4>
                                <?php else: ?>
                                <h4>R$ 0,00</h4>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-xl-6">
                        <div class="card card-custom gutter-b bg-light-danger">
                            <div class="card-body">
                                <h3 class="card-title">Total Pago:</h3>
                                <?php if(sizeof($pagar) > 0): ?>
                                <h4>Valor: R$ <?php echo e(__moeda($pagar->sum('valor_integral'))); ?></h4>
                                <?php else: ?>
                                <h4>R$ 0,00</h4>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                $somaSuprimento = 0;
                $somaSangria = 0;
                ?>
                <div class="row mt-3">
                    <div class="col-12 col-xl-6">
                        <div class="card card-custom gutter-b bg-light-info">
                            <div class="card-header">
                                <h4 class="card-title">Suprimentos</h4>
                            </div>
                            <div class="card-body">
                                <table class="table">
                                    <thead class="table-info">
                                        <tr>
                                            <th>Data</th>
                                            <th>Valor</th>
                                            <th>Observação</th>
                                            <?php if($item->contaEmpresa): ?>
                                            <th>Conta</th>
                                            <?php endif; ?>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $suprimentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e(__data_pt($s->created_at)); ?></td>
                                            <td><?php echo e(__moeda($s->valor)); ?></td>
                                            <td>
                                                <?php echo e($s->observacao); ?>

                                            </td>
                                            <?php if($s->contaEmpresa): ?>
                                            <td>
                                                <?php echo e($s->contaEmpresa->nome); ?>

                                            </td>
                                            <?php endif; ?>

                                            <td>
                                                <form action="<?php echo e(route('suprimento.destroy', $s->id)); ?>" method="post" id="form-suprimento-<?php echo e($s->id); ?>">
                                                    <?php echo method_field('delete'); ?>
                                                    <?php echo csrf_field(); ?>
                                                    <a target="_blank" href="<?php echo e(route('suprimento.print', [$s->id])); ?>" class="btn btn-dark btn-sm">
                                                        <i class="ri-printer-line"></i>
                                                    </a>
                                                    <button type="button" class="btn btn-danger btn-sm btn-delete"><i class="ri-delete-bin-line"></i></button>
                                                </form>
                                            </td>

                                            <?php
                                            $somaSuprimento += $s->valor;
                                            ?>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="5">Nenhum registro</td>
                                        </tr>
                                        <?php endif; ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-xl-6">
                        <div class="card card-custom gutter-b bg-light-danger">

                            <div class="card-header">
                                <h4 class="card-title">Sangrias</h4>
                            </div>
                            <div class="card-body">
                                <table class="table">
                                    <thead class="table-danger">
                                        <tr>
                                            <th>Data</th>
                                            <th>Valor</th>
                                            <th>Observação</th>
                                            <?php if($item->contaEmpresa): ?>
                                            <th>Conta</th>
                                            <?php endif; ?>
                                            <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $sangrias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e(__data_pt($s->created_at)); ?></td>
                                            <td><?php echo e(__moeda($s->valor)); ?></td>
                                            <td>
                                                <?php echo e($s->observacao); ?>

                                            </td>
                                            <?php if($s->contaEmpresa): ?>
                                            <td>
                                                <?php echo e($s->contaEmpresa->nome); ?>

                                            </td>
                                            <?php endif; ?>
                                            <td>
                                                <form action="<?php echo e(route('sangria.destroy', $s->id)); ?>" method="post" id="form-sangria-<?php echo e($s->id); ?>">
                                                    <?php echo method_field('delete'); ?>
                                                    <?php echo csrf_field(); ?>
                                                    <a target="_blank" href="<?php echo e(route('sangria.print', [$s->id])); ?>" class="btn btn-dark btn-sm">
                                                        <i class="ri-printer-line"></i>
                                                    </a>
                                                    <button type="button" class="btn btn-danger btn-sm btn-delete"><i class="ri-delete-bin-line"></i></button>
                                                </form>
                                                
                                            </td>

                                            <?php
                                            $somaSangria += $s->valor;
                                            ?>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="5">Nenhum registro</td>
                                        </tr>
                                        <?php endif; ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row m-3">
                <div class="col-md-4">
                    <h3 >Total Entrada: 
                        <strong class="text-primary">R$ <?php echo e(__moeda($totalVendas + $somaSuprimento + $receber->sum('valor_integral'))); ?></strong>
                    </h3>
                </div>
                <div class="col-md-4">
                    <h3>Total Saída: 
                        <strong class="text-primary">R$ <?php echo e(__moeda($somaSangria + $pagar->sum('valor_integral'))); ?></strong>
                    </h3>
                </div>
                <div class="col-md-4">
                    <h3>Saldo: <strong class="text-success">R$ <?php echo e(__moeda($totalVendas + $somaSuprimento + $valor_abertura + $receber->sum('valor_integral') - $somaSangria - $pagar->sum('valor_integral'))); ?></strong></h3>
                </div>
            </div>
            <div class="col-md-3 m-3">
                <?php if(sizeof($data) == 0): ?>
                <h3>Caixa sem movimentação!</h3>
                <?php else: ?>

                <?php if(sizeof($contasEmpresa) == 0): ?>
                <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#fechamento_caixa">
                    <i class="ri-add-circle-fill"></i>
                    Fechar Caixa
                </button>
                <?php else: ?>
                <a class="btn btn-danger" href="<?php echo e(route('caixa.fechar-conta', [$item->id])); ?>">
                    <i class="ri-add-circle-fill"></i>
                    Fechar Caixa
                </a>
                <?php endif; ?>

                <?php endif; ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php echo $__env->make('modals._fechamento_caixa', ['not_submit' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', ['title' => 'Caixa'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /www/wwwroot/erp.royalsistema.com.br/resources/views/caixa/index.blade.php ENDPATH**/ ?>