<?php

namespace App\Http\Middleware;

use App\Enums\UserRole;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AdminAccess
{
    public function handle(Request $request, Closure $next): Response
    {
        if (auth()->user()?->role !== UserRole::ADMIN) {
            auth()->logout();
            return redirect()->route('filament.admin.auth.login')->with('error', 'Você não tem permissão para acessar o painel administrativo.');
        }

        return $next($request);
    }
}
