<?php

namespace App\Filament\User\Resources\FormasPagamentoResource\Pages;

use App\Filament\User\Resources\FormasPagamentoResource;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use Filament\Notifications\Notification;
use Filament\Actions\Action;


class CreateFormasPagamento extends CreateRecord
{
    protected static string $resource = FormasPagamentoResource::class;

    public function getTitle(): string
    {
        return 'Nova Forma de Pagamento';
    } 

    protected function getCreateFormAction(): Action
    {
        return parent::getCreateFormAction()
            ->label('Criar Forma de Pagamento')
            ->icon('heroicon-o-plus-circle')
            ->color('primary');
    }

    protected function getCreateAnotherFormAction(): Action
    {
        return parent::getCreateAnotherFormAction()
            ->label('Criar e criar outro')
            ->icon('heroicon-o-plus')
            ->color('primary');
    }

    protected function getCreatedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->color('success')
            ->icon('heroicon-o-check-circle')
            ->title('Forma de Pagamento criada!')
            ->body('A nova forma de pagamento foi cadastrada com sucesso')
            ->duration(5000);
    }

    protected function getCancelFormAction(): Action
    {
        return parent::getCancelFormAction()
            ->label('Cancelar')
            ->icon('heroicon-o-x-mark')
            ->color('warning');
    } 


    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
}
